/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.projecter;

import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;
import skyview.geometry.projecter.CarStraddle;
import skyview.geometry.projecter.Straddle;

public final class Car
extends Projecter {
    private Straddle myStraddler = new CarStraddle(this);

    @Override
    public String getName() {
        return "Car";
    }

    @Override
    public String getDescription() {
        return "Transform from the celestial sphere to the plane described by Lon/Lat directly";
    }

    @Override
    public Deprojecter inverse() {
        return new CarDeproj();
    }

    @Override
    public double getXTiling() {
        return Math.PI * 2;
    }

    @Override
    public double getYTiling() {
        return Math.PI * 2;
    }

    @Override
    public boolean isInverse(Transformer t) {
        return t.getName().equals("CarDeproj");
    }

    @Override
    public double[] shadowPoint(double x, double y) {
        if (x > 0.0) {
            return new double[]{x - Math.PI * 2, y};
        }
        if (x < 0.0) {
            return new double[]{x + Math.PI * 2, y};
        }
        return new double[]{Math.PI * 2, y};
    }

    @Override
    public final void transform(double[] sphere, double[] plane) {
        if (Double.isNaN(sphere[2])) {
            plane[0] = Double.NaN;
            plane[1] = Double.NaN;
        } else {
            plane[0] = Math.atan2(sphere[1], sphere[0]);
            plane[1] = Math.asin(sphere[2]);
        }
    }

    @Override
    public boolean allValid() {
        return true;
    }

    @Override
    public boolean straddle(double[][] vertices) {
        return this.myStraddler.straddle(vertices);
    }

    @Override
    public boolean straddleable() {
        return true;
    }

    @Override
    public double[][][] straddleComponents(double[][] inputs) {
        return this.myStraddler.straddleComponents(inputs);
    }

    public class CarDeproj
    extends Deprojecter {
        @Override
        public String getName() {
            return "CarDeproj";
        }

        @Override
        public boolean isInverse(Transformer t) {
            return t.getName().equals("Car");
        }

        @Override
        public String getDescription() {
            return "Transform from the Lat/Lon to the corresponding unit vector.";
        }

        @Override
        public Projecter inverse() {
            return Car.this;
        }

        public double getXTiling() {
            return Math.PI * 2;
        }

        public double getYTiling() {
            return Math.PI * 2;
        }

        @Override
        public final void transform(double[] plane, double[] sphere) {
            if (Double.isNaN(plane[0])) {
                sphere[0] = Double.NaN;
                sphere[1] = Double.NaN;
                sphere[2] = Double.NaN;
            } else {
                double sr = Math.sin(plane[0]);
                double cr = Math.cos(plane[0]);
                double sd = Math.sin(plane[1]);
                double cd = Math.cos(plane[1]);
                sphere[0] = cr * cd;
                sphere[1] = sr * cd;
                sphere[2] = sd;
            }
        }
    }
}

