/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.projecter;

import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;
import skyview.geometry.Util;
import skyview.geometry.projecter.OctaStraddle;
import skyview.geometry.projecter.Straddle;

public class Tea
extends Projecter {
    private static final double sqrt2 = Math.sqrt(2.0);
    private static final double rat = Math.sqrt(Math.PI);
    private Straddle myStraddler = new OctaStraddle(rat, this);
    private double[] copy = new double[3];

    @Override
    public String getName() {
        return "Tea";
    }

    @Override
    public String getDescription() {
        return "Equal Areal Projection based with TOAST topology";
    }

    @Override
    public boolean isInverse(Transformer obj) {
        return obj instanceof TeaDeproj;
    }

    @Override
    public Deprojecter inverse() {
        return new TeaDeproj();
    }

    @Override
    public void transform(double[] unit, double[] plane) {
        boolean dir = true;
        double delta = 1.0;
        System.arraycopy(unit, 0, this.copy, 0, 3);
        double signx = 1.0;
        double signy = 1.0;
        if (this.copy[0] < 0.0) {
            this.copy[0] = -this.copy[0];
            signx = -1.0;
        }
        if (this.copy[1] < 0.0) {
            this.copy[1] = -this.copy[1];
            signy = -1.0;
        }
        boolean flipped = false;
        if (this.copy[2] < 0.0) {
            this.copy[2] = -this.copy[2];
            flipped = true;
        }
        double t = Math.sqrt((1.0 - this.copy[2]) / 2.0);
        double lat = Math.atan2(this.copy[1], this.copy[0]);
        double u = 4.0 * t * lat / Math.PI;
        double x = t * sqrt2 - u / sqrt2;
        double y = u / Math.sqrt(2.0);
        if (flipped) {
            u = 1.0 - x;
            x = t = 1.0 - y;
            y = u;
        }
        plane[0] = rat * (x *= signx);
        plane[1] = rat * (y *= signy);
    }

    public static void main(String[] args) throws Exception {
        double x = Double.parseDouble(args[0]);
        double y = Double.parseDouble(args[1]);
        double[] pos = new double[]{x, y};
        Tea forward = new Tea();
        Transformer back = ((Transformer)forward).inverse();
        double[] unit = new double[3];
        double[] npos = new double[2];
        back.transform(pos, unit);
        ((Transformer)forward).transform(unit, npos);
        double[] coords = Util.coord(unit);
        System.out.println("Original map coordinates: " + pos[0] + " " + pos[1] + "\n" + "Transform to vector:      " + unit[0] + " " + unit[1] + " " + unit[2] + "\n" + "At sphericalccoordinates: " + Math.toDegrees(coords[0]) + " " + Math.toDegrees(coords[1]) + "\n" + "Back to map coordinates:  " + npos[0] + " " + npos[1]);
    }

    @Override
    public boolean straddleable() {
        return true;
    }

    @Override
    public boolean straddle(double[][] vertices) {
        return this.myStraddler.straddle(vertices);
    }

    @Override
    public double[][][] straddleComponents(double[][] vertices) {
        return this.myStraddler.straddleComponents(vertices);
    }

    public class TeaDeproj
    extends Deprojecter {
        @Override
        public String getName() {
            return "TeaDeproj";
        }

        @Override
        public String getDescription() {
            return "Deproject from an equal area TOAST style plane to the unit sphere";
        }

        @Override
        public boolean isInverse(Transformer obj) {
            return obj instanceof Tea;
        }

        @Override
        public Transformer inverse() {
            return Tea.this;
        }

        @Override
        public void transform(double[] plane, double[] sphere) {
            double t;
            double x;
            double xflip = 1.0;
            double yflip = 1.0;
            double zflip = 1.0;
            double y = plane[1] / rat;
            for (x = plane[0] / rat; x > 1.0; x -= 2.0) {
                xflip *= -1.0;
            }
            while (x < -1.0) {
                xflip *= -1.0;
                x += 2.0;
            }
            while (y > 1.0) {
                yflip *= -1.0;
                y -= 2.0;
            }
            while (y < -1.0) {
                yflip *= -1.0;
                y += 2.0;
            }
            if (x < 0.0) {
                xflip *= -1.0;
                x = -x;
            }
            if (y < 0.0) {
                yflip *= -1.0;
                y = -y;
            }
            if (x > 1.0 - y) {
                zflip = -1.0;
                t = x;
                x = 1.0 - y;
                y = 1.0 - t;
            }
            t = (x + y) / sqrt2;
            double u = sqrt2 * y;
            double z = 0.0;
            if (t > 0.0) {
                double l = 0.7853981633974483 * u / t;
                z = 1.0 - 2.0 * t * t;
                x = Math.cos(l) * z;
                y = Math.sin(l) * z;
            } else {
                z = 1.0;
                x = 0.0;
                y = 0.0;
            }
            sphere[0] = x *= xflip;
            sphere[1] = y *= yflip;
            sphere[2] = z *= zflip;
        }
    }
}

