/*
 * Decompiled with CFR 0.152.
 */
package skyview.process;

import java.util.ArrayList;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import skyview.executive.Settings;
import skyview.geometry.Converter;
import skyview.geometry.DepthSampler;
import skyview.geometry.Sampler;
import skyview.geometry.Transformer;
import skyview.geometry.sampler.Clip;
import skyview.process.ExposureFinder;
import skyview.process.Processor;
import skyview.process.expfinder.Null;
import skyview.survey.Image;
import skyview.util.Utilities;

public class AddingMosaicker
implements Processor {
    private ArrayList<String> usedImageNames = new ArrayList();
    private ArrayList<Integer> usedPixelCount = new ArrayList();
    private Clip overlapTester = new Clip();
    private int pixCount = 0;
    private int oWidth;
    private int oHeight;
    private int iWidth;
    private int iHeight;
    private double minEdge = 0.0;
    private double maxRad = 1.0E100;
    private double scaleRatio;
    private boolean radCheck = false;
    private double icx;
    private double icy;
    private ExposureFinder expFinder;

    @Override
    public String getName() {
        return "AddingMosaicker";
    }

    @Override
    public String getDescription() {
        return "Create a new image by adding all overlapping images.";
    }

    public AddingMosaicker() {
        String finder = Settings.get("ExposureFinder");
        try {
            if (finder != null) {
                this.expFinder = (ExposureFinder)Utilities.newInstance(finder, "skyview.process.expfinder");
            }
        }
        catch (Exception e) {
            System.err.println("  Error instantiating exposure finder " + finder + ": " + e);
        }
        this.expFinder = new Null();
        if (Settings.has("MinEdge")) {
            try {
                this.minEdge = Double.parseDouble(Settings.get("minEdge"));
            }
            catch (Exception e) {
                System.err.println("  Error parsing minEdge");
            }
        }
        if (Settings.has("MaxRad")) {
            try {
                this.maxRad = Double.parseDouble(Settings.get("maxRad"));
                this.radCheck = true;
            }
            catch (Exception e) {
                System.err.println("  Error parsing MaxRadius");
            }
        }
    }

    @Override
    public void process(Image[] input, Image output, int[] osource, Sampler samp, DepthSampler dSampler) {
        int height;
        int width;
        this.oWidth = width = output.getWidth();
        this.oHeight = height = output.getHeight();
        int depth = output.getDepth();
        samp.setOutput(output);
        output.setAccumulate(true);
        if (depth == 0) {
            depth = 1;
        }
        double[] exposure = new double[width * height];
        int imgCnt = 0;
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == null) continue;
            ++imgCnt;
            this.pixCount = 0;
            this.processImage(input[i], output, exposure, samp, dSampler);
            if (this.pixCount > 0) {
                this.usedImageNames.add(input[i].getName());
                this.usedPixelCount.add(this.pixCount);
                System.err.println("  Image " + imgCnt + " has overlap on " + this.pixCount + " pixels.");
            }
            input[i].clearData();
        }
        double[] data = output.getDataArray();
        int offset = 0;
        int expCnt = 0;
        if (!Settings.has("nonormalize")) {
            for (int i = 0; i < exposure.length; ++i) {
                for (int k = 0; k < depth; ++k) {
                    if (exposure[i] > 0.0) {
                        ++expCnt;
                        int n = offset;
                        data[n] = data[n] / exposure[i];
                    } else {
                        data[i] = -1.0;
                    }
                    ++offset;
                }
            }
        }
        System.err.println("  Total of " + expCnt / depth + " pixels out of " + height * width + " exposed.");
    }

    private void processImage(Image input, Image output, double[] exposure, Sampler samp, DepthSampler dsamp) {
        this.iWidth = input.getWidth();
        this.iHeight = input.getHeight();
        Converter cv = new Converter();
        Converter clipTrans = null;
        try {
            cv.add(output.getTransformer().inverse());
            cv.add(input.getTransformer());
            samp.setTransform(cv);
            clipTrans = cv.inverse();
        }
        catch (Exception e) {
            System.err.println("  Transformation exception for image.");
            return;
        }
        double[][] corners = new double[][]{{this.minEdge, (double)this.iWidth - this.minEdge, (double)this.iWidth - this.minEdge, this.minEdge}, {this.minEdge, this.minEdge, (double)this.iHeight - this.minEdge, (double)this.iHeight - this.minEdge}};
        double area = 0.0;
        try {
            clipTrans.transform(corners, corners);
            area = this.overlapTester.clipRectPoly(0.0, 0.0, this.oWidth, this.oHeight, corners[0], corners[1]);
        }
        catch (Exception e) {
            System.err.println("Error in tranformation testeing image");
            return;
        }
        if (area <= 0.0) {
            return;
        }
        input.validate();
        if (dsamp != null) {
            input = dsamp.sample(input);
        }
        this.expFinder.setImage(input, output, samp);
        samp.setInput(input);
        if (this.radCheck) {
            double[] cent = new double[]{(double)this.iWidth / 2.0, (double)this.iHeight / 2.0};
            ((Transformer)clipTrans).transform(cent, cent);
            this.icx = cent[0];
            this.icy = cent[1];
        }
        this.scaleRatio = input.getWCS().getScale() / output.getWCS().getScale();
        this.processOverlap(this.overlapTester, samp, exposure);
    }

    private void processOverlap(Clip clipTrans, Sampler samp, double[] exposure) {
        double[] x = clipTrans.lastX();
        double[] y = clipTrans.lastY();
        double maxR = this.maxRad * this.scaleRatio;
        maxR *= maxR;
        double minY = y[0];
        double maxY = y[0];
        for (int i = 1; i < y.length; ++i) {
            if (y[i] < minY) {
                minY = y[i];
                continue;
            }
            if (!(y[i] > maxY)) continue;
            maxY = y[i];
        }
        int y0 = (int)(minY + 0.5);
        int ye = (int)(maxY + 0.5);
        for (int j = y0; j < ye; ++j) {
            int[] xlim = this.getXlim((double)j + 0.5, x, y);
            for (int i = xlim[0]; i < xlim[1]; ++i) {
                double dy;
                double dx;
                if (this.radCheck && (dx = (double)i + 0.5 - this.icx) * dx + (dy = (double)j + 0.5 - this.icy) * dy > maxR) continue;
                this.processPixel(samp, exposure, i, j);
            }
        }
    }

    private void processPixel(Sampler samp, double[] exposure, int i, int j) {
        int pixel = i + j * this.oWidth;
        samp.sample(pixel);
        int n = pixel;
        exposure[n] = exposure[n] + this.expFinder.getExposure(pixel);
        ++this.pixCount;
    }

    private int[] getXlim(double yval, double[] x, double[] y) {
        int count = 0;
        double[] xs = new double[2];
        for (int i = 0; i < x.length; ++i) {
            double p;
            double x0 = x[i];
            double y0 = y[i];
            double xe = x[(i + 1) % x.length];
            double ye = y[(i + 1) % x.length];
            if (y0 == ye || !((p = (yval - y0) / (ye - y0)) >= 0.0) || !(p < 1.0)) continue;
            xs[count] = p * (xe - x0) + x0;
            ++count;
        }
        if (count < 2) {
            return new int[]{1, 0};
        }
        if (xs[0] < xs[1]) {
            return new int[]{(int)(xs[0] + 0.5), (int)(xs[1] + 0.5)};
        }
        return new int[]{(int)(xs[1] + 0.5), (int)(xs[0] + 0.5)};
    }

    @Override
    public void updateHeader(Header h) {
        try {
            h.insertHistory("");
            h.insertHistory("Image mosaicking using skyview.geometry.Mosaicker");
            h.insertHistory("");
            String[] names = this.usedImageNames.toArray(new String[0]);
            if (names.length == 0) {
                h.insertComment("");
                h.insertComment("************************************");
                h.insertComment("** No valid pixels for mosaicking **");
                h.insertComment("************************************");
                h.insertComment("");
                h.addValue("SV_ERROR", "No valid pixels found in mosaicker", "");
            }
            for (int i = 0; i < this.usedImageNames.size(); ++i) {
                h.insertHistory("  Used " + this.usedPixelCount.get(i) + " pixels from " + this.usedImageNames.get(i));
            }
            h.insertHistory("");
        }
        catch (FitsException e) {
            System.err.println("  Error updating FITS header:\n   " + e);
        }
    }
}

