/*
 * Decompiled with CFR 0.152.
 */
package skyview.process.deedger;

import java.util.Arrays;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import skyview.geometry.DepthSampler;
import skyview.geometry.Sampler;
import skyview.process.Processor;
import skyview.survey.Image;

public class ImageMedian
implements Processor {
    int[] counts;
    int totalCount;
    int nImage;
    Image[] inputs;
    Image output;
    int[] source;
    int nx;
    int ny;
    double[] offsets;

    @Override
    public String getName() {
        return "Image Median Deedger:";
    }

    @Override
    public String getDescription() {
        return "Normalize images to have the same median";
    }

    @Override
    public void process(Image[] inputs, Image output, int[] source, Sampler samp, DepthSampler dsamp) {
        if (output == null) {
            return;
        }
        int nImage = inputs.length;
        this.counts = new int[nImage];
        this.nImage = nImage;
        this.source = source;
        this.inputs = inputs;
        this.output = output;
        this.ny = output.getHeight();
        this.nx = output.getWidth();
        this.deedge();
    }

    private void deedge() {
        int j;
        int j2;
        this.totalCount = 0;
        this.offsets = new double[this.nImage];
        for (int i = 0; i < this.source.length; ++i) {
            if (this.source[i] < 0 || this.source[i] >= this.nImage) continue;
            int n = this.source[i];
            this.counts[n] = this.counts[n] + 1;
        }
        double[][] arrays = new double[this.nImage][];
        int[] cnts = new int[this.nImage];
        for (j2 = 0; j2 < arrays.length; ++j2) {
            arrays[j2] = new double[this.counts[j2]];
        }
        for (int i = 0; i < this.source.length; ++i) {
            j = this.source[i];
            arrays[j][cnts[j]] = this.output.getData(i);
            int n = j;
            cnts[n] = cnts[n] + 1;
        }
        for (j2 = 0; j2 < this.nImage; ++j2) {
            int cnt = this.counts[j2];
            double[] arr = arrays[j2];
            if (cnt <= 0) continue;
            Arrays.sort(arr);
            this.offsets[j2] = cnt % 2 == 0 ? 0.5 * (arr[cnt / 2 - 1] + arr[cnt / 2]) : arr[cnt / 2];
        }
        int jmax = 0;
        for (j = 1; j < this.nImage; ++j) {
            if (this.counts[j] <= this.counts[jmax]) continue;
            jmax = j;
        }
        double norm = this.offsets[jmax];
        for (int j3 = 0; j3 < this.nImage; ++j3) {
            if (this.counts[j3] <= 0) continue;
            int n = j3;
            this.offsets[n] = this.offsets[n] - norm;
            int n2 = j3;
            this.offsets[n2] = this.offsets[n2] * -1.0;
        }
        for (int i = 0; i < this.source.length; ++i) {
            double offset = this.offsets[this.source[i]];
            if (offset == 0.0) continue;
            this.output.setData(i, this.output.getData(i) + offset);
        }
    }

    @Override
    public void updateHeader(Header h) {
        try {
            boolean first = true;
            if (this.offsets == null) {
                return;
            }
            for (int i = 0; i < this.nImage; ++i) {
                String cfile;
                if (this.offsets[i] == 0.0) continue;
                if (first) {
                    h.insertHistory("");
                    h.insertHistory("Edge adjustments applied (skyview.geometry.MedianFilter");
                    h.insertHistory("");
                    first = false;
                }
                if ((cfile = this.inputs[i].getName()).lastIndexOf(47) > 0) {
                    cfile = cfile.substring(cfile.lastIndexOf(47) + 1);
                }
                h.insertHistory("     Image " + cfile + " offset by " + this.offsets[i]);
            }
            if (!first) {
                h.insertHistory("");
            }
        }
        catch (FitsException e) {
            System.err.println("Error updating header:" + e);
        }
    }
}

