/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.dao;

import alma.sourcecat.dao.SourceBandDao;
import alma.sourcecat.model.SourceBand;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class SourceBandDaoImpl
implements SourceBandDao {
    private JdbcTemplate jdbcTmpl;

    public void setDataSource(DataSource dataSource) {
        this.jdbcTmpl = new JdbcTemplate(dataSource);
    }

    @Override
    public void update(Integer sourceBandId, Double uvMin, Double uvMax, Double spectralIndex, String username, String comment) {
        String sql = "update source_band set uvmin = ?, uvmax = ?, spectral_index = ?, update_date = sysdate, update_user = ?, update_comment = ? where id = ?";
        if (username == null) {
            username = "unknown";
        }
        if (comment == null) {
            comment = "no comment";
        }
        this.jdbcTmpl.update("update source_band set uvmin = ?, uvmax = ?, spectral_index = ?, update_date = sysdate, update_user = ?, update_comment = ? where id = ?", new Object[]{uvMin, uvMax, spectralIndex, username, comment, sourceBandId});
    }

    @Override
    public SourceBand getSourceBand(Integer sourceId, Integer bandId) {
        String sql = "select sb.id, r.range_id, r.range_name, uvmin, uvmax, spectral_index from source_band sb inner join ranges r on r.range_id = sb.band_id where source_id = ? and band_id = ?";
        List sourceBands = this.jdbcTmpl.query("select sb.id, r.range_id, r.range_name, uvmin, uvmax, spectral_index from source_band sb inner join ranges r on r.range_id = sb.band_id where source_id = ? and band_id = ?", new Object[]{sourceId, bandId}, (RowMapper)new RowMapper<SourceBand>(){

            public SourceBand mapRow(ResultSet rs, int rowNum) throws SQLException {
                return SourceBandDaoImpl.createSourceBand(rs);
            }
        });
        if (sourceBands.isEmpty()) {
            return null;
        }
        return (SourceBand)sourceBands.get(0);
    }

    public static SourceBand createSourceBand(ResultSet rs) throws SQLException {
        SourceBand sourceBand = new SourceBand();
        sourceBand.setId(rs.getInt("id"));
        sourceBand.setRangeId(rs.getInt("range_id"));
        sourceBand.setName(rs.getString("range_name"));
        sourceBand.setUvMin(rs.getDouble("uvmin"));
        if (rs.wasNull()) {
            sourceBand.setUvMin(null);
        }
        sourceBand.setUvMax(rs.getDouble("uvmax"));
        if (rs.wasNull()) {
            sourceBand.setUvMax(null);
        }
        sourceBand.setSpectralIndex(rs.getDouble("spectral_index"));
        if (rs.wasNull()) {
            sourceBand.setSpectralIndex(null);
        }
        return sourceBand;
    }

    @Override
    public void update(SourceBand sourceBand) {
        this.update(sourceBand.getId(), sourceBand.getUvMin(), sourceBand.getUvMax(), sourceBand.getSpectralIndex(), sourceBand.getUpdateUser(), sourceBand.getUpdateComment());
    }
}

