/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.model;

import alma.sourcecat.model.NamedEntity;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Range
extends NamedEntity {
    public static final String XMLRPC_ID = "range_id";
    public static final String XMLRPC_NAME = "range_name";
    public static final String XMLRPC_FMIN = "frequency_min";
    public static final String XMLRPC_FMAX = "frequency_max";
    private Double fMin;
    private Double fMax;

    private Range(Map<?, ?> m) {
        super(m, XMLRPC_ID, XMLRPC_NAME);
        Object fMin = m.get(XMLRPC_FMIN);
        if (fMin == null || !(fMin instanceof Double)) {
            throw new IllegalArgumentException(XMLRPC_FMIN);
        }
        this.fMin = (Double)fMin;
        Object fMax = m.get(XMLRPC_FMAX);
        if (fMax == null || !(fMax instanceof Double)) {
            throw new IllegalArgumentException(XMLRPC_FMAX);
        }
        this.fMax = (Double)fMax;
    }

    public Range(int id, String name, Double fMin, Double fMax) {
        super(id, name);
        this.fMin = fMin;
        this.fMax = fMax;
    }

    public Double getfMin() {
        return this.fMin;
    }

    public Double getfMax() {
        return this.fMax;
    }

    public void setfMin(Double fMin) {
        this.fMin = fMin;
    }

    public void setfMax(Double fMax) {
        this.fMax = fMax;
    }

    public String getText() {
        return Range.herzToGhzString(this.fMin) + " - " + Range.herzToGhzString(this.fMax) + " GHz";
    }

    private static final String herzToGhzString(double frequency) {
        double ghz = frequency / 1.0E9;
        return String.format("%.1f", ghz);
    }

    public static List<Range> convertResponse(Object[] xmlrpcResponse) throws IllegalArgumentException {
        LinkedList<Range> result = new LinkedList<Range>();
        for (Object o : xmlrpcResponse) {
            if (!(o instanceof Map)) continue;
            result.add(new Range((Map)o));
        }
        return result;
    }

    public String toString() {
        return "Range [id=" + super.getId() + ", name=" + super.getName() + ", fMin=" + this.fMin + ", fMax=" + this.fMax + "]";
    }
}

