/*
 * Decompiled with CFR 0.152.
 */
package jsky.coords;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import jsky.util.StringUtil;

public class DMS
implements Serializable {
    private static final Double MINUS_ZERO = -0.0;
    private static final NumberFormat NF = NumberFormat.getInstance(Locale.US);
    private static final NumberFormat NF_SEC = NumberFormat.getInstance(Locale.US);
    private int degrees;
    private int min;
    private double sec;
    private double val;
    private byte sign = 1;
    private boolean initialized = false;

    public DMS() {
    }

    public DMS(double degrees, int min, double sec) {
        this.set(degrees, min, sec);
    }

    public DMS(double val) {
        this.setVal(val);
    }

    public DMS(DMS hms) {
        this.setVal(hms.val);
    }

    public DMS(String s) {
        s = StringUtil.replace((String)s, (String)",", (String)".");
        double[] vals = new double[]{0.0, 0.0, 0.0};
        StringTokenizer tok = new StringTokenizer(s, ": ");
        int n = 0;
        while (n < 3 && tok.hasMoreTokens()) {
            vals[n++] = Double.valueOf(tok.nextToken());
        }
        if (n >= 2) {
            this.set(vals[0], (int)vals[1], vals[2]);
        } else if (n == 1) {
            this.setVal(vals[0]);
        } else {
            throw new RuntimeException("Expected a string of the form hh:mm:ss.sss, but got: '" + s + "'");
        }
    }

    public void set(double degrees, int min, double sec) {
        this.degrees = (int)degrees;
        this.min = min;
        this.sec = sec;
        this.val = (sec / 60.0 + (double)min) / 60.0;
        if (degrees < 0.0 || new Double(degrees).equals(MINUS_ZERO)) {
            this.val = degrees - this.val;
            this.degrees = -this.degrees;
            this.sign = (byte)-1;
        } else {
            this.val = (double)this.degrees + this.val;
            this.sign = 1;
        }
        this.initialized = true;
    }

    public void setVal(double val) {
        this.val = val;
        double v = val;
        if (v < 0.0 || new Double(v).equals(MINUS_ZERO)) {
            this.sign = (byte)-1;
            v = -v;
        } else {
            this.sign = 1;
        }
        double dd = v + 1.0E-10;
        this.degrees = (int)dd;
        double md = (dd - (double)this.degrees) * 60.0;
        this.min = (int)md;
        this.sec = (md - (double)this.min) * 60.0;
        this.initialized = true;
    }

    public String toString() {
        String secs = NF_SEC.format(this.sec);
        String signStr = this.sign == -1 ? "-" : "+";
        return signStr + NF.format(this.degrees) + ":" + NF.format(this.min) + ":" + secs;
    }

    public String toString(boolean showSeconds) {
        if (showSeconds) {
            return this.toString();
        }
        String signStr = this.sign == -1 ? "-" : "+";
        return signStr + NF.format(this.degrees) + ":" + NF.format(this.min);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public int getDegrees() {
        return this.degrees;
    }

    public int getMin() {
        return this.min;
    }

    public double getSec() {
        return this.sec;
    }

    public double getVal() {
        return this.val;
    }

    public byte getSign() {
        return this.sign;
    }

    public boolean equals(Object obj) {
        return obj instanceof DMS && this.val == ((DMS)obj).val;
    }

    public static void main(String[] args) {
        DMS d = new DMS(3.0, 19, 48.23);
        System.out.println("DMS(3, 19, 48.23) == " + d + " == " + d.getVal());
        if (!d.equals(new DMS(d.getVal()))) {
            System.out.println("Equality test failed: " + d + " != " + new DMS(d.getVal()));
        }
        d = new DMS(41.0, 30, 42.2);
        System.out.println("41 30 42.2 = " + d + " = " + d.getVal() + " = " + new DMS(d.getVal()));
        d = new DMS(-41.0, 30, 2.2);
        System.out.println("-41 30 2.2 = " + d + " = " + d.getVal() + " = " + new DMS(d.getVal()));
        d = new DMS("-41 30 42.2");
        System.out.println("-41 30 42.2 = " + d + " = " + d.getVal() + " = " + new DMS(d.getVal()));
        d = new DMS("1:01:02.34567");
        System.out.println("1:01:02.34567 = " + d + " = " + d.getVal() + " = " + new DMS(d.getVal()));
        d = new DMS("1:01:02.34567");
        System.out.println("1:01:02.34567 = " + d + " = " + d.getVal() + " = " + new DMS(d.getVal()));
        d = new DMS(-0.0, 15, 33.3333);
        System.out.println("-0 15 33.3333 = " + d + " = " + d.getVal() + " = " + new DMS(d.getVal()));
        d = new DMS(-1.0E-4);
        System.out.println("-0.0001 = " + d + " = " + d.getVal() + " = " + new DMS(d.getVal()));
        d = new DMS(8.093055554666666);
        System.out.println("121.39583332/15. = " + d + " = " + d.getVal() + " = " + new DMS(d.getVal()));
        d = new DMS(8.073055554666666);
        System.out.println("121.09583332/15. = " + d + " = " + d.getVal() + " = " + new DMS(d.getVal()));
        d = new DMS(-8.093055554666666);
        System.out.println("-121.39583332/15. = " + d + " = " + d.getVal() + " = " + new DMS(d.getVal()));
        d = new DMS(-8.073055554666666);
        System.out.println("-121.09583332/15. = " + d + " = " + d.getVal() + " = " + new DMS(d.getVal()));
    }

    static {
        NF.setMinimumIntegerDigits(2);
        NF.setMaximumIntegerDigits(2);
        NF.setMaximumFractionDigits(0);
        NF_SEC.setMinimumIntegerDigits(2);
        NF_SEC.setMaximumIntegerDigits(2);
        NF_SEC.setMinimumFractionDigits(2);
        NF_SEC.setMaximumFractionDigits(2);
    }
}

