/*
 * Decompiled with CFR 0.152.
 */
package jsky.coords;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import jsky.util.StringUtil;

public class HMS
implements Serializable {
    private static final Double MINUS_ZERO = -0.0;
    private static final NumberFormat NF = NumberFormat.getInstance(Locale.US);
    private static final NumberFormat NF_SEC = NumberFormat.getInstance(Locale.US);
    private int hours;
    private int min;
    private double sec;
    private double val;
    private byte sign = 1;
    private boolean initialized = false;

    public HMS() {
    }

    public HMS(double hours, int min, double sec) {
        this.set(hours, min, sec);
    }

    public HMS(double val) {
        this.setVal(val);
    }

    public HMS(HMS hms) {
        this.setVal(hms.val);
    }

    public HMS(String s) {
        this(s, false);
    }

    public HMS(String s, boolean hflag) {
        s = StringUtil.replace((String)s, (String)",", (String)".");
        double[] vals = new double[]{0.0, 0.0, 0.0};
        StringTokenizer tok = new StringTokenizer(s, ": ");
        int n = 0;
        while (n < 3 && tok.hasMoreTokens()) {
            vals[n++] = Double.valueOf(tok.nextToken());
        }
        if (n >= 2) {
            this.set(vals[0], (int)vals[1], vals[2]);
        } else if (n == 1) {
            if (!hflag && s.indexOf(46) != -1) {
                this.setVal(vals[0] / 15.0);
            } else {
                this.setVal(vals[0]);
            }
        } else {
            throw new RuntimeException("Expected a string of the form hh:mm:ss.sss, but got: '" + s + "'");
        }
    }

    public void set(double hours, int min, double sec) {
        this.hours = (int)hours;
        this.min = min;
        this.sec = sec;
        this.val = (sec / 60.0 + (double)min) / 60.0;
        if (hours < 0.0 || new Double(hours).equals(MINUS_ZERO)) {
            this.val = hours - this.val;
            this.hours = -this.hours;
            this.sign = (byte)-1;
        } else {
            this.val = (double)this.hours + this.val;
            this.sign = 1;
        }
        this.initialized = true;
    }

    public void setVal(double val) {
        this.val = val;
        double v = val;
        if (v < 0.0 || new Double(v).equals(MINUS_ZERO)) {
            this.sign = (byte)-1;
            v = -v;
        } else {
            this.sign = 1;
        }
        double dd = v + 1.0E-10;
        this.hours = (int)dd;
        double md = (dd - (double)this.hours) * 60.0;
        this.min = (int)md;
        this.sec = (md - (double)this.min) * 60.0;
        this.initialized = true;
    }

    public String toString() {
        String secs = NF_SEC.format(this.sec);
        String signStr = this.sign == -1 ? "-" : "";
        return signStr + NF.format(this.hours) + ":" + NF.format(this.min) + ":" + secs;
    }

    public String toString(boolean showSeconds) {
        if (showSeconds) {
            return this.toString();
        }
        String signStr = this.sign == -1 ? "-" : " ";
        return signStr + NF.format(this.hours) + ":" + NF.format(this.min);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMin() {
        return this.min;
    }

    public double getSec() {
        return this.sec;
    }

    public double getVal() {
        return this.val;
    }

    public byte getSign() {
        return this.sign;
    }

    public boolean equals(Object obj) {
        return obj instanceof HMS && this.val == ((HMS)obj).val;
    }

    public static void main(String[] args) {
        HMS h = new HMS(3.0, 19, 48.23);
        System.out.println("HMS(3, 19, 48.23) == " + h + " == " + h.getVal());
        if (!h.equals(new HMS(h.getVal()))) {
            System.out.println("Equality test failed: " + h + " != " + new HMS(h.getVal()));
        }
        h = new HMS(41.0, 30, 42.2);
        System.out.println("41 30 42.2 = " + h + " = " + h.getVal() + " = " + new HMS(h.getVal()));
        h = new HMS(-41.0, 30, 2.2);
        System.out.println("-41 30 2.2 = " + h + " = " + h.getVal() + " = " + new HMS(h.getVal()));
        h = new HMS("-41 30 42.2");
        System.out.println("-41 30 42.2 = " + h + " = " + h.getVal() + " = " + new HMS(h.getVal()));
        h = new HMS("1:01:02.34567");
        System.out.println("1:01:02.34567 = " + h + " = " + h.getVal() + " = " + new HMS(h.getVal()));
        h = new HMS("1:01:02.34567");
        System.out.println("1:01:02.34567 = " + h + " = " + h.getVal() + " = " + new HMS(h.getVal()));
        h = new HMS(-0.0, 15, 33.3333);
        System.out.println("-0 15 33.3333 = " + h + " = " + h.getVal() + " = " + new HMS(h.getVal()));
        h = new HMS(-1.0E-4);
        System.out.println("-0.0001 = " + h + " = " + h.getVal() + " = " + new HMS(h.getVal()));
        h = new HMS(8.093055554666666);
        System.out.println("121.39583332/15. = " + h + " = " + h.getVal() + " = " + new HMS(h.getVal()));
        h = new HMS(8.073055554666666);
        System.out.println("121.09583332/15. = " + h + " = " + h.getVal() + " = " + new HMS(h.getVal()));
        h = new HMS(-8.093055554666666);
        System.out.println("-121.39583332/15. = " + h + " = " + h.getVal() + " = " + new HMS(h.getVal()));
        h = new HMS(-8.073055554666666);
        System.out.println("-121.09583332/15. = " + h + " = " + h.getVal() + " = " + new HMS(h.getVal()));
    }

    static {
        NF.setMinimumIntegerDigits(2);
        NF.setMaximumIntegerDigits(2);
        NF.setMaximumFractionDigits(0);
        NF_SEC.setMinimumIntegerDigits(2);
        NF_SEC.setMaximumIntegerDigits(2);
        NF_SEC.setMinimumFractionDigits(3);
        NF_SEC.setMaximumFractionDigits(3);
    }
}

