/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowListener;
import java.awt.print.PrinterException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jsky.catalog.FieldDesc;
import jsky.catalog.QueryResult;
import jsky.catalog.TableQueryResult;
import jsky.catalog.TestTableQueryResult;
import jsky.catalog.gui.QueryResultDisplay;
import jsky.catalog.vo.UcdSupport;
import jsky.interop.UrlTableCellRenderer;
import jsky.util.Preferences;
import jsky.util.PrintableWithDialog;
import jsky.util.SaveableAsHTML;
import jsky.util.Storeable;
import jsky.util.gui.BasicWindowMonitor;
import jsky.util.gui.SexagesimalTableCellEditor;
import jsky.util.gui.SexagesimalTableCellRenderer;
import jsky.util.gui.SortedJTable;
import jsky.util.gui.TableUtil;
import uk.ac.starlink.table.gui.NumericCellRenderer;

public class TableDisplay
extends JPanel
implements QueryResultDisplay,
PrintableWithDialog,
SaveableAsHTML,
Storeable {
    private TableQueryResult _tableQueryResult;
    private QueryResultDisplay _queryResultDisplay;
    private JScrollPane _scrollPane;
    private SortedJTable _table;
    private int _sumColWidths = 0;
    private boolean[] _show;
    private static Map<String, boolean[]> _showTab = new Hashtable<String, boolean[]>();
    private static String SHOW_TAB_FILE_NAME = "tableDisplayShowTab";

    public TableDisplay(TableQueryResult tableQueryResult, QueryResultDisplay queryResultDisplay) {
        this._queryResultDisplay = queryResultDisplay;
        this._table = new SortedJTable(){

            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return TableDisplay.this.getColumnToolTip(realIndex);
                    }
                };
            }
        };
        this.setBackground(Color.white);
        if (tableQueryResult != null) {
            this.setModel(tableQueryResult);
        }
        this._table.setAutoResizeMode(0);
        this._table.setRowSelectionAllowed(true);
        this._table.setColumnSelectionAllowed(false);
        this._table.setRowHeight(20);
        this._table.setGridColor(Color.gray);
        JTableHeader header = this._table.getTableHeader();
        header.setUpdateTableInRealTime(false);
        header.setFont(header.getFont().deriveFont(1));
        this.setLayout(new BorderLayout());
        this._scrollPane = new JScrollPane((Component)this._table);
        this.add((Component)this._scrollPane, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TableDisplay.this._resize();
            }
        });
    }

    private String getColumnToolTip(int i) {
        if (this._tableQueryResult != null) {
            FieldDesc fd = this._tableQueryResult.getColumnDesc(i);
            String tip = fd.getDescription();
            String units = fd.getUnits();
            if (units != null) {
                units = units.trim();
                if (fd.isRA()) {
                    units = units + " (displayed as hours:minutes:seconds)";
                }
            }
            if (tip == null || tip.length() == 0) {
                if (units != null && units.length() != 0) {
                    tip = fd.getName() + " in " + units;
                }
            } else if (units != null && units.length() != 0) {
                tip = tip + ", Units: " + units;
            }
            return tip;
        }
        return null;
    }

    public TableDisplay(TableQueryResult tableQueryResult) {
        this(tableQueryResult, null);
    }

    public TableDisplay(QueryResultDisplay queryResultDisplay) {
        this(null, queryResultDisplay);
    }

    public TableDisplay() {
        this(null, null);
    }

    public SortedJTable getTable() {
        return this._table;
    }

    public JScrollPane getScrollPane() {
        return this._scrollPane;
    }

    public void setQueryResultDisplay(QueryResultDisplay q) {
        this._queryResultDisplay = q;
    }

    public QueryResultDisplay getQueryResultDisplay() {
        return this._queryResultDisplay;
    }

    public void setQueryResult(QueryResult queryResult) {
        if (queryResult instanceof TableQueryResult) {
            this.setModel((TableQueryResult)queryResult);
        }
    }

    public TableQueryResult getTableQueryResult() {
        return this._tableQueryResult;
    }

    public void setModel(TableQueryResult tableQueryResult) {
        this._tableQueryResult = tableQueryResult;
        boolean[] o = _showTab.get(this._tableQueryResult.getName());
        if (o != null) {
            this._show = o;
            if (this._show.length != this._tableQueryResult.getColumnCount()) {
                this._show = null;
            }
        }
        this._table.setModel((TableModel)tableQueryResult);
        this.setColumnRenderers();
        this._sumColWidths = this.initColumnSizes((JTable)this._table, this._show);
        this.reorderColumns();
    }

    public void update() {
        this._table.setModel((TableModel)this._tableQueryResult);
        this.setColumnRenderers();
        this._sumColWidths = this.initColumnSizes((JTable)this._table, this._show);
    }

    protected int initColumnSizes(JTable table, boolean[] show) {
        return TableUtil.initColumnSizes((JTable)table, (boolean[])show);
    }

    protected void setColumnRenderers() {
        int numCols = this._tableQueryResult.getColumnCount();
        for (int col = 0; col < numCols; ++col) {
            FieldDesc field = this._tableQueryResult.getColumnDesc(col);
            TableColumn column = this._table.getColumn((Object)this._tableQueryResult.getColumnName(col));
            if (field.hasLink()) {
                column.setCellRenderer(new UrlTableCellRenderer(field, this._tableQueryResult, this._queryResultDisplay));
                column.setCellEditor(new UrlTableCellRenderer(field, this._tableQueryResult, this._queryResultDisplay));
                continue;
            }
            if (field.isRA()) {
                column.setCellRenderer((TableCellRenderer)new SexagesimalTableCellRenderer(true));
                column.setCellEditor((TableCellEditor)new SexagesimalTableCellEditor(true));
                continue;
            }
            if (field.isDec()) {
                column.setCellRenderer((TableCellRenderer)new SexagesimalTableCellRenderer(false));
                column.setCellEditor((TableCellEditor)new SexagesimalTableCellEditor(false));
                continue;
            }
            Class c = this._tableQueryResult.getColumnClass(col);
            if (c == null) continue;
            column.setCellRenderer((TableCellRenderer)new NumericCellRenderer(c));
        }
    }

    protected void reorderColumns() {
        if (this._tableQueryResult != null) {
            int columnCount = this._tableQueryResult.getColumnCount();
            for (int col = 0; col < columnCount; ++col) {
                FieldDesc fd = this._tableQueryResult.getColumnDesc(col);
                if (fd.hasLink()) {
                    this._table.moveColumn(col, 0);
                    continue;
                }
                if (!"format".equalsIgnoreCase(this._tableQueryResult.getColumnName(col)) && !new UcdSupport(fd.getUCD()).isFormat()) continue;
                this._table.moveColumn(col, 1);
            }
        }
    }

    public void print(String title) throws PrinterException {
        this._table.setTitle(title);
        this._table.showPrintDialog();
    }

    public void print() throws PrinterException {
        this._table.showPrintDialog();
    }

    private void _resize() {
        if (this._tableQueryResult == null) {
            return;
        }
        int numCols = this._tableQueryResult.getColumnCount();
        if (numCols == 1) {
            this._table.setAutoResizeMode(4);
            this._table.sizeColumnsToFit(0);
        } else if (this._sumColWidths < this.getWidth()) {
            this._table.setAutoResizeMode(3);
        } else {
            this._table.setAutoResizeMode(0);
        }
    }

    public void selectRow(int row) {
        row = this._table.getUnsortedRowIndex(row);
        ListSelectionModel model = this._table.getSelectionModel();
        model.addSelectionInterval(row, row);
        BoundedRangeModel brm = this._scrollPane.getVerticalScrollBar().getModel();
        int min = brm.getMinimum();
        int max = brm.getMaximum();
        int value = brm.getValue();
        int extent = brm.getExtent();
        int newvalue = row * (max - min) / this._tableQueryResult.getRowCount();
        if (newvalue < value || newvalue > value + extent) {
            brm.setValue(newvalue - extent / 2);
        }
    }

    public void deselectRow(int row) {
        row = this._table.getUnsortedRowIndex(row);
        this._table.getSelectionModel().removeSelectionInterval(row, row);
    }

    public boolean[] getShow() {
        return this._show;
    }

    public void setShow(boolean[] show) {
        this._show = show;
        if (this._show != null) {
            _showTab.put(this._tableQueryResult.getName(), show);
        } else {
            _showTab.remove(this._tableQueryResult.getName());
        }
        this.update();
        try {
            Preferences.getPreferences().serialize(SHOW_TAB_FILE_NAME, _showTab);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveAsHTML(String filename) throws IOException {
        FileOutputStream os = new FileOutputStream(filename);
        int numCols = this._table.getColumnCount();
        int numRows = this._table.getRowCount();
        if (numCols == 0) {
            return;
        }
        PrintStream out = new PrintStream(os);
        out.println("<html>");
        out.println("<body>");
        out.println("<table BORDER COLS=" + numCols + " WIDTH=\"100%\" NOSAVE>");
        out.println("<caption>" + this._tableQueryResult.getTitle() + "</caption>");
        out.println("<tr>");
        for (int col = 0; col < numCols; ++col) {
            if (this._show != null && !this._show[col]) continue;
            out.println("<th>" + this._table.getColumnName(col) + "</th>");
        }
        out.println("</tr>");
        for (int row = 0; row < numRows; ++row) {
            out.println("<tr>");
            for (int col = 0; col < numCols; ++col) {
                Object o;
                if (this._show != null && !this._show[col]) continue;
                TableCellRenderer r = this._table.getCellRenderer(row, col);
                Component c = r.getTableCellRendererComponent((JTable)this._table, this._table.getValueAt(row, col), false, false, row, col);
                String s = c instanceof JLabel ? ((JLabel)((Object)r)).getText() : (c instanceof AbstractButton ? ((AbstractButton)((Object)r)).getText() : ((o = this._table.getValueAt(row, col)) != null ? o.toString() : " "));
                out.println("<td>" + s + "</td>");
            }
            out.println("</tr>");
        }
        out.println("</table>");
        out.println("</body>");
        out.println("</html>");
    }

    public Object storeSettings() {
        TableSettings settings = new TableSettings();
        settings.show = this._show;
        settings.columnToSort = this._table.getSortColumn();
        settings.sortType = this._table.getSortType();
        return settings;
    }

    public boolean restoreSettings(Object obj) {
        if (obj instanceof TableSettings) {
            TableSettings settings = (TableSettings)obj;
            this._table.setSortType(settings.sortType);
            this._table.setSortColumn(settings.columnToSort);
            if (settings.show != null && this._show != null && settings.show.length == this._show.length) {
                this.setShow(settings.show);
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("TableDisplay");
        TableDisplay tableDisplay = new TableDisplay((TableQueryResult)new TestTableQueryResult());
        frame.getContentPane().add((Component)tableDisplay, "Center");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener((WindowListener)new BasicWindowMonitor());
    }

    static {
        try {
            _showTab = (Map)Preferences.getPreferences().deserialize(SHOW_TAB_FILE_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class TableSettings
    implements Serializable {
        boolean[] show;
        int columnToSort;
        int sortType;
    }
}

