/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui.html;

import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JComponent;
import javax.swing.JFrame;
import jsky.catalog.gui.html.HTMLViewer;
import jsky.catalog.gui.html.HTMLViewerMenuBar;
import jsky.util.Preferences;
import jsky.util.gui.GenericToolBar;
import jsky.util.gui.GenericToolBarTarget;

public class HTMLViewerFrame
extends JFrame {
    private HTMLViewer viewer = new HTMLViewer();

    public HTMLViewerFrame() {
        super("HTML Viewer");
        GenericToolBar toolbar = new GenericToolBar((GenericToolBarTarget)this.viewer);
        this.getContentPane().add((Component)toolbar, "North");
        this.getContentPane().add((Component)this.viewer, "Center");
        this.setJMenuBar(new HTMLViewerMenuBar(this.viewer, toolbar));
        Preferences.manageLocation((Component)this);
        Preferences.manageSize((JComponent)this.viewer, (Dimension)new Dimension(600, 500));
        this.pack();
        this.setVisible(true);
        this.setDefaultCloseOperation(1);
    }

    public HTMLViewer getHTMLViewer() {
        return this.viewer;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage: java HTMLViewerFrame URL");
            System.exit(1);
        }
        try {
            URL url = new URL(args[0]);
            URLConnection connection = url.openConnection();
            String contentType = connection.getContentType();
            if (contentType == null || contentType.startsWith("text/html")) {
                HTMLViewerFrame f = new HTMLViewerFrame();
                f.getHTMLViewer().setPage(url);
            } else {
                System.out.println("error: URL content type is not text/html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

