/*
 * Decompiled with CFR 0.152.
 */
package jsky.interop;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.catalog.QueryResult;
import jsky.catalog.gui.TableDisplayTool;
import jsky.catalog.vo.VoCatalog;
import jsky.catalog.vo.VoTable;
import jsky.image.ImageChangeEvent;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.image.gui.MainImageDisplay;
import jsky.navigator.Navigator;
import jsky.navigator.NavigatorImageDisplayFrame;
import jsky.util.Resources;
import jsky.util.gui.BasicAction;
import jsky.util.gui.SwingUtil;
import org.astrogrid.samp.Metadata;
import org.votech.plastic.PlasticHubListener;
import uk.ac.starlink.plastic.ApplicationItem;
import uk.ac.starlink.plastic.HubManager;
import uk.ac.starlink.plastic.MessageId;
import uk.ac.starlink.plastic.PlasticListWindow;
import uk.ac.starlink.plastic.PlasticTransmitter;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.VOTableWriter;

public class PlasticHelper
extends HubManager {
    private static final Logger LOG = Logger.getLogger(PlasticHelper.class.getName());
    private static final URI[] SUPPORTED_MESSAGES = new URI[]{MessageId.VOT_LOAD, MessageId.VOT_LOADURL, MessageId.VOT_SHOWOBJECTS, MessageId.VOT_HIGHLIGHTOBJECT, MessageId.INFO_GETDESCRIPTION, MessageId.INFO_GETICONURL, MessageId.FITS_LOADIMAGE, MessageId.SKY_POINT};
    private static PlasticHelper _instance;
    private NavigatorImageDisplayFrame _imageFrame;
    private Metadata _meta;

    public static void init(Metadata meta, NavigatorImageDisplayFrame imageFrame) {
        if (_instance == null) {
            _instance = new PlasticHelper(meta, imageFrame);
        }
    }

    public static PlasticHelper getInstance() {
        return _instance;
    }

    public PlasticHelper(Metadata meta, NavigatorImageDisplayFrame imageFrame) {
        super(meta.getName(), SUPPORTED_MESSAGES);
        this._imageFrame = imageFrame;
        this._meta = meta;
        this.setActive();
    }

    public boolean setActive() {
        boolean isReg;
        try {
            this.register();
            isReg = true;
        }
        catch (IOException e) {
            LOG.warning(e.getMessage());
            isReg = false;
        }
        this.setAutoRegister(5000);
        return isReg;
    }

    public Object doPerform(URI sender, URI message, List args) throws IOException {
        if (MessageId.VOT_LOAD.equals(message) && PlasticHelper.checkArgs((List)args, (Class[])new Class[]{String.class})) {
            String text = (String)args.get(0);
            String id = args.size() > 1 ? String.valueOf(args.get(1)) : null;
            this.votableLoad(sender, text, id);
            return Boolean.TRUE;
        }
        if (MessageId.VOT_LOADURL.equals(message) && PlasticHelper.checkArgs((List)args, (Class[])new Class[]{Object.class})) {
            String url;
            String id = url = args.get(0) instanceof String ? (String)args.get(0) : args.get(0).toString();
            if (args.size() > 1) {
                id = args.get(1) instanceof String ? (String)args.get(1) : args.get(0).toString();
            }
            this.votableLoadFromURL(sender, url, id);
            return Boolean.TRUE;
        }
        if (MessageId.VOT_SHOWOBJECTS.equals(message) && args.size() >= 2 && args.get(1) instanceof List) {
            String tableId = args.get(0).toString();
            List rowList = (List)args.get(1);
            Navigator navigator = this._imageFrame.getNavigator();
            if (navigator != null) {
                int[] rows = new int[rowList.size()];
                for (int i = 0; i < rows.length; ++i) {
                    rows[i] = Integer.parseInt(rowList.get(i).toString());
                }
                navigator.selectTableRows(tableId, null, rows);
            }
            return Boolean.TRUE;
        }
        if (MessageId.VOT_HIGHLIGHTOBJECT.equals(message) && args.size() >= 2 && args.get(1) instanceof Number) {
            String tableId = args.get(0).toString();
            int irow = ((Number)args.get(1)).intValue();
            Navigator navigator = this._imageFrame.getNavigator();
            if (navigator != null) {
                navigator.selectTableRows(tableId, null, new int[]{irow});
            }
            return Boolean.TRUE;
        }
        if (MessageId.INFO_GETICONURL.equals(message)) {
            return this._meta.getIconUrl();
        }
        if (MessageId.FITS_LOADIMAGE.equals(message) && PlasticHelper.checkArgs((List)args, (Class[])new Class[]{Object.class})) {
            String url;
            String id = url = args.get(0) instanceof String ? (String)args.get(0) : args.get(0).toString();
            if (args.size() > 1) {
                id = args.get(1) instanceof String ? (String)args.get(1) : args.get(0).toString();
            }
            this.fitsLoadImage(sender, url, id);
            return Boolean.TRUE;
        }
        if (MessageId.SKY_POINT.equals(message) && PlasticHelper.checkArgs((List)args, (Class[])new Class[]{Object.class})) {
            if (args.size() >= 2) {
                double ra = Double.parseDouble(args.get(0).toString());
                double dec = Double.parseDouble(args.get(1).toString());
                this.skyPoint(ra, dec);
            }
            return Boolean.TRUE;
        }
        throw new UnsupportedOperationException();
    }

    private void votableLoad(URI sender, String votText, String id) throws IOException {
        Navigator navigator = this._imageFrame.getNavigator();
        if (navigator != null) {
            final byte[] votBytes = votText.getBytes("UTF-8");
            DataSource datsrc = new DataSource(){

                public InputStream getRawInputStream() {
                    return new ByteArrayInputStream(votBytes);
                }
            };
            String name = sender.toString() + "-" + id;
            VoCatalog catalog = new VoCatalog(VoTable.createVoTable((DataSource)datsrc, (String)id, (String)name));
            navigator.setQueryResult((QueryResult)catalog);
            navigator.registerTable(null, id);
        }
    }

    private void votableLoadFromURL(URI sender, String urlStr, String id) throws IOException {
        Navigator navigator = this._imageFrame.getNavigator();
        if (navigator != null) {
            String name = sender.toString() + "-" + id;
            URL url = new URL(urlStr);
            VoCatalog catalog = new VoCatalog(VoTable.createVoTable((URL)url, (String)id, (String)name));
            navigator.setQueryResult((QueryResult)catalog);
            navigator.registerTable(url, id);
        }
    }

    private void fitsLoadImage(URI sender, String urlStr, String id) throws IOException {
        DivaMainImageDisplay imageDisplay = this._imageFrame.getImageDisplayControl().getImageDisplay();
        imageDisplay.setURL(new URL(urlStr));
    }

    protected void skyPoint(double ra, double dec) {
        DivaMainImageDisplay imageDisplay = this._imageFrame.getImageDisplayControl().getImageDisplay();
        imageDisplay.loadCachedImage(ra, dec);
    }

    public void initImageMenu(JMenu menu) {
        this._initImageMenu(menu, null);
    }

    public void initImageMenu(JPopupMenu menu, URL url) {
        this._initImageMenu(menu, url);
    }

    private void _initImageMenu(JComponent menu, final URL url) {
        DivaMainImageDisplay imageDisplay = this._imageFrame.getImageDisplayControl().getImageDisplay();
        if (menu instanceof JMenu) {
            JMenu jMenu = (JMenu)menu;
            jMenu.add(this.getRegisterAction(true));
            jMenu.add(this.getRegisterAction(false));
            jMenu.add((Action)((Object)new HubWatchAction((Component)((Object)this._imageFrame), this)));
            jMenu.add(this.getHubStartAction(true));
            jMenu.add(this.getHubStartAction(false));
            jMenu.addSeparator();
        }
        PlasticTransmitter trans = new PlasticTransmitter(this, MessageId.FITS_LOADIMAGE, "image"){

            protected void transmit(PlasticHubListener hub, URI clientId, ApplicationItem app) throws IOException {
                URI[] uRIArray;
                if (app == null) {
                    uRIArray = null;
                } else {
                    URI[] uRIArray2 = new URI[1];
                    uRIArray = uRIArray2;
                    uRIArray2[0] = app.getId();
                }
                URI[] recipients = uRIArray;
                PlasticHelper.this.transmitImage(hub, clientId, recipients, url);
            }
        };
        JMenu sendMenu = trans.createSendMenu();
        sendMenu.setIcon(Resources.getIcon((String)"phone2.gif"));
        menu.add(sendMenu);
        JMenuItem broadCastItem = new JMenuItem("Broadcast Image");
        broadCastItem.setIcon(Resources.getIcon((String)"broadcast.gif"));
        broadCastItem.addActionListener(trans.getBroadcastAction());
        menu.add(broadCastItem);
        if (url == null) {
            broadCastItem.setEnabled(false);
            trans.setEnabled(false);
            imageDisplay.addChangeListener(new ChangeListener((MainImageDisplay)imageDisplay, trans, broadCastItem){
                final /* synthetic */ MainImageDisplay val$imageDisplay;
                final /* synthetic */ PlasticTransmitter val$trans;
                final /* synthetic */ JMenuItem val$broadCastItem;
                {
                    this.val$imageDisplay = mainImageDisplay;
                    this.val$trans = plasticTransmitter;
                    this.val$broadCastItem = jMenuItem;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ImageChangeEvent e = (ImageChangeEvent)changeEvent;
                    if (e.isNewImage() && !e.isBefore()) {
                        boolean enabled = this.val$imageDisplay.getURL() != null || this.val$imageDisplay.getFilename() != null;
                        this.val$trans.setEnabled(enabled);
                        this.val$broadCastItem.setEnabled(enabled);
                    }
                }
            });
        } else {
            trans.setEnabled(true);
        }
    }

    public void initTableMenu(JMenu menu) {
        this._initTableMenu(menu, null, null, new HashMap());
    }

    public void initTableMenu(JPopupMenu menu, URL url, String format, Map ucdMap) {
        this._initTableMenu(menu, url, format, ucdMap);
    }

    public void initTableMenu(JMenu menu, URL url, String format, Map ucdMap) {
        this._initTableMenu(menu, url, format, ucdMap);
    }

    private void _initTableMenu(JComponent menu, final URL url, final String format, final Map ucdMap) {
        final Navigator navigator = this._imageFrame.getNavigator();
        if (menu instanceof JMenu) {
            JMenu jMenu = (JMenu)menu;
            jMenu.add(this.getRegisterAction(true));
            jMenu.add(this.getRegisterAction(false));
            jMenu.add((Action)((Object)new HubWatchAction((Component)((Object)this._imageFrame), this)));
            jMenu.add(this.getHubStartAction(true));
            jMenu.add(this.getHubStartAction(false));
            jMenu.addSeparator();
        }
        boolean isSpectrum = format != null && format.startsWith("spectrum/");
        final PlasticTransmitter trans = new PlasticTransmitter(this, isSpectrum ? MessageId.SPECTRUM_LOADURL : MessageId.VOT_LOADURL, isSpectrum ? "spectrum" : "table"){

            protected void transmit(PlasticHubListener hub, URI clientId, ApplicationItem app) throws IOException {
                URI[] uRIArray;
                if (app == null) {
                    uRIArray = null;
                } else {
                    URI[] uRIArray2 = new URI[1];
                    uRIArray = uRIArray2;
                    uRIArray2[0] = app.getId();
                }
                URI[] recipients = uRIArray;
                PlasticHelper.this.transmitTable(hub, clientId, recipients, url, format, ucdMap);
            }
        };
        JMenu sendMenu = trans.createSendMenu();
        sendMenu.setIcon(Resources.getIcon((String)"phone2.gif"));
        menu.add(sendMenu);
        final JMenuItem broadCastItem = new JMenuItem(isSpectrum ? "Broadcast Spectrum" : "Broadcast Table");
        broadCastItem.setIcon(Resources.getIcon((String)"broadcast.gif"));
        broadCastItem.addActionListener(trans.getBroadcastAction());
        menu.add(broadCastItem);
        if (url == null) {
            broadCastItem.setEnabled(false);
            trans.setEnabled(false);
            navigator.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    boolean enabled = navigator.getResultComponent() instanceof TableDisplayTool;
                    trans.setEnabled(enabled);
                    broadCastItem.setEnabled(enabled);
                }
            });
        } else {
            trans.setEnabled(true);
        }
    }

    private void transmitTable(final PlasticHubListener hub, final URI plasticId, final URI[] recipients, URL url, final String format, final Map ucdMap) throws IOException {
        String name;
        String urlStr;
        File tmpfile;
        Navigator navigator = this._imageFrame.getNavigator();
        if (url == null) {
            tmpfile = File.createTempFile("plastic", ".vot");
            urlStr = URLUtils.makeFileURL((File)tmpfile).toString();
            tmpfile.deleteOnExit();
            BufferedOutputStream ostrm = new BufferedOutputStream(new FileOutputStream(tmpfile));
            StarTable starTable = navigator.getStarTable();
            name = starTable.getName();
            try {
                new VOTableWriter(DataFormat.TABLEDATA, true).writeStarTable(starTable, (OutputStream)ostrm);
            }
            catch (IOException e) {
                tmpfile.delete();
                throw e;
            }
            finally {
                ((OutputStream)ostrm).close();
            }
        } else {
            urlStr = url.toString();
            name = plasticId.toString();
            tmpfile = null;
        }
        navigator.registerTable(new URL(urlStr), name);
        new Thread("PLASTIC table broadcast"){

            @Override
            public void run() {
                Map responses;
                List<Object> argList;
                URI msgId;
                if (format != null && format.startsWith("spectrum/")) {
                    msgId = MessageId.SPECTRUM_LOADURL;
                    argList = Arrays.asList(urlStr, urlStr, ucdMap);
                } else {
                    msgId = MessageId.VOT_LOADURL;
                    argList = Arrays.asList(urlStr, urlStr);
                }
                LOG.info("PLASTIC Send: " + msgId + ": " + urlStr);
                Map map = responses = recipients == null ? hub.request(plasticId, msgId, argList) : hub.requestToSubset(plasticId, msgId, argList, Arrays.asList(recipients));
                if (tmpfile != null) {
                    tmpfile.delete();
                }
            }
        }.start();
    }

    private void transmitImage(final PlasticHubListener hub, final URI plasticId, final URI[] recipients, URL url) throws IOException {
        DivaMainImageDisplay imageDisplay = this._imageFrame.getImageDisplayControl().getImageDisplay();
        URL imageUrl = url;
        if (imageUrl == null) {
            String fileName = imageDisplay.getFilename();
            imageUrl = imageDisplay.getURL();
            if (fileName != null) {
                imageUrl = new File(fileName).toURI().toURL();
            }
        }
        if (imageUrl == null) {
            return;
        }
        final String urlStr = imageUrl.toString();
        new Thread("FITS broadcast"){

            @Override
            public void run() {
                List<String> argList = Arrays.asList(urlStr, urlStr);
                URI msgId = MessageId.FITS_LOADIMAGE;
                LOG.info("PLASTIC Send: " + msgId + ": " + urlStr);
                Map responses = recipients == null ? hub.request(plasticId, msgId, argList) : hub.requestToSubset(plasticId, msgId, argList, Arrays.asList(recipients));
            }
        }.start();
    }

    private static class HubWatchAction
    extends BasicAction {
        private final Component parent_;
        private final HubManager hubManager_;
        private JFrame hubWindow_;

        HubWatchAction(Component parent, HubManager hubManager) {
            super("Show Registered Applications", null, "Display applications registered with the PLASTIC hub");
            this.parent_ = parent;
            this.hubManager_ = hubManager;
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.hubWindow_ == null) {
                this.hubWindow_ = new PlasticListWindow(this.hubManager_.getApplicationListModel());
                this.hubWindow_.setTitle("PLASTIC apps");
                SwingUtil.positionAfter((Component)this.parent_, (Window)this.hubWindow_);
                this.hubWindow_.pack();
            }
            this.hubWindow_.setVisible(true);
        }
    }
}

