/*
 * Decompiled with CFR 0.152.
 */
package jsky.plot;

import java.util.Date;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.coords.SiteDesc;
import jsky.coords.TargetDesc;
import jsky.plot.ElevationPlotFrame;
import jsky.plot.ElevationPlotModel;
import jsky.plot.ElevationPlotPanel;
import jsky.plot.ElevationPlotUtil;
import jsky.util.Preferences;
import jsky.util.gui.SwingUtil;

public final class ElevationPlotManager {
    private static ElevationPlotFrame _elevationPlotFrame;
    private static ElevationPlotPanel _panel;

    public static ElevationPlotPanel get() {
        return _panel;
    }

    public static ElevationPlotPanel open(ChangeListener l) {
        if (_elevationPlotFrame != null) {
            SwingUtil.showFrame((JFrame)_elevationPlotFrame);
        } else {
            _elevationPlotFrame = new ElevationPlotFrame();
            _panel = _elevationPlotFrame.getPlotPanel();
            if (l != null) {
                l.stateChanged(new ChangeEvent(_panel));
            }
        }
        return _panel;
    }

    public static void show(TargetDesc[] targets, SiteDesc site, ChangeListener l) {
        String timeZoneDisplayName = "UT";
        String timeZoneId = "UT";
        ElevationPlotPanel plotPanel = ElevationPlotManager.open(l);
        ElevationPlotModel oldModel = plotPanel.getModel();
        Date date = new Date();
        if (oldModel == null) {
            String siteName = Preferences.get((String)ElevationPlotModel.SITE_PREF_KEY);
            if (siteName != null) {
                site = ElevationPlotUtil.getSite(siteName, site);
            }
            timeZoneDisplayName = Preferences.get((String)ElevationPlotModel.TIMEZONE_DISPLAY_NAME_PREF_KEY, (String)timeZoneDisplayName);
            timeZoneId = Preferences.get((String)ElevationPlotModel.TIMEZONE_ID_PREF_KEY, (String)timeZoneId);
        } else {
            timeZoneDisplayName = oldModel.getTimeZoneDisplayName();
            timeZoneId = oldModel.getTimeZoneId();
            site = oldModel.getSite();
            date = oldModel.getDate();
        }
        ElevationPlotModel model = new ElevationPlotModel(site, date, targets, timeZoneDisplayName, timeZoneId);
        plotPanel.setModel(model);
    }
}

