/*
 * Decompiled with CFR 0.152.
 */
package jsky.plot;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRadioButtonMenuItem;
import jsky.plot.ElevationPlotModel;
import jsky.plot.ElevationPlotPanel;
import jsky.plot.ElevationPlotUtil;
import jsky.util.I18N;
import jsky.util.Preferences;

public class ElevationPlotMenuBar
extends JMenuBar {
    private static final I18N _I18N = I18N.getInstance(ElevationPlotMenuBar.class);
    private ElevationPlotPanel _plotPanel;
    private JMenu _fileMenu;
    private JMenu _viewMenu;
    private JCheckBoxMenuItem _showLegendMenuItem;

    public ElevationPlotMenuBar(ElevationPlotPanel plotPanel) {
        this._plotPanel = plotPanel;
        this._fileMenu = this.createFileMenu();
        this.add(this._fileMenu);
        this._viewMenu = this.createViewMenu();
        this.add(this._viewMenu);
    }

    protected JMenu createFileMenu() {
        JMenu menu = new JMenu(_I18N.getString("file"));
        menu.add(this._plotPanel.getSaveAsAction());
        menu.add(this._plotPanel.getPrintAction());
        menu.addSeparator();
        menu.add(this._plotPanel.getCloseAction());
        return menu;
    }

    protected JMenu createViewMenu() {
        JMenu menu = new JMenu(_I18N.getString("view"));
        menu.add(this._plotPanel.getDateAction());
        menu.add(this._plotPanel.getTargetsAction());
        this._showLegendMenuItem = this._createViewLegendMenuItem();
        menu.add(this._showLegendMenuItem);
        menu.add(this.createViewSamplePeriodMenu());
        return menu;
    }

    private JCheckBoxMenuItem _createViewLegendMenuItem() {
        final String SHOW_LEGEND_PREF_KEY = this.getClass().getName() + ".showLegend";
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(_I18N.getString("showLegend"));
        boolean showNow = Preferences.get((String)SHOW_LEGEND_PREF_KEY, (boolean)true);
        if (!showNow) {
            this._plotPanel.setShowLegend(false);
        }
        menuItem.setSelected(showNow);
        menuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JCheckBoxMenuItem cb = (JCheckBoxMenuItem)e.getSource();
                boolean show = cb.isSelected();
                ElevationPlotMenuBar.this._plotPanel.setShowLegend(show);
                Preferences.set((String)SHOW_LEGEND_PREF_KEY, (boolean)show);
            }
        });
        return menuItem;
    }

    protected JMenu createViewSamplePeriodMenu() {
        final String prefName = this.getClass().getName() + ".SamplePeriod";
        JMenu menu = new JMenu("Sample Period");
        final String[] choices = new String[]{"1 minute", "5 minutes", "10 minutes", "15 minutes", "30 minutes"};
        final ArrayList<JRadioButtonMenuItem> l = new ArrayList<JRadioButtonMenuItem>(choices.length);
        JRadioButtonMenuItem[] ar = new JRadioButtonMenuItem[choices.length];
        for (int i = 0; i < choices.length; ++i) {
            ar[i] = new JRadioButtonMenuItem(choices[i]);
            l.add(ar[i]);
        }
        ar[1].setSelected(true);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int i;
                JRadioButtonMenuItem rb = (JRadioButtonMenuItem)e.getSource();
                if (rb.isSelected() && (i = l.indexOf(rb)) != -1) {
                    int minutes = Integer.parseInt(choices[i].substring(0, 2).trim());
                    ElevationPlotModel model = ElevationPlotMenuBar.this._plotPanel.getModel();
                    if (model != null) {
                        model.setSampleInterval(minutes);
                    } else {
                        ElevationPlotUtil.setDefaultNumSteps(1440 / minutes);
                    }
                    Preferences.set((String)prefName, (String)choices[i]);
                }
            }
        };
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < choices.length; ++i) {
            menu.add(ar[i]);
            group.add(ar[i]);
            ar[i].addItemListener(itemListener);
        }
        String pref = Preferences.get((String)prefName);
        if (pref != null) {
            for (int i = 0; i < choices.length; ++i) {
                if (!pref.equals(choices[i])) continue;
                ar[i].setSelected(true);
                break;
            }
        }
        return menu;
    }

    public JMenu getFileMenu() {
        return this._fileMenu;
    }

    public JMenu getViewMenu() {
        return this._viewMenu;
    }

    public JCheckBoxMenuItem getShowLegendMenuItem() {
        return this._showLegendMenuItem;
    }
}

