/*
 * Decompiled with CFR 0.152.
 */
package jsky.plot;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import jsky.coords.SiteDesc;
import jsky.coords.TargetDesc;
import jsky.coords.WorldCoords;
import jsky.util.SkyCalc;

public class ElevationPlotUtil {
    public static final SiteDesc MAUNA_KEA = new SiteDesc("Mauna Kea", -155.4717, 19.8267, TimeZone.getTimeZone("Pacific/Honolulu"));
    public static final SiteDesc CERRO_PANCHON = new SiteDesc("Cerro Pachon", -70.815, -30.165, TimeZone.getTimeZone("America/Santiago"));
    public static final SiteDesc[] AVAILABLE_SITES = new SiteDesc[]{MAUNA_KEA, CERRO_PANCHON};
    public static final TimeZone UT = TimeZone.getTimeZone("UT");
    private static int _defaultNumSteps = 288;
    private int _numSteps = _defaultNumSteps;
    private int _stepIncrement = 1440 / this._numSteps;
    private Date _date;
    private SiteDesc _site;
    private TargetDesc[] _targets;
    private SkyCalc _skyCalc;
    private Date[][] _xData;
    private double[][] _yData;
    private double[][] _yDataAirmass;
    private double[][] _yDataPa;

    public ElevationPlotUtil(Date date, SiteDesc site, TargetDesc[] targets) {
        this._date = date;
        this._site = site;
        this._targets = targets;
        this._init();
    }

    private void _init() {
        int numSteps = this.getNumSteps();
        this._xData = new Date[this._targets.length][numSteps];
        this._yData = new double[this._targets.length][numSteps];
        this._yDataAirmass = new double[this._targets.length][numSteps];
        this._yDataPa = new double[this._targets.length][numSteps];
        this._skyCalc = new SkyCalc(this._site);
        Calendar cal = Calendar.getInstance(this._site.getTimeZone());
        cal.setTime(this._date);
        cal.set(11, 12);
        cal.set(12, 0);
        cal.set(13, 0);
        for (int j = 0; j < numSteps; ++j) {
            for (int i = 0; i < this._targets.length; ++i) {
                WorldCoords pos = this._targets[i].getCoordinates();
                Date utTime = cal.getTime();
                this._skyCalc.calculate(pos, utTime);
                this._xData[i][j] = utTime;
                this._yData[i][j] = this._skyCalc.getAltitude();
                this._yDataAirmass[i][j] = this._skyCalc.getAirmass();
                this._yDataPa[i][j] = this._skyCalc.getParallacticAngle();
            }
            cal.add(12, this._stepIncrement);
        }
    }

    public int getNumSteps() {
        return this._numSteps;
    }

    public void setNumSteps(int numSteps) {
        this._numSteps = numSteps;
        this._stepIncrement = 1440 / this._numSteps;
        this._init();
    }

    public static void setDefaultNumSteps(int numSteps) {
        _defaultNumSteps = numSteps;
    }

    public static double getAirmass(double elevation) {
        return SkyCalc.getAirmass(elevation);
    }

    public Date[][] getXData() {
        return this._xData;
    }

    public double[][] getYData() {
        return this._yData;
    }

    public double[][] getYDataAirmass() {
        return this._yDataAirmass;
    }

    public double[][] getYDataPa() {
        return this._yDataPa;
    }

    public static double normalizeHours(double h) {
        if (h > 24.0) {
            h -= 24.0;
        } else if (h < 0.0) {
            h += 24.0;
        }
        return h;
    }

    public static SiteDesc getSite(String siteName, SiteDesc defaultSite) {
        for (SiteDesc site : AVAILABLE_SITES) {
            if (!siteName.equals(site.getName())) continue;
            return site;
        }
        return defaultSite;
    }

    public static SiteDesc getSite(String siteName) {
        return ElevationPlotUtil.getSite(siteName, AVAILABLE_SITES[0]);
    }

    public Date getLst(Date date) {
        return this._skyCalc.getLst(date);
    }
}

