/*
 * Decompiled with CFR 0.152.
 */
package jsky.plot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.MemoryCatalog;
import jsky.coords.TargetDesc;
import jsky.plot.ElevationPlotModel;
import jsky.util.I18N;
import jsky.util.PrintableWithDialog;
import jsky.util.SaveableWithDialog;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.SexagesimalTableCellRenderer;
import jsky.util.gui.SortedJTable;

public class TablePanel
extends JPanel
implements PrintableWithDialog,
SaveableWithDialog {
    private static final I18N _I18N = I18N.getInstance(TablePanel.class);
    private JTabbedPane _tabbedPane;
    private SortedJTable[] _tables;
    private ElevationPlotModel _model;
    private TableCellRenderer _timeCellRenderer = new SexagesimalTableCellRenderer(false, false);
    private static JFileChooser _fileChooser;
    private static NumberFormat _nf1;
    private static NumberFormat _nf2;
    private TableCellRenderer _cellRenderer1 = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ((JLabel)component).setText(_nf1.format((Double)value));
            return component;
        }
    };
    private TableCellRenderer _cellRenderer2 = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ((JLabel)component).setText(_nf2.format((Double)value));
            return component;
        }
    };

    public TablePanel() {
        this.setLayout(new BorderLayout());
        this._tabbedPane = new JTabbedPane();
        this.add((Component)this._tabbedPane, "Center");
    }

    public void setModel(ElevationPlotModel model) {
        this._model = model;
        this._update();
        this._model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TablePanel.this._update();
            }
        });
    }

    public ElevationPlotModel getModel() {
        return this._model;
    }

    private void _update() {
        this._tabbedPane.removeAll();
        TargetDesc[] targets = this._model.getTargets();
        this._tables = new SortedJTable[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            this._tables[i] = new SortedJTable(this._model.getTableModel(i));
            this._tabbedPane.add((Component)new JScrollPane((Component)this._tables[i]), targets[i].getName());
            TableColumnModel tcm = this._tables[i].getColumnModel();
            tcm.getColumn(0).setCellRenderer(this._timeCellRenderer);
            tcm.getColumn(1).setCellRenderer(this._cellRenderer1);
            tcm.getColumn(2).setCellRenderer(this._cellRenderer2);
            tcm.getColumn(3).setCellRenderer(this._cellRenderer2);
        }
    }

    public void print() throws PrinterException {
        int index = this._tabbedPane.getSelectedIndex();
        if (index != -1) {
            this._tables[index].showPrintDialog(this._tabbedPane.getTitleAt(index));
        }
    }

    private JFileChooser _makeFileChooser() {
        return new JFileChooser();
    }

    public void saveAs() {
        try {
            int index = this._tabbedPane.getSelectedIndex();
            if (index != -1) {
                int option;
                if (_fileChooser == null) {
                    _fileChooser = this._makeFileChooser();
                }
                if ((option = _fileChooser.showSaveDialog(this)) == 0 && _fileChooser.getSelectedFile() != null) {
                    this.saveAs(this._tables[index], this._tabbedPane.getTitleAt(index), _fileChooser.getSelectedFile());
                }
            }
        }
        catch (Exception e) {
            DialogUtil.error((Exception)e);
        }
    }

    public void saveAs(SortedJTable table, String title, File file) throws IOException {
        String msg;
        int ans;
        if (file.exists() && (ans = DialogUtil.confirm((String)(msg = _I18N.getString("fileOverWritePrompt", new Object[]{file.getName()})))) != 0) {
            return;
        }
        TableModel model = table.getModel();
        FieldDesc[] fieldDesc = new FieldDesc[]{new FieldDescAdapter(model.getColumnName(0)), new FieldDescAdapter(model.getColumnName(1))};
        int numRows = model.getRowCount();
        int numCols = model.getColumnCount();
        Vector dataVector = new Vector(numRows);
        for (int i = 0; i < numRows; ++i) {
            Vector<Object> row = new Vector<Object>(numCols);
            for (int j = 0; j < numCols; ++j) {
                row.add(model.getValueAt(i, j));
            }
            dataVector.add(row);
        }
        MemoryCatalog catalog = new MemoryCatalog(fieldDesc, dataVector);
        catalog.setTitle(title);
        FileOutputStream os = new FileOutputStream(file);
        catalog.saveAsSkycatTable((OutputStream)os);
        os.close();
    }

    static {
        _nf1 = NumberFormat.getInstance(Locale.US);
        _nf2 = NumberFormat.getInstance(Locale.US);
        _nf1.setMinimumFractionDigits(1);
        _nf1.setMaximumFractionDigits(1);
        _nf2.setMinimumFractionDigits(2);
        _nf2.setMaximumFractionDigits(2);
    }
}

