/*
 * Decompiled with CFR 0.152.
 */
package jsky.plot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import jsky.coords.TargetDesc;
import jsky.coords.WorldCoords;
import jsky.plot.TargetListPanelGUI;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.SwingUtil;

public class TargetListPanel
extends JPanel {
    private static final int NAME_COL = 0;
    private static final int RA_COL = 1;
    private static final int DEC_COL = 2;
    private static final int DESCRIPTION_COL = 3;
    private static final int PRIORITY_COL = 4;
    private static final int CATEGORY_COL = 5;
    private TargetListPanelGUI _w = new TargetListPanelGUI();
    private Vector<Object> _heading = new Vector(2);
    private TargetDesc[] _targets;
    private EventListenerList _listenerList = new EventListenerList();
    private boolean _edited = false;

    public TargetListPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this._w, "Center");
        this._heading.add("Name");
        this._heading.add("RA");
        this._heading.add("Dec");
        this._heading.add("Description");
        this._heading.add("Priority");
        this._heading.add("Category");
        this._w.table.setModel(new DefaultTableModel(new Vector(), this._heading){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        });
        this._w.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = ((TargetListPanel)TargetListPanel.this)._w.table.getSelectedRow();
                if (row >= 0) {
                    TableModel model = ((TargetListPanel)TargetListPanel.this)._w.table.getModel();
                    String name = (String)model.getValueAt(row, 0);
                    String raStr = (String)model.getValueAt(row, 1);
                    String decStr = (String)model.getValueAt(row, 2);
                    String description = (String)model.getValueAt(row, 3);
                    String priority = (String)model.getValueAt(row, 4);
                    String category = (String)model.getValueAt(row, 5);
                    ((TargetListPanel)TargetListPanel.this)._w.nameField.setText(name);
                    ((TargetListPanel)TargetListPanel.this)._w.raField.setText(raStr);
                    ((TargetListPanel)TargetListPanel.this)._w.decField.setText(decStr);
                    ((TargetListPanel)TargetListPanel.this)._w.descriptionField.setText(description);
                    ((TargetListPanel)TargetListPanel.this)._w.priorityField.setText(priority);
                    ((TargetListPanel)TargetListPanel.this)._w.categoryField.setText(category);
                }
            }
        });
        this._w.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TargetListPanel.this._addNewTarget();
                }
                catch (Exception ex) {
                    DialogUtil.error((String)("Invalid coordinate: " + ex.getMessage()));
                }
            }
        });
        this._w.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TargetListPanel.this._removeSelectedTarget();
            }
        });
        this._w.changeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TargetListPanel.this._changeTarget();
                }
                catch (Exception ex) {
                    DialogUtil.error((String)("Invalid coordinate: " + ex.getMessage()));
                }
            }
        });
        this._w.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TargetListPanel.this.setTargets(TargetListPanel.this._targets);
                JFrame parent = SwingUtil.getFrame((Component)TargetListPanel.this);
                if (parent != null) {
                    parent.setVisible(false);
                }
            }
        });
        this._w.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame parent;
                TargetListPanel.this._updateTargets();
                if (TargetListPanel.this._edited) {
                    TargetListPanel.this._edited = false;
                    TargetListPanel.this._fireChange();
                }
                if ((parent = SwingUtil.getFrame((Component)TargetListPanel.this)) != null) {
                    parent.setVisible(false);
                }
            }
        });
    }

    private void _addNewTarget() {
        String name = this._w.nameField.getText();
        String raStr = this._w.raField.getText();
        String decStr = this._w.decField.getText();
        WorldCoords pos = new WorldCoords(raStr, decStr);
        String description = this._w.descriptionField.getText();
        String priority = this._w.priorityField.getText();
        String category = this._w.categoryField.getText();
        this._addRow(new TargetDesc(name, pos, description, priority, category));
    }

    private void _changeTarget() {
        int row = this._w.table.getSelectedRow();
        if (row >= 0) {
            String name = this._w.nameField.getText();
            String raStr = this._w.raField.getText();
            String decStr = this._w.decField.getText();
            WorldCoords pos = new WorldCoords(raStr, decStr);
            String description = this._w.descriptionField.getText();
            String priority = this._w.priorityField.getText();
            String category = this._w.categoryField.getText();
            this._changeRow(row, new TargetDesc(name, pos, description, priority, category));
        }
    }

    private void _addRow(TargetDesc target) {
        DefaultTableModel model = (DefaultTableModel)this._w.table.getModel();
        Vector<String> row = new Vector<String>(5);
        row.add(target.getName());
        WorldCoords pos = target.getCoordinates();
        row.add(pos.getRA().toString());
        row.add(pos.getDec().toString());
        row.add(target.getDescription());
        row.add(target.getPriority());
        row.add(target.getCategory());
        model.addRow(row);
        this._edited = true;
    }

    private void _changeRow(int row, TargetDesc target) {
        WorldCoords pos = target.getCoordinates();
        DefaultTableModel model = (DefaultTableModel)this._w.table.getModel();
        model.setValueAt(target.getName(), row, 0);
        model.setValueAt(pos.getRA().toString(), row, 1);
        model.setValueAt(pos.getDec().toString(), row, 2);
        model.setValueAt(target.getDescription(), row, 3);
        model.setValueAt(target.getPriority(), row, 4);
        model.setValueAt(target.getCategory(), row, 5);
        this._edited = true;
    }

    private void _removeSelectedTarget() {
        int row = this._w.table.getSelectedRow();
        if (row >= 0) {
            DefaultTableModel model = (DefaultTableModel)this._w.table.getModel();
            model.removeRow(row);
            this._edited = true;
        }
    }

    private void _updateTargets() {
        TableModel model = this._w.table.getModel();
        int n = model.getRowCount();
        this._targets = new TargetDesc[n];
        for (int i = 0; i < n; ++i) {
            String name = (String)model.getValueAt(i, 0);
            String raStr = (String)model.getValueAt(i, 1);
            String decStr = (String)model.getValueAt(i, 2);
            WorldCoords pos = new WorldCoords(raStr, decStr);
            String description = (String)model.getValueAt(i, 3);
            String priority = (String)model.getValueAt(i, 4);
            String category = (String)model.getValueAt(i, 5);
            this._targets[i] = new TargetDesc(name, pos, description, priority, category);
        }
    }

    public TargetDesc[] getTargets() {
        return this._targets;
    }

    public void setTargets(TargetDesc[] targets) {
        this._targets = targets;
        Vector rows = new Vector(targets.length);
        for (TargetDesc target : targets) {
            Vector<String> row = new Vector<String>(3);
            row.add(target.getName());
            WorldCoords pos = target.getCoordinates();
            row.add(pos.getRA().toString());
            row.add(pos.getDec().toString());
            row.add(target.getDescription());
            row.add(target.getPriority());
            row.add(target.getCategory());
            rows.add(row);
        }
        this._w.table.setModel(new DefaultTableModel(rows, this._heading){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        });
    }

    public void addChangeListener(ChangeListener l) {
        this._listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this._listenerList.remove(ChangeListener.class, l);
    }

    private void _fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
        }
    }
}

