/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends FilterOutputStream {
    static byte[] endLine;
    private static final char[] encoding;
    private byte[] input = new byte[3];
    private short inputCount = 0;
    private short charsOnLine = 0;
    private int charsPerLine;
    private static final int DEFAULT_QUADS_PER_LINE = 16;
    private boolean doLineBreaks = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Base64OutputStream(OutputStream out) {
        super(out);
    }

    public Base64OutputStream(OutputStream out, int quadsPerLine) {
        this(out);
        this.doLineBreaks = true;
        if (!$assertionsDisabled && quadsPerLine <= 0) {
            throw new AssertionError((Object)"quadsPerLine must be > 0");
        }
        this.charsPerLine = quadsPerLine * 4;
    }

    public void write(int oneByte) throws IOException {
        short s = this.inputCount;
        this.inputCount = (short)(s + 1);
        this.input[s] = (byte)(0xFF & oneByte);
        if (this.inputCount == 3) {
            this.outputOneAtom();
            if (this.doLineBreaks) {
                if (this.charsOnLine == this.charsPerLine) {
                    this.out.write(endLine);
                    this.charsOnLine = 0;
                }
                if (!$assertionsDisabled && this.charsOnLine >= this.charsPerLine) {
                    throw new AssertionError();
                }
            }
        }
        if (!$assertionsDisabled && this.inputCount >= 3) {
            throw new AssertionError();
        }
    }

    public void close() throws IOException {
        this.endBase64();
        this.out.close();
    }

    public void endBase64() throws IOException {
        if (this.inputCount > 0) {
            this.outputOneAtom();
        }
        if (this.doLineBreaks) {
            this.out.write(endLine);
            this.charsOnLine = 0;
        }
    }

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, int offset, int count) throws IOException {
        int i = offset;
        for (int byteCount = 0; byteCount < count; ++byteCount) {
            this.write(buffer[i]);
            ++i;
        }
    }

    private void outputOneAtom() throws IOException {
        byte[] output = new byte[4];
        if (this.inputCount == 0) {
            return;
        }
        if (this.inputCount < 3) {
            this.input[2] = 0;
            if (this.inputCount < 2) {
                this.input[1] = 0;
            }
        }
        output[0] = (byte)encoding[this.input[0] >>> 2 & 0x3F];
        output[1] = (byte)encoding[this.input[0] << 4 & 0x30 | this.input[1] >>> 4 & 0xF];
        output[2] = (byte)encoding[this.input[1] << 2 & 0x3C | this.input[2] >>> 6 & 3];
        output[3] = (byte)encoding[this.input[2] & 0x3F];
        if (this.inputCount < 3) {
            output[3] = 61;
            if (this.inputCount < 2) {
                output[2] = 61;
            }
        }
        this.out.write(output);
        this.inputCount = 0;
        if (this.doLineBreaks) {
            this.charsOnLine = (short)(this.charsOnLine + 4);
        }
    }

    static {
        $assertionsDisabled = !Base64OutputStream.class.desiredAssertionStatus();
        try {
            endLine = System.getProperty("line.separator").getBytes();
        }
        catch (SecurityException e) {
            endLine = new byte[]{10};
        }
        encoding = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    }
}

