/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SourceReader {
    private Transformer transformer;
    private static Logger logger = Logger.getLogger("uk.ac.starlink.util");

    public Transformer getTransformer() {
        if (this.transformer == null) {
            try {
                this.transformer = TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerException e) {
                throw new RuntimeException("Unexpected configuration problem", e);
            }
            this.transformer.setOutputProperty("method", "xml");
            this.setIndent(-1);
            this.setIncludeDeclaration(true);
            this.transformer.setErrorListener(new ErrorListener(){

                public void warning(TransformerException e) throws TransformerException {
                    this.log(e);
                }

                public void error(TransformerException e) throws TransformerException {
                    this.log(e);
                }

                public void fatalError(TransformerException e) throws TransformerException {
                    throw e;
                }

                private void log(TransformerException e) {
                    logger.warning(e.toString());
                }
            });
        }
        return this.transformer;
    }

    public void setTransformer(Transformer trans) {
        this.transformer = trans;
    }

    public Node getDOM(Source src) throws TransformerException {
        if (src instanceof DOMSource) {
            return ((DOMSource)src).getNode();
        }
        DOMResult res = new DOMResult();
        this.transform(src, res);
        return res.getNode();
    }

    public Element getElement(Source src) throws TransformerException {
        Node node = this.getDOM(src);
        if (node instanceof Element) {
            return (Element)node;
        }
        if (node instanceof Document) {
            return ((Document)node).getDocumentElement();
        }
        throw new IllegalArgumentException("Source " + src + " is not an Element or Document");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSource(Source src, Writer wr) throws TransformerException {
        try {
            Reader rdr;
            if (!(wr instanceof BufferedWriter)) {
                wr = new BufferedWriter(wr);
            }
            if ((rdr = SourceReader.getReader(src)) != null) {
                try {
                    int c;
                    if (!(rdr instanceof BufferedReader)) {
                        rdr = new BufferedReader(rdr);
                    }
                    while ((c = rdr.read()) > -1) {
                        wr.write(c);
                    }
                }
                finally {
                    rdr.close();
                }
            } else {
                StreamResult res = new StreamResult(wr);
                this.transform(src, res);
            }
            wr.flush();
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSource(Source src, OutputStream ostrm) throws TransformerException {
        try {
            InputStream istrm;
            if (!(ostrm instanceof BufferedOutputStream)) {
                ostrm = new BufferedOutputStream(ostrm);
            }
            if ((istrm = SourceReader.getInputStream(src)) != null) {
                try {
                    int b;
                    if (!(istrm instanceof BufferedInputStream)) {
                        istrm = new BufferedInputStream(istrm);
                    }
                    while ((b = istrm.read()) > -1) {
                        ostrm.write(b);
                    }
                }
                finally {
                    istrm.close();
                }
            } else {
                StreamResult res = new StreamResult(ostrm);
                this.transform(src, res);
            }
            ostrm.flush();
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
    }

    public InputStream getXMLStream(final Source src) {
        PipedInputStream istrm;
        final PipedOutputStream ostrm = new PipedOutputStream();
        try {
            istrm = new PipedInputStream(ostrm);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"What could go wrong?");
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SourceReader.this.writeSource(src, ostrm);
                }
                catch (TransformerException e) {
                }
                finally {
                    try {
                        ostrm.close();
                    }
                    catch (IOException e) {}
                }
            }
        }.start();
        return istrm;
    }

    public SourceReader setIndent(int indent) {
        Transformer trans = this.getTransformer();
        if (indent >= 0) {
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
        } else {
            trans.setOutputProperty("indent", "no");
        }
        return this;
    }

    public SourceReader setIncludeDeclaration(boolean flag) {
        Transformer trans = this.getTransformer();
        trans.setOutputProperty("omit-xml-declaration", flag ? "no" : "yes");
        return this;
    }

    private void transform(Source src, Result res) throws TransformerException {
        Transformer trans = this.getTransformer();
        trans.transform(src, res);
    }

    private static Reader getReader(Source src) {
        Reader rdr;
        SAXSource saxsrc;
        InputSource input;
        StreamSource strmsrc;
        Reader rdr2;
        if (src instanceof StreamSource && (rdr2 = (strmsrc = (StreamSource)src).getReader()) != null) {
            return rdr2;
        }
        if (src instanceof SAXSource && (input = (saxsrc = (SAXSource)src).getInputSource()) != null && (rdr = input.getCharacterStream()) != null) {
            return rdr;
        }
        InputStream istrm = SourceReader.getInputStream(src);
        if (istrm != null) {
            return new InputStreamReader(istrm);
        }
        return null;
    }

    private static InputStream getInputStream(Source src) {
        SAXSource saxsrc;
        InputSource input;
        if (src instanceof StreamSource) {
            StreamSource strmsrc = (StreamSource)src;
            InputStream istrm = strmsrc.getInputStream();
            if (istrm != null) {
                return istrm;
            }
            String sysid = strmsrc.getSystemId();
            if (sysid != null) {
                try {
                    URL url = new URL(sysid);
                    return url.openStream();
                }
                catch (MalformedURLException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (src instanceof SAXSource && (input = (saxsrc = (SAXSource)src).getInputSource()) != null) {
            InputStream istrm = input.getByteStream();
            if (istrm != null) {
                return istrm;
            }
            String sysid = saxsrc.getSystemId();
            if (sysid != null) {
                try {
                    URL url = new URL(sysid);
                    return url.openStream();
                }
                catch (MalformedURLException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

