/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StarEntityResolver
implements EntityResolver {
    private static StarEntityResolver instance = new StarEntityResolver();
    private EntityResolver parent;

    private StarEntityResolver() {
    }

    public StarEntityResolver(EntityResolver parent) {
        this.parent = parent;
    }

    public static StarEntityResolver getInstance() {
        return instance;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String local = this.getLocalResource(publicId, systemId);
        if (local != null) {
            InputStream istrm = this.getClass().getResourceAsStream(local);
            InputSource isrc = new InputSource(istrm);
            isrc.setPublicId(publicId);
            isrc.setSystemId(systemId);
            return isrc;
        }
        if (this.parent != null) {
            return this.parent.resolveEntity(publicId, systemId);
        }
        return null;
    }

    protected String getLocalResource(String publicId, String systemId) {
        if (publicId == null) {
            publicId = "";
        }
        if (systemId == null) {
            systemId = "";
        }
        if (systemId.endsWith("VOTable.dtd")) {
            return "text/VOTable.dtd";
        }
        if (systemId.equals("http://www.ivoa.net/xml/VOTable/v1.1") || systemId.equals("http://www.ivoa.net/xml/VOTable/v1.1/") || systemId.startsWith("http://www.ivoa.net/xml/VOTable/v1.1") && systemId.endsWith(".xsd")) {
            return "text/VOTable1.1.xsd";
        }
        if (systemId.endsWith("VOTable.xsd")) {
            return "text/VOTable.xsd";
        }
        if (systemId.endsWith("astrores.dtd")) {
            return "text/astrores.dtd";
        }
        String javaHelpId = "-//Sun Microsystems Inc.//DTD JavaHelp ";
        if (publicId.equals(javaHelpId + "HelpSet Version 1.0//EN")) {
            return "text/helpset_1_0.dtd";
        }
        if (publicId.equals(javaHelpId + "TOC Version 1.0//EN")) {
            return "text/toc_1_0.dtd";
        }
        if (publicId.equals(javaHelpId + "Map Version 1.0//EN")) {
            return "text/map_1_0.dtd";
        }
        return null;
    }
}

