/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BasicFontChooser
extends JDialog {
    protected boolean accepted = false;
    protected JPanel contentPane;
    protected JLabel fontLabel = new JLabel();
    protected JLabel sizeLabel = new JLabel();
    protected JLabel styleLabel = new JLabel();
    protected JComboBox styleBox = new JComboBox();
    protected JComboBox sizeBox = new JComboBox();
    protected JComboBox fontBox = new JComboBox();
    protected JTextField fontDisplay = new JTextField();
    protected JButton okButton = new JButton();
    protected JButton cancelButton = new JButton();
    protected String currentFont = "Lucida Sans";
    protected int currentSize = 12;
    protected int currentStyle = 0;

    public BasicFontChooser() {
        this("Font selection dialog");
    }

    public BasicFontChooser(String title) {
        this((Frame)null, title, false);
    }

    public BasicFontChooser(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.startup();
    }

    protected void startup() {
        this.enableEvents(64L);
        try {
            this.initUI();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.accepted = false;
        this.fontBox.setSelectedItem(this.currentFont);
        this.sizeBox.setSelectedItem(new Integer(this.currentSize));
        this.styleBox.setSelectedItem("PLAIN");
    }

    private void initUI() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new GridBagLayout());
        this.setSize(new Dimension(500, 150));
        this.fontLabel.setHorizontalAlignment(0);
        this.fontLabel.setText("Font");
        this.sizeLabel.setHorizontalAlignment(0);
        this.sizeLabel.setText("Size");
        this.styleLabel.setHorizontalAlignment(0);
        this.styleLabel.setText("Style");
        this.fontDisplay.setToolTipText("Selected font");
        this.fontDisplay.setHorizontalAlignment(0);
        this.fontDisplay.setText("the quick brown fox");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 0, 0, 2);
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.contentPane.add((Component)this.fontLabel, gbc);
        gbc.gridx = 1;
        this.contentPane.add((Component)this.sizeLabel, gbc);
        gbc.gridx = 2;
        this.contentPane.add((Component)this.styleLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.contentPane.add((Component)this.fontBox, gbc);
        gbc.gridx = 1;
        this.contentPane.add((Component)this.sizeBox, gbc);
        gbc.gridx = 2;
        this.contentPane.add((Component)this.styleBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.contentPane.add((Component)this.fontDisplay, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        this.contentPane.add((Component)this.okButton, gbc);
        gbc.gridx = 2;
        gbc.gridy = 3;
        this.contentPane.add((Component)this.cancelButton, gbc);
        this.addFonts();
        this.styleBox.addItem("PLAIN");
        this.styleBox.addItem("BOLD");
        this.styleBox.addItem("ITALIC");
        this.styleBox.addItem("BOLD & ITALIC");
        for (int i = 8; i <= 32; ++i) {
            this.sizeBox.addItem(new Integer(i));
        }
        this.fontBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                BasicFontChooser.this.setFontName();
            }
        });
        this.sizeBox.setEditable(true);
        this.sizeBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                BasicFontChooser.this.setSize();
            }
        });
        this.styleBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                BasicFontChooser.this.setStyle();
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicFontChooser.this.closeWindow(true);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicFontChooser.this.closeWindow(false);
            }
        });
    }

    protected void addFonts() {
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] envfonts = gEnv.getAvailableFontFamilyNames();
        for (int i = 1; i < envfonts.length; ++i) {
            this.fontBox.addItem(envfonts[i]);
        }
    }

    protected void updateDisplay() {
        Font newFont = new Font(this.currentFont, this.currentStyle, this.currentSize);
        this.fontDisplay.setFont(newFont);
    }

    protected void setFontName() {
        Object fontObj = this.fontBox.getSelectedItem();
        this.currentFont = fontObj.toString();
        this.updateDisplay();
    }

    protected void setSize() {
        Object sizeObj = this.sizeBox.getSelectedItem();
        this.currentSize = sizeObj instanceof Integer ? ((Integer)sizeObj).intValue() : new Integer(sizeObj.toString()).intValue();
        this.updateDisplay();
    }

    protected void setStyle() {
        String newStyle = this.styleBox.getSelectedItem().toString();
        this.currentStyle = newStyle.equals("PLAIN") ? 0 : (newStyle.equals("BOLD") ? 1 : (newStyle.equals("ITALIC") ? 2 : 3));
        this.updateDisplay();
    }

    public Font getSelectedFont() {
        return new Font(this.currentFont, this.currentStyle, this.currentSize);
    }

    public boolean accepted() {
        return this.accepted;
    }

    protected void closeWindow(boolean accepted) {
        this.accepted = accepted;
        this.hide();
    }
}

