/*
 * Decompiled with CFR 0.152.
 */
package alma.maci.cdbtypes;

import alma.maci.cdbtypes.ArrayItem;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class Array
implements Serializable {
    private List<ArrayItem> _items = new ArrayList<ArrayItem>();

    public void addArrayItem(ArrayItem vArrayItem) throws IndexOutOfBoundsException {
        this._items.add(vArrayItem);
    }

    public void addArrayItem(int index, ArrayItem vArrayItem) throws IndexOutOfBoundsException {
        this._items.add(index, vArrayItem);
    }

    public Enumeration<? extends ArrayItem> enumerateArrayItem() {
        return Collections.enumeration(this._items);
    }

    public ArrayItem getArrayItem(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._items.size()) {
            throw new IndexOutOfBoundsException("getArrayItem: Index value '" + index + "' not in range [0.." + (this._items.size() - 1) + "]");
        }
        return this._items.get(index);
    }

    public ArrayItem[] getArrayItem() {
        ArrayItem[] array = new ArrayItem[]{};
        return this._items.toArray(array);
    }

    public int getArrayItemCount() {
        return this._items.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends ArrayItem> iterateArrayItem() {
        return this._items.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllArrayItem() {
        this._items.clear();
    }

    public boolean removeArrayItem(ArrayItem vArrayItem) {
        boolean removed = this._items.remove(vArrayItem);
        return removed;
    }

    public ArrayItem removeArrayItemAt(int index) {
        ArrayItem obj = this._items.remove(index);
        return obj;
    }

    public void setArrayItem(int index, ArrayItem vArrayItem) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._items.size()) {
            throw new IndexOutOfBoundsException("setArrayItem: Index value '" + index + "' not in range [0.." + (this._items.size() - 1) + "]");
        }
        this._items.set(index, vArrayItem);
    }

    public void setArrayItem(ArrayItem[] vArrayItemArray) {
        this._items.clear();
        for (int i = 0; i < vArrayItemArray.length; ++i) {
            this._items.add(vArrayItemArray[i]);
        }
    }

    public static Array unmarshalArray(Reader reader) throws MarshalException, ValidationException {
        return (Array)Unmarshaller.unmarshal(Array.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

