/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.jacorb.orb.ORB;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestListener;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.OutputStream;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.slf4j.Logger;

public class NoBiDirClientRequestListener
implements RequestListener {
    private final Logger logger;
    private final ORB orb;

    public NoBiDirClientRequestListener(ORB orb, Logger logger) {
        this.orb = orb;
        this.logger = logger;
    }

    @Override
    public void requestReceived(byte[] request, GIOPConnection connection) {
        this.logger.warn("Received a request on a non-bidir connection");
        connection.incPendingMessages();
        this.replyException(request, connection);
    }

    @Override
    public void locateRequestReceived(byte[] request, GIOPConnection connection) {
        this.logger.warn("Received a locate request on a non-bidir connection");
        connection.incPendingMessages();
        this.replyException(request, connection);
    }

    @Override
    public void cancelRequestReceived(byte[] request, GIOPConnection connection) {
        this.logger.warn("Received a cancel request on a non-bidir connection");
        connection.incPendingMessages();
        this.replyException(request, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replyException(byte[] request, GIOPConnection connection) {
        int giop_minor = Messages.getGIOPMinor(request);
        try (ReplyOutputStream out = new ReplyOutputStream((org.omg.CORBA.ORB)this.orb, Messages.getRequestId(request), ReplyStatusType_1_2.SYSTEM_EXCEPTION, giop_minor, false, this.logger);){
            SystemExceptionHelper.write((OutputStream)out, (SystemException)new INV_POLICY(0, CompletionStatus.COMPLETED_NO));
            connection.sendReply(out);
        }
    }
}

