/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.etf.StreamConnectionBase;
import org.jacorb.util.SelectorManager;
import org.jacorb.util.SelectorRequest;
import org.jacorb.util.SelectorRequestCallback;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.ETF.BufferHolder;

public abstract class NIOConnection
extends StreamConnectionBase {
    private int timeout;
    protected SocketChannel channel = null;
    protected SelectorManager selectorManager = null;
    private int maxConsecutiveTimeouts = 0;
    protected int failedWriteAttempts = 0;
    protected boolean isDebugEnabled = false;

    @Override
    public void configure(Configuration config) throws ConfigurationException {
        super.configure(config);
        this.isDebugEnabled = this.logger.isDebugEnabled();
        this.selectorManager = this.orb.getSelectorManager();
        this.maxConsecutiveTimeouts = this.configuration.getAttributeAsInteger("jacorb.nio.maxConsecutiveTimeouts", 0);
        try {
            this.channel = SocketChannel.open();
        }
        catch (Exception ex) {
            this.logger.error("Unable to initialize channel: " + ex.toString());
        }
    }

    @Override
    public boolean isSSL() {
        return false;
    }

    @Override
    public synchronized boolean is_connected() {
        if (this.isDebugEnabled) {
            this.logger.debug(this.toString() + ".is_connected()");
        }
        return this.connected && this.channel.isConnected();
    }

    protected synchronized void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Override
    protected COMM_FAILURE handleCommFailure(IOException e) {
        return this.to_COMM_FAILURE(e);
    }

    @Override
    protected void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    protected int getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(BufferHolder data, int offset, int min_length, int max_length, long time_out) {
        SocketChannel myChannel;
        NIOConnection nIOConnection = this;
        synchronized (nIOConnection) {
            myChannel = this.channel;
        }
        if (!myChannel.isConnected()) {
            throw new COMM_FAILURE("read() did not return any data");
        }
        ReadCallback callback = new ReadCallback(data, offset, min_length, max_length);
        long nanoDeadline = time_out == 0L ? Long.MAX_VALUE : System.nanoTime() + time_out * 1000000L;
        SelectorRequest request = new SelectorRequest(SelectorRequest.Type.READ, myChannel, callback, nanoDeadline);
        if (!this.selectorManager.add(request)) {
            if (request.status == SelectorRequest.Status.EXPIRED) {
                throw new TIMEOUT("Message expired before write attempt.");
            }
            throw this.handleCommFailure(new IOException("Unable to add read request to SelectorManager"));
        }
        request.waitOnCompletion(nanoDeadline);
        if (request.status == SelectorRequest.Status.EXPIRED || !request.isFinalized()) {
            throw new TIMEOUT("Message expired before write attempt.");
        }
        if (request.status == SelectorRequest.Status.FAILED) {
            throw new COMM_FAILURE("Read request failed. Request status: FAILED");
        }
        if (request.status == SelectorRequest.Status.SHUTDOWN) {
            throw new TRANSIENT("Read request failed. Request status: SHUTDOWN");
        }
        return callback.readLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(boolean is_first, boolean is_last, byte[] data, int offset, int length, long time_out) {
        SocketChannel myChannel;
        NIOConnection nIOConnection = this;
        synchronized (nIOConnection) {
            myChannel = this.channel;
        }
        if (!myChannel.isConnected()) {
            throw this.handleCommFailure(new IOException("Channel has been closed"));
        }
        WriteCallback writeCallback = new WriteCallback(data, offset, length);
        long nanoDeadline = time_out == 0L ? Long.MAX_VALUE : System.nanoTime() + time_out * 1000000L;
        SelectorRequest request = new SelectorRequest(SelectorRequest.Type.WRITE, myChannel, writeCallback, nanoDeadline);
        if (!this.selectorManager.add(request)) {
            if (request.status == SelectorRequest.Status.EXPIRED) {
                throw new TIMEOUT("Message expired before write attempt.");
            }
            throw this.handleCommFailure(new IOException("Unable to add write request to SelectorManager"));
        }
        request.waitOnCompletion(nanoDeadline);
        if (!writeCallback.writeFinished()) {
            int failCount = 0;
            NIOConnection nIOConnection2 = this;
            synchronized (nIOConnection2) {
                failCount = ++this.failedWriteAttempts;
            }
            if (failCount >= this.maxConsecutiveTimeouts) {
                boolean isConnected = myChannel.isConnected();
                try {
                    myChannel.close();
                }
                catch (IOException ex) {
                    this.logger.debug("Exception while trying to close channel after write failure. " + ex.getMessage());
                }
                if (this.isDebugEnabled) {
                    this.logger.debug("Write attempts exceeded maximum allowed attempts (" + this.maxConsecutiveTimeouts + "). " + (isConnected ? "Closing channel." : "Channel already closed."));
                }
                return;
            }
            throw new TIMEOUT("Message expired before write attempt.");
        }
        NIOConnection nIOConnection3 = this;
        synchronized (nIOConnection3) {
            this.failedWriteAttempts = 0;
        }
    }

    @Override
    public void flush() {
    }

    private class ReadCallback
    extends SelectorRequestCallback {
        private final ByteBuffer byteBuffer;
        private final BufferHolder data;
        private final int offset;
        private final int min_length;
        public int readLength = 0;

        public ReadCallback(BufferHolder data, int offset, int min_length, int max_length) {
            this.byteBuffer = ByteBuffer.allocate(max_length);
            this.byteBuffer.clear();
            this.data = data;
            this.offset = offset;
            this.min_length = min_length;
        }

        @Override
        public boolean call(SelectorRequest request) {
            block9: {
                SocketChannel myChannel = request.channel;
                try {
                    if (request.status == SelectorRequest.Status.READY) {
                        int numRead = myChannel.read(this.byteBuffer);
                        if (numRead < 0) {
                            myChannel.close();
                            if (NIOConnection.this.isDebugEnabled) {
                                NIOConnection.this.logger.debug("Transport to " + NIOConnection.this.connection_info + ": stream closed on read  < 0");
                            }
                        } else {
                            if (this.byteBuffer.position() < this.min_length) {
                                return true;
                            }
                            this.readLength = this.byteBuffer.position();
                            this.byteBuffer.rewind();
                            this.byteBuffer.get(this.data.value, this.offset, this.readLength);
                        }
                    }
                }
                catch (IOException ex) {
                    try {
                        myChannel.close();
                    }
                    catch (IOException ex2) {
                        NIOConnection.this.logger.error("Failed to close channel: " + ex2.toString());
                    }
                    if (!NIOConnection.this.isDebugEnabled) break block9;
                    NIOConnection.this.logger.debug("Got IOException in read(). Transport to " + NIOConnection.this.connection_info + ": stream closed: " + ex.toString());
                }
            }
            return false;
        }
    }

    private class WriteCallback
    extends SelectorRequestCallback {
        final ByteBuffer byteBuffer;
        final int length;
        private int writeCount = 0;

        public synchronized boolean writeFinished() {
            return this.writeCount == this.length;
        }

        public WriteCallback(byte[] data, int offset, int length) {
            this.length = length;
            this.byteBuffer = ByteBuffer.allocate(length);
            this.byteBuffer.clear();
            this.byteBuffer.put(data, offset, length);
            this.byteBuffer.flip();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean call(SelectorRequest request) {
            block9: {
                SocketChannel myChannel = request.channel;
                try {
                    if (request.status != SelectorRequest.Status.READY) break block9;
                    int bytesWritten = myChannel.write(this.byteBuffer);
                    WriteCallback writeCallback = this;
                    synchronized (writeCallback) {
                        this.writeCount += bytesWritten;
                    }
                    if (NIOConnection.this.isDebugEnabled) {
                        NIOConnection.this.logger.debug("wrote {} bytes to {}", (Object)bytesWritten, (Object)NIOConnection.this.connection_info);
                    }
                    if (this.byteBuffer.hasRemaining()) {
                        return true;
                    }
                }
                catch (IOException ex) {
                    try {
                        myChannel.close();
                    }
                    catch (IOException ex2) {
                        NIOConnection.this.logger.error("Failed to close channel: " + ex2.toString());
                    }
                    if (!NIOConnection.this.isDebugEnabled) break block9;
                    NIOConnection.this.logger.debug("Got IOException in write(). Transport to " + NIOConnection.this.connection_info + ": stream closed: " + ex.toString());
                }
            }
            return false;
        }
    }
}

