/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.archive.zoom;

import alma.acs.gui.util.threadsupport.EDTExecutor;
import alma.acs.gui.widgets.DateTimeSelector;
import alma.acs.logging.archive.zoom.ZoomManager;
import alma.acs.logging.archive.zoom.ZoomProgressListener;
import alma.acs.util.IsoDateFormat;
import com.cosylab.logging.LoggingClient;
import com.cosylab.logging.engine.ACS.ACSRemoteLogListener;
import com.cosylab.logging.engine.log.ILogEntry;
import com.cosylab.logging.engine.log.LogTypeHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;

public class ManualZoomDlg
extends JDialog
implements ActionListener,
ZoomProgressListener,
ACSRemoteLogListener,
Runnable {
    private final LoggingClient loggingClient;
    private final ZoomManager zoomer;
    private final DateTimeSelector fromDTC = new DateTimeSelector();
    private final DateTimeSelector toDTC = new DateTimeSelector();
    private final JButton loadBtn = new JButton("Load");
    private final JButton stopBtn = new JButton("Stop");
    private final JLabel statusLbl = new JLabel("Ready");
    public Thread thread = null;
    private int numOfFiles = 0;
    private int logsRead = 0;
    private final Timer timer = new Timer(5000, this);
    private final JButton doneBtn = new JButton("Done");

    public ManualZoomDlg(LoggingClient owner, ZoomManager manager) {
        if (owner == null) {
            throw new IllegalArgumentException("The LoggingClient can't be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("The ZoomManager can't be null");
        }
        this.loggingClient = owner;
        this.zoomer = manager;
        this.timer.setRepeats(false);
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                ManualZoomDlg.this.initialize();
                ManualZoomDlg.this.pack();
                ManualZoomDlg.this.setLocationRelativeTo(ManualZoomDlg.this.loggingClient);
                ManualZoomDlg.this.setVisible(true);
            }
        });
    }

    private void initialize() {
        this.setTitle("Zoom");
        ImageIcon zoomIcon = new ImageIcon(LogTypeHelper.class.getResource("/zoom.png"));
        this.setIconImage(zoomIcon.getImage());
        this.setModal(false);
        this.setDefaultCloseOperation(1);
        JPanel contentPane = new JPanel(new BorderLayout());
        JPanel datesPnl = new JPanel();
        datesPnl.setLayout(new BoxLayout(datesPnl, 1));
        JPanel fromPnl = new JPanel();
        fromPnl.setBorder(BorderFactory.createTitledBorder("From"));
        fromPnl.add((Component)this.fromDTC);
        datesPnl.add(fromPnl);
        JPanel toPnl = new JPanel();
        toPnl.setBorder(BorderFactory.createTitledBorder("To"));
        toPnl.add((Component)this.toDTC);
        datesPnl.add(toPnl);
        contentPane.add((Component)datesPnl, "North");
        JPanel buttonPnl = new JPanel(new BorderLayout());
        JPanel donePnl = new JPanel();
        donePnl.add(this.doneBtn);
        buttonPnl.add((Component)donePnl, "West");
        this.doneBtn.addActionListener(this);
        JPanel actionPnl = new JPanel();
        actionPnl.add(this.loadBtn);
        this.loadBtn.setEnabled(true);
        this.loadBtn.addActionListener(this);
        actionPnl.add(this.stopBtn);
        buttonPnl.add((Component)actionPnl, "East");
        this.stopBtn.setEnabled(false);
        this.stopBtn.addActionListener(this);
        contentPane.add((Component)buttonPnl, "Center");
        JPanel statusPnl = new JPanel(new FlowLayout(0));
        statusPnl.setBorder(BorderFactory.createLoweredBevelBorder());
        statusPnl.add(this.statusLbl);
        contentPane.add((Component)statusPnl, "South");
        this.rootPane.setContentPane(contentPane);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.isShowing()) {
            Point loggingPos = this.loggingClient.getLocationOnScreen();
            this.setLocation(loggingPos);
            this.toFront();
        }
    }

    public void close() {
        this.setVisible(false);
        this.timer.stop();
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.doneBtn) {
            this.setVisible(false);
        } else if (e.getSource() == this.loadBtn) {
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = new Thread(this);
                this.thread.setDaemon(true);
                this.thread.setName(this.getClass().getName());
                this.thread.start();
            }
        } else if (e.getSource() == this.stopBtn) {
            this.zoomer.stopZoom();
        } else if (e.getSource() == this.timer) {
            this.statusLbl.setText("Ready");
        } else {
            System.out.println("Unknown source of events: " + e.getSource());
        }
    }

    @Override
    public void run() {
        this.loadBtn.setEnabled(false);
        this.stopBtn.setEnabled(true);
        if (!this.zoomer.isAvailable()) {
            JOptionPane.showMessageDialog(this, "Zoom feature is not available.\nFix by opening the zoom preference dialog.", "Zoom error", 0);
            this.loadBtn.setEnabled(true);
            this.stopBtn.setEnabled(false);
            return;
        }
        if (this.zoomer.isLoadingLogs()) {
            JOptionPane.showMessageDialog(this, "Zoom is already loading logs", "Zoom error", 0);
            this.loadBtn.setEnabled(true);
            this.stopBtn.setEnabled(false);
            return;
        }
        this.numOfFiles = 0;
        this.logsRead = 0;
        Date from = this.fromDTC.getDate().getTime();
        Date to = this.toDTC.getDate().getTime();
        String fromStr = IsoDateFormat.formatDate((Date)from);
        String toStr = IsoDateFormat.formatDate((Date)to);
        try {
            this.zoomer.zoom(fromStr, toStr, this, this, this.loggingClient);
            this.statusLbl.setText("Done (" + this.logsRead + " logs read)");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error while loading logs.\n" + e.getMessage(), "Zoom error loading", 0);
        }
        this.timer.start();
        this.loadBtn.setEnabled(true);
        this.stopBtn.setEnabled(false);
    }

    @Override
    public void zoomReadingFile(int num) {
        this.statusLbl.setText("Reading file " + num + " of " + this.numOfFiles + " (" + this.logsRead + " logs)");
    }

    @Override
    public void zoomTotalFileToRead(int num) {
        this.numOfFiles = num;
        this.statusLbl.setText(num + " files to read");
    }

    public void logEntryReceived(ILogEntry logEntry) {
        ++this.logsRead;
        this.loggingClient.logEntryReceived(logEntry);
    }
}

