/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.dialogs;

import alma.acs.logging.io.LoadSwitchesPanel;
import com.cosylab.logging.LoggingClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;

public class LoadURLDlg
extends JDialog
implements ActionListener {
    private JTextField urlTF = new JTextField(40);
    private LoadSwitchesPanel guiSwitches;
    private JButton loadBtn = new JButton("Load URL");
    private JButton cancelBtn = new JButton("Cancel");
    private URL url = null;
    private LoggingClient loggingClient = null;

    public LoadURLDlg(String initialValue, LoggingClient client) {
        super(client.getLogFrame());
        this.loggingClient = client;
        this.setTitle("Load from URL");
        this.setModal(true);
        this.initGUI();
        this.urlTF.setText(initialValue);
        this.pack();
    }

    private void initGUI() {
        JRootPane mainPnl = this.getRootPane();
        mainPnl.setLayout(new BorderLayout());
        this.guiSwitches = new LoadSwitchesPanel(this.loggingClient);
        mainPnl.add((Component)this.guiSwitches, "North");
        JPanel urlPnl = new JPanel(new FlowLayout());
        urlPnl.add(new JLabel("URL of the file: "));
        urlPnl.add(this.urlTF);
        mainPnl.add((Component)urlPnl, "Center");
        JPanel btnPnl = new JPanel(new BorderLayout());
        this.loadBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        btnPnl.add((Component)this.loadBtn, "West");
        btnPnl.add((Component)this.cancelBtn, "East");
        mainPnl.add((Component)btnPnl, "South");
    }

    public URL getURL() {
        return this.url;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.loadBtn) {
            try {
                this.url = new URL(this.urlTF.getText());
            }
            catch (MalformedURLException me) {
                JOptionPane.showMessageDialog(this, me.getMessage(), "Malformed URL", 0);
                return;
            }
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.cancelBtn) {
            this.setVisible(false);
            this.dispose();
        } else {
            System.err.println("Unknown source: " + e.getSource());
        }
    }
}

