/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.dialogs.error;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;

public class ErrorLogFile
extends TimerTask {
    private Timer timer = new Timer("ErrorLogFile", true);
    private final int timeout;
    private long lastWriteTime = -1L;
    private final boolean deleteOnExit;
    private final boolean retryOnError;
    private final String prefix;
    private final String suffix;
    private final String folder;
    private String fileName;
    private FileOutputStream outFile = null;
    private boolean fileError = false;
    private boolean closed = false;

    public ErrorLogFile(int timeout, String prefix, String suffix, String folder, boolean deleteOnExit, boolean retryOnError) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("The timeout msut be greater then 0");
        }
        if (prefix == null || prefix.length() == 0) {
            throw new IllegalArgumentException("Invalid prefix");
        }
        if (suffix == null || suffix.length() == 0) {
            throw new IllegalArgumentException("Invalid suffix");
        }
        this.folder = folder == null || folder.length() == 0 ? "." : folder;
        this.timeout = timeout;
        this.deleteOnExit = deleteOnExit;
        this.retryOnError = retryOnError;
        this.prefix = prefix;
        this.suffix = suffix;
        this.timer.schedule((TimerTask)this, 1000 * timeout, (long)(1000 * timeout));
    }

    @Override
    public synchronized void run() {
        if (this.lastWriteTime < 0L || this.outFile == null) {
            return;
        }
        if (this.lastWriteTime + (long)(this.timeout * 1000) < System.currentTimeMillis()) {
            try {
                this.outFile.flush();
                this.outFile.close();
            }
            catch (IOException e) {
                this.fileError = true;
            }
            this.outFile = null;
        }
    }

    private void initTmpFile() throws IOException {
        File tmpFile = File.createTempFile(this.prefix, this.suffix, new File(this.folder));
        if (this.deleteOnExit) {
            tmpFile.deleteOnExit();
        }
        this.fileName = tmpFile.getAbsolutePath();
    }

    public synchronized void append(String str) throws IOException {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("The string to write can't be null nor empty");
        }
        if (this.closed) {
            return;
        }
        if (this.fileError && !this.retryOnError) {
            return;
        }
        if (this.fileName == null) {
            this.initTmpFile();
        }
        if (this.outFile == null) {
            this.outFile = new FileOutputStream(this.fileName, true);
        }
        this.outFile.write(str.getBytes());
        this.lastWriteTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copy(OutputStream file) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("The file can't be null");
        }
        if (this.lastWriteTime < 0L) {
            return;
        }
        try (FileInputStream inF = new FileInputStream(this.fileName);){
            int bytesRead;
            byte[] buffer = new byte[512];
            do {
                if ((bytesRead = inF.read(buffer)) <= 0) continue;
                file.write(buffer, 0, bytesRead);
            } while (bytesRead >= 0);
        }
    }

    public synchronized void clear() {
        if (this.outFile != null) {
            try {
                this.outFile.close();
            }
            catch (Throwable t) {
                System.err.println("Ignored error while clearing the temporary file " + this.fileName + ": " + t.getMessage());
                t.printStackTrace();
            }
            this.outFile = null;
        }
        this.lastWriteTime = -1L;
        this.fileName = null;
        this.fileError = false;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void close() {
        this.closed = true;
        this.timer.cancel();
        this.clear();
    }

    public synchronized String getFileName() {
        return this.fileName;
    }
}

