/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.errorbrowser;

import alma.acs.logging.errorbrowser.ErrorTab;
import alma.acs.logging.errorbrowser.TabComponent;
import alma.acs.logging.table.LogEntryTableModelBase;
import com.cosylab.logging.LoggingClient;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class ErrorBrowserDlg
extends JDialog
implements ContainerListener {
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final JPanel notTracesPnl = new JPanel(new BorderLayout());
    private final LoggingClient loggingClient;
    private final CardLayout cardLayout = new CardLayout();
    private final JPanel cardsPanel = new JPanel(this.cardLayout);
    private static final String NO_ERROR_TRACES = "Empty";
    private static final String ERROR_TRACES = "ErrorTraces";

    public ErrorBrowserDlg(LoggingClient client) {
        super((Frame)null, "Error browser");
        if (client == null) {
            throw new IllegalArgumentException("The LoggingClient can't be null");
        }
        this.loggingClient = client;
        this.setDefaultCloseOperation(1);
        this.initialize();
    }

    private void initialize() {
        this.cardsPanel.add((Component)this.tabbedPane, ERROR_TRACES);
        JLabel notTracesLbl = new JLabel("<HTML>No error traces.<BR>Add an error trace from the table of logs.</HTML>");
        this.notTracesPnl.add((Component)notTracesLbl, "North");
        this.cardsPanel.add((Component)this.notTracesPnl, NO_ERROR_TRACES);
        this.add(this.cardsPanel);
        this.ratioContent();
        this.tabbedPane.addContainerListener(this);
        this.setMinimumSize(new Dimension(400, 200));
        this.setPreferredSize(new Dimension(500, 300));
        this.pack();
        this.setVisible(true);
    }

    public synchronized void addErrorTab(final LogEntryTableModelBase sourceModel, final String stackId) {
        if (stackId == null || stackId.isEmpty()) {
            throw new IllegalArgumentException("The stackID can't be null nor empty");
        }
        if (sourceModel == null) {
            throw new IllegalArgumentException("The model can't be null");
        }
        this.removeDuplicatedTabs(stackId);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ErrorTab newTab;
                    try {
                        newTab = new ErrorTab(sourceModel, stackId, ErrorBrowserDlg.this.loggingClient);
                    }
                    catch (Exception e) {
                        System.err.println("Error creating an error tab: " + e.getMessage());
                        e.printStackTrace();
                        return;
                    }
                    ErrorBrowserDlg.this.tabbedPane.insertTab(stackId, null, newTab, "Stack trace for ID " + stackId, 0);
                    ErrorBrowserDlg.this.tabbedPane.setTabComponentAt(0, new TabComponent(ErrorBrowserDlg.this.tabbedPane));
                    ErrorBrowserDlg.this.setVisible(true);
                }
            });
        }
        catch (Exception e) {
            System.err.println("Error adding tab: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public void close() {
        for (int t = 0; t < this.tabbedPane.getTabCount(); ++t) {
            ErrorTab tab = (ErrorTab)this.tabbedPane.getComponentAt(t);
            if (tab == null) continue;
            tab.close();
        }
        this.setVisible(false);
        this.dispose();
    }

    private void removeDuplicatedTabs(final String tabTitle) {
        while (true) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        for (int t = 0; t < ErrorBrowserDlg.this.tabbedPane.getTabCount(); ++t) {
                            if (!ErrorBrowserDlg.this.tabbedPane.getTitleAt(t).equals(tabTitle)) continue;
                            ErrorBrowserDlg.this.tabbedPane.removeTabAt(t);
                            break;
                        }
                    }
                });
                return;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        boolean wasVisibel = this.isVisible();
        super.setVisible(visible);
        if (visible && this.isShowing()) {
            Point loggingPos = this.loggingClient.getLocationOnScreen();
            if (!wasVisibel) {
                this.setLocation(loggingPos);
            }
            this.toFront();
        }
    }

    private void ratioContent() {
        if (this.tabbedPane.getTabCount() > 0) {
            this.cardLayout.show(this.cardsPanel, ERROR_TRACES);
        } else {
            this.cardLayout.show(this.cardsPanel, NO_ERROR_TRACES);
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.ratioContent();
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this.ratioContent();
    }
}

