/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.io;

import alma.acs.logging.io.LogsFileChooser;
import com.cosylab.logging.LoggingClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class SaveFileChooser
extends LogsFileChooser
implements ActionListener {
    private JCheckBox compressCB = new JCheckBox("Compress", false);
    private JSlider compressionLevelS = new JSlider(0, 0, 9, 5);
    private Dictionary<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();

    public SaveFileChooser(String title, File currentDir, LoggingClient client) {
        super(title, currentDir, false, client.getLogFrame());
        this.initialize(currentDir);
        this.setTitle(title);
        this.setModal(true);
        this.pack();
        this.setVisible(true);
    }

    private void initialize(File folder) {
        this.rootPane.setLayout(new BorderLayout());
        JPanel compressPnl = new JPanel(new FlowLayout(0));
        compressPnl.setBorder(BorderFactory.createTitledBorder("Compression"));
        compressPnl.add(this.compressCB);
        this.compressCB.addActionListener(this);
        compressPnl.add(this.compressionLevelS);
        this.compressionLevelS.setMajorTickSpacing(10);
        this.compressionLevelS.setMinorTickSpacing(1);
        this.compressionLevelS.setPaintTicks(true);
        this.compressionLevelS.setPaintLabels(true);
        this.compressionLevelS.setEnabled(this.compressCB.isSelected());
        for (int t = 0; t <= 9; ++t) {
            this.labels.put(t, new JLabel("" + t));
        }
        this.compressionLevelS.setLabelTable(this.labels);
        this.compressionLevelS.setSnapToTicks(true);
        this.rootPane.add((Component)compressPnl, "North");
        this.rootPane.add((Component)this.fileChooser, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.compressCB) {
            this.compressionLevelS.setEnabled(this.compressCB.isSelected());
        } else {
            super.actionPerformed(e);
        }
    }

    public boolean mustBeCompressed() {
        return this.compressCB.isSelected();
    }

    public int getCompressionLevel() {
        return this.compressionLevelS.getValue();
    }
}

