/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.preferences;

public class UserPreferences
implements Cloneable {
    private int timeFrame = 0;
    private int maxNumOfLogs = 0;
    private int maxInputRate = Integer.MAX_VALUE;
    private int maxOutputRate = Integer.MAX_VALUE;
    private int dynThreshold = Integer.MAX_VALUE;
    private int dynDamping = 0;
    private int dynTime = 1;

    public UserPreferences(int time, int maxLogs, int inRate, int outRate) {
        this.setTimeFrame(time);
        this.setMaxLogs(maxLogs);
        this.setMaxInputRate(inRate);
        this.setMaxOutputRate(outRate);
    }

    public void setTimeFrame(int time) {
        this.timeFrame = time;
    }

    public void setMaxLogs(int maxLogs) throws IllegalArgumentException {
        this.maxNumOfLogs = maxLogs;
    }

    public int getMaxNumOfLogs() {
        return this.maxNumOfLogs;
    }

    public int getMinuteTimeFrame() {
        return this.timeFrame;
    }

    public long getMillisecondsTimeFrame() {
        return this.timeFrame * 60 * 1000;
    }

    public int getMaxInputRate() {
        return this.maxInputRate;
    }

    public void setMaxInputRate(int maxInputRate) {
        this.maxInputRate = maxInputRate;
    }

    public int getMaxOutputRate() {
        return this.maxOutputRate;
    }

    public void setMaxOutputRate(int maxOutputRate) {
        this.maxOutputRate = maxOutputRate;
    }

    public UserPreferences clone() throws CloneNotSupportedException {
        return (UserPreferences)super.clone();
    }

    public int getDynThreshold() {
        return this.dynThreshold;
    }

    public void setDynThreshold(int dynThreshold) {
        this.dynThreshold = dynThreshold;
    }

    public int getDynDamping() {
        return this.dynDamping;
    }

    public void setDynDamping(int dynDamping) {
        this.dynDamping = dynDamping;
    }

    public int getDynTime() {
        return this.dynTime;
    }

    public void setDynTime(int dynTime) {
        this.dynTime = dynTime;
    }

    public int getTimeFrame() {
        return this.timeFrame;
    }

    public void setMaxNumOfLogs(int maxNumOfLogs) {
        this.maxNumOfLogs = maxNumOfLogs;
    }
}

