/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.table;

import alma.acs.gui.util.threadsupport.EDTExecutor;
import alma.acs.logging.table.LogTableDataModel;
import alma.acs.logging.table.LogTableRowFilter;
import com.cosylab.logging.engine.Filter;
import com.cosylab.logging.engine.Filterable;
import com.cosylab.logging.engine.FiltersVector;
import com.cosylab.logging.engine.log.LogTypeHelper;
import javax.swing.table.TableRowSorter;

public class LogTableRowSorter
extends TableRowSorter<LogTableDataModel>
implements Filterable {
    private final FiltersVector filters = new FiltersVector();
    private LogTypeHelper logLevel = LogTypeHelper.TRACE;
    private int col;
    LogTableDataModel model;

    public LogTableRowSorter(LogTableDataModel model) {
        super(model);
        this.model = model;
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                LogTableRowSorter.this.setMaxSortKeys(2);
                LogTableRowSorter.this.setSortKeys(null);
            }
        });
        this.applyChanges();
    }

    public void setFilters(FiltersVector newFilters, boolean append) {
        if (append) {
            for (int t = 0; t < newFilters.size(); ++t) {
                Filter f = (Filter)newFilters.get(t);
                this.filters.addFilter(f, newFilters.isActive(t));
            }
        } else if (newFilters == null) {
            this.filters.clear();
        } else {
            this.filters.setFilters(newFilters);
        }
        this.applyChanges();
    }

    public String getFiltersString() {
        if (this.filters == null) {
            return "Not filtered";
        }
        return this.filters.getFilterString();
    }

    public FiltersVector getFilters() {
        return this.filters;
    }

    public void setLogLevel(LogTypeHelper newLevel) {
        this.logLevel = newLevel;
        this.applyChanges();
    }

    private void applyChanges() {
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                LogTableRowSorter.this.setRowFilter(new LogTableRowFilter(LogTableRowSorter.this.filters, LogTableRowSorter.this.logLevel));
            }
        });
    }
}

