/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.tools;

import alma.acs.logging.engine.io.IOHelper;
import alma.acs.logging.engine.io.IOPorgressListener;
import alma.acs.logging.tools.LogConverter;
import alma.acs.logging.tools.XMLConverter;
import com.cosylab.logging.engine.ACS.ACSRemoteErrorListener;
import com.cosylab.logging.engine.ACS.ACSRemoteLogListener;
import com.cosylab.logging.engine.FiltersVector;
import com.cosylab.logging.engine.log.ILogEntry;
import com.cosylab.logging.engine.log.LogField;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;

public class LogFileExtractor
implements ACSRemoteLogListener,
ACSRemoteErrorListener,
IOPorgressListener {
    private long start = -1L;
    private long end = -1L;
    private String filterFileName = null;
    private FiltersVector filters = null;
    private final String[] inFileNames;
    private String destFileName;
    private static final int OUTPUT_BUFFER_SIZE = 8192;
    private BufferedWriter outF = null;
    private final LogConverter converter;

    public LogFileExtractor(String[] inputFiles, String outputFile, Date startDate, Date endDate, String filterName, LogConverter converter) throws Exception {
        if (startDate == null && endDate == null && filterName == null) {
            throw new IllegalArgumentException("No criteria for extraction");
        }
        if (outputFile == null) {
            throw new IllegalArgumentException("The source can't be null");
        }
        if (inputFiles == null || inputFiles.length == 0) {
            throw new IllegalArgumentException("No source files");
        }
        if (converter == null) {
            throw new IllegalArgumentException("The converter can't be null");
        }
        this.converter = converter;
        this.inFileNames = new String[inputFiles.length];
        System.arraycopy(inputFiles, 0, this.inFileNames, 0, inputFiles.length);
        this.destFileName = outputFile;
        String extension = converter instanceof XMLConverter ? ".xml" : ".txt";
        if (!this.destFileName.toLowerCase().endsWith(extension)) {
            this.destFileName = this.destFileName + extension;
        }
        if (startDate != null) {
            this.start = startDate.getTime();
        }
        if (endDate != null) {
            this.end = endDate.getTime();
        }
        if (this.end <= this.start && this.end != -1L && this.start != -1L) {
            throw new IllegalArgumentException("Start date greater then end date");
        }
        this.filterFileName = filterName;
        if (this.filterFileName != null) {
            File f = new File(this.filterFileName);
            if (!f.canRead()) {
                throw new IllegalArgumentException(this.filterFileName + " is unreadable");
            }
            this.filters = new FiltersVector();
            this.filters.loadFilters(f, true, null);
            System.out.println("Will apply the following filters:\n" + this.filters.toString());
        }
    }

    private void openDestFile() throws Exception {
        if (this.destFileName.length() == 0) {
            throw new IllegalArgumentException("Wrong dest file name");
        }
        this.outF = new BufferedWriter(new FileWriter(this.destFileName));
    }

    public void extract() throws Exception {
        IOHelper inputHelper = new IOHelper();
        inputHelper.setFilters(this.filters);
        this.openDestFile();
        if (this.inFileNames == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            inputHelper.loadLogs(in, (ACSRemoteLogListener)this, null, (ACSRemoteErrorListener)this, (IOPorgressListener)this);
        } else {
            for (String inFileName : this.inFileNames) {
                System.out.println("Processing " + inFileName);
                inputHelper.loadLogs(inFileName, (ACSRemoteLogListener)this, null, (ACSRemoteErrorListener)this, (IOPorgressListener)this);
            }
        }
        this.outF.flush();
        this.outF.close();
        this.outF = null;
    }

    private boolean checkDate(ILogEntry log) {
        Long date = (Long)log.getField(LogField.TIMESTAMP);
        boolean matches = true;
        boolean bl = matches = date >= this.start;
        if (matches && this.end != -1L) {
            matches = date <= this.end;
        }
        return matches;
    }

    public void bytesRead(long bytes) {
    }

    public void bytesWritten(long bytes) {
    }

    public void logsRead(int numOfLogs) {
    }

    public void logsWritten(int numOfLogs) {
    }

    public void errorReceived(String xml) {
        System.err.println("Error with the following: " + xml);
    }

    public void logEntryReceived(ILogEntry logEntry) {
        boolean matches = true;
        if (this.start != -1L || this.end != -1L) {
            matches = this.checkDate(logEntry);
        }
        if (matches && this.filters != null) {
            matches = this.filters.applyFilters(logEntry);
        }
        if (matches) {
            try {
                this.outF.write(this.converter.convert(logEntry));
            }
            catch (IOException e) {
                System.err.println("Error writing a log: " + e.getMessage());
                e.printStackTrace(System.err);
            }
        }
    }
}

