/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.settings;

import com.cosylab.logging.engine.ExactFilter;
import com.cosylab.logging.engine.Filter;
import com.cosylab.logging.engine.RegExpFilter;
import com.cosylab.logging.settings.FilterParameterException;
import com.cosylab.logging.settings.FilterParameterPanel;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class FilterStringPanel
extends FilterParameterPanel {
    private JTextField exact;
    private JTextField regexp;
    private JCheckBox exactCheck;
    private JCheckBox regexpCheck;
    private JCheckBox notCheck;

    @Override
    protected void createComponents() {
        SelectionChecked sc = new SelectionChecked();
        this.notCheck = new JCheckBox("Discard entries matching this filter");
        this.notCheck.setToolTipText("Keep/discard entries matching this filter");
        this.add((Component)this.notCheck, this.newConstraints(0, 4, 4, 4, 4));
        this.exactCheck = new JCheckBox("Exact value");
        this.exactCheck.addItemListener(sc);
        this.add((Component)this.exactCheck, this.newConstraints(1, 4, 4, 0, 4));
        this.exact = new JTextField();
        this.add((Component)this.exact, this.newConstraints(2, 0, 4, 4, 4));
        this.regexpCheck = new JCheckBox("Regular expression pattern");
        this.regexpCheck.addItemListener(sc);
        this.add((Component)this.regexpCheck, this.newConstraints(3, 4, 4, 0, 4));
        this.regexp = new JTextField();
        this.add((Component)this.regexp, this.newConstraints(4, 0, 4, 4, 4));
    }

    @Override
    public Filter getFilter() throws FilterParameterException {
        if (this.exactCheck.isSelected()) {
            if (this.exact.getText().length() == 0) {
                throw new FilterParameterException("Cannot use empty string");
            }
            try {
                return new ExactFilter(this.getFieldIndex(), this.isLethal(), (Comparable)((Object)this.exact.getText()), this.notCheck.isSelected());
            }
            catch (Exception e) {
                throw new FilterParameterException(e.getMessage());
            }
        }
        if (this.regexpCheck.isSelected()) {
            if (this.regexp.getText().length() == 0) {
                throw new FilterParameterException("Cannot use empty string");
            }
            try {
                return new RegExpFilter(this.getFieldIndex(), this.isLethal(), this.regexp.getText(), this.notCheck.isSelected());
            }
            catch (Exception e) {
                throw new FilterParameterException(e.getMessage());
            }
        }
        throw new FilterParameterException("Select at least one constraint");
    }

    @Override
    public void setFilter(Filter f) {
        if (f == null) {
            return;
        }
        switch (f.getConstraint()) {
            case EXACT: {
                this.exactCheck.setSelected(true);
                this.exact.setText((String)((ExactFilter)f).getExact());
                break;
            }
            case STRING_WILDCHAR: {
                this.regexpCheck.setSelected(true);
                this.regexp.setText(((RegExpFilter)f).getRegularExpression());
            }
        }
        this.notCheck.setSelected(f.notPolicyApplyed());
    }

    private class SelectionChecked
    implements ItemListener {
        private SelectionChecked() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (e.getSource() == FilterStringPanel.this.exactCheck) {
                    FilterStringPanel.this.regexpCheck.setSelected(false);
                } else {
                    FilterStringPanel.this.exactCheck.setSelected(false);
                }
            }
        }
    }
}

