/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.wrappers;

import alma.archive.wrappers.ArchiveTimeStamp;
import alma.archive.wrappers.Permissions;
import java.net.URI;
import org.jdom.Content;
import org.jdom.Element;

public class DocumentData {
    private ArchiveTimeStamp m_timestamp;
    private URI m_schema;
    private String m_owner;
    private Permissions m_permissions;
    private String m_locks;
    private boolean m_deleted;
    private String m_admin;
    private boolean m_hidden;
    private boolean m_dirty;
    private boolean m_virtual;

    public DocumentData(ArchiveTimeStamp timestamp, URI schema, String owner, Permissions permissions, boolean hidden, boolean dirty, boolean deleted, boolean virtual, String admin) {
        this.m_timestamp = timestamp;
        this.m_schema = schema;
        this.m_owner = owner;
        this.m_permissions = permissions;
        this.m_hidden = hidden;
        this.m_dirty = dirty;
        this.m_deleted = deleted;
        this.m_virtual = virtual;
    }

    public String getAdmin() {
        return this.m_admin;
    }

    public boolean getDeleted() {
        return this.m_deleted;
    }

    public boolean getHidden() {
        return this.m_hidden;
    }

    public boolean getDirty() {
        return this.m_dirty;
    }

    public String getOwner() {
        return this.m_owner;
    }

    public Permissions getPermissions() {
        return this.m_permissions;
    }

    public URI getSchema() {
        return this.m_schema;
    }

    public ArchiveTimeStamp getTimestamp() {
        return this.m_timestamp;
    }

    public boolean getVirtual() {
        return this.m_virtual;
    }

    public void setVirtual(boolean virtual) {
        this.m_virtual = virtual;
    }

    public Element getElement() {
        Element dd = new Element("DocumentData");
        dd.setAttribute("timeStamp", this.m_timestamp.toISOString());
        dd.setAttribute("schema", this.m_schema.toASCIIString());
        dd.setAttribute("owner", this.m_owner);
        dd.setAttribute("virtual", Boolean.toString(this.m_virtual));
        dd.addContent((Content)this.m_permissions.getElement());
        Element visibility = new Element("visibility");
        visibility.setAttribute("hidden", Boolean.toString(this.m_hidden));
        visibility.setAttribute("dirty", Boolean.toString(this.m_dirty));
        visibility.setAttribute("deleted", Boolean.toString(this.m_deleted));
        dd.addContent((Content)visibility);
        Element admin = new Element("admin");
        admin.setText(this.m_admin);
        dd.addContent((Content)admin);
        return dd;
    }
}

