/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.binding;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.exolab.castor.builder.binding.XPathHelper;
import org.exolab.castor.builder.binding.xml.AutomaticNamingType;
import org.exolab.castor.builder.binding.xml.Binding;
import org.exolab.castor.builder.binding.xml.ComponentBindingType;
import org.exolab.castor.builder.binding.xml.Exclude;
import org.exolab.castor.builder.binding.xml.Excludes;
import org.exolab.castor.builder.binding.xml.Forces;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ElementDecl;

public final class ExtendedBinding
extends Binding {
    protected static final String PATH_SEPARATOR = "/";
    protected static final String ATTRIBUTE_PREFIX = "@";
    public static final String COMPLEXTYPE_ID = "complexType:";
    public static final String SIMPLETYPE_ID = "simpleType:";
    public static final String ENUMTYPE_ID = "enumType:";
    public static final String GROUP_ID = "group:";
    private static final short ATTRIBUTE = 10;
    private static final short ELEMENT = 11;
    private static final short COMPLEXTYPE = 12;
    private static final short GROUP = 13;
    private static final short ENUM_TYPE = 14;
    private static final short SIMPLETYPE = 15;
    private Hashtable<String, ComponentBindingType> _componentBindings;
    private boolean _bindingProcessed = false;
    private Set<String> _automaticNameResolutionForced = new HashSet<String>();
    private Map<String, Exclude> _automaticNameResolutionExcludes = new HashMap<String, Exclude>();

    public ExtendedBinding() {
        this._componentBindings = new Hashtable();
    }

    public ComponentBindingType getComponentBindingType(Annotated annotated) {
        String xPath;
        ComponentBindingType result;
        if (annotated == null) {
            return null;
        }
        if (annotated.getStructureType() == 10) {
            return null;
        }
        if (!this._bindingProcessed) {
            this.processBindingComponents();
        }
        if ((result = this.lookupComponentBindingType(xPath = XPathHelper.getSchemaLocation(annotated))) == null) {
            switch (annotated.getStructureType()) {
                case 8: {
                    if (result != null) break;
                    ElementDecl element = (ElementDecl)annotated;
                    if (element.isReference()) {
                        xPath = XPathHelper.getSchemaLocation(element.getReference());
                        result = this.lookupComponentBindingType(xPath);
                    }
                    element = null;
                    break;
                }
                case 3: {
                    if (result != null) break;
                    AttributeDecl attribute = (AttributeDecl)annotated;
                    if (attribute.isReference()) {
                        xPath = XPathHelper.getSchemaLocation(attribute.getReference());
                        result = this.lookupComponentBindingType(xPath);
                    }
                    attribute = null;
                    break;
                }
            }
        }
        return result;
    }

    private ComponentBindingType lookupComponentBindingType(String xPath) {
        if (xPath == null) {
            return null;
        }
        ComponentBindingType componentBinding = this._componentBindings.get(xPath);
        if (componentBinding == null) {
            int occurence = xPath.indexOf(123);
            Object xPathNoNamespaces = xPath;
            if (occurence > 0) {
                while (occurence > 0) {
                    String xPathOld = xPathNoNamespaces;
                    xPathNoNamespaces = xPathOld.substring(0, occurence);
                    int closingOccurence = xPathOld.indexOf(125);
                    xPathNoNamespaces = (String)xPathNoNamespaces + xPathOld.substring(closingOccurence + 1);
                    occurence = ((String)xPathNoNamespaces).indexOf(123);
                }
                componentBinding = this.lookupComponentBindingType((String)xPathNoNamespaces);
            }
        }
        return componentBinding;
    }

    private void processBindingComponents() {
        ComponentBindingType temp;
        int i;
        ComponentBindingType[] tempBindings = this.getAttributeBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, null, 10);
        }
        tempBindings = this.getComplexTypeBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, null, 12);
        }
        tempBindings = this.getElementBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, null, 11);
        }
        tempBindings = this.getGroupBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, null, 13);
        }
        tempBindings = this.getEnumBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, null, 14);
        }
        tempBindings = this.getSimpleTypeBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, null, 15);
        }
        temp = null;
        tempBindings = null;
        this._bindingProcessed = true;
    }

    void handleAutomaticNaming(AutomaticNamingType type) {
        Excludes excludesOuter;
        Forces forcesOuter = type.getForces();
        if (forcesOuter != null) {
            String[] forces = forcesOuter.getForce();
            for (int i = 0; i < forces.length; ++i) {
                String elementName = forces[i];
                this._automaticNameResolutionForced.add(elementName);
            }
        }
        if ((excludesOuter = type.getExcludes()) != null) {
            Exclude[] excludes = excludesOuter.getExclude();
            for (int i = 0; i < excludes.length; ++i) {
                Exclude exclude = excludes[i];
                this._automaticNameResolutionExcludes.put(exclude.getName(), exclude);
            }
        }
    }

    private void handleComponent(ComponentBindingType binding, String xPath, int type) {
        ComponentBindingType temp;
        int i;
        String name;
        if (binding == null) {
            return;
        }
        Object currentPath = xPath;
        if (currentPath == null) {
            currentPath = new String();
        }
        boolean xpathUsed = (name = binding.getName()).indexOf(PATH_SEPARATOR) != -1;
        switch (type) {
            case 10: {
                if (!xpathUsed) {
                    currentPath = (String)currentPath + "/@";
                }
                currentPath = (String)currentPath + name;
                this._componentBindings.put((String)currentPath, binding);
                break;
            }
            case 15: {
                if (!xpathUsed) {
                    currentPath = (String)currentPath + SIMPLETYPE_ID;
                }
                currentPath = (String)currentPath + name;
                this._componentBindings.put((String)currentPath, binding);
                break;
            }
            case 11: {
                if (!xpathUsed) {
                    currentPath = (String)currentPath + PATH_SEPARATOR;
                }
                currentPath = (String)currentPath + name;
                this._componentBindings.put((String)currentPath, binding);
                break;
            }
            case 12: {
                if (!xpathUsed) {
                    currentPath = (String)currentPath + COMPLEXTYPE_ID;
                } else if (!name.substring(1, 12).equals("complexType")) {
                    currentPath = (String)currentPath + "/complexType:";
                    currentPath = (String)currentPath + name.substring(1);
                } else {
                    currentPath = (String)currentPath + name;
                }
                this._componentBindings.put((String)currentPath, binding);
                break;
            }
            case 14: {
                if (!xpathUsed) {
                    currentPath = (String)currentPath + ENUMTYPE_ID;
                }
                currentPath = (String)currentPath + name;
                this._componentBindings.put((String)currentPath, binding);
                break;
            }
            case 13: {
                if (!xpathUsed) {
                    currentPath = (String)currentPath + GROUP_ID;
                }
                currentPath = (String)currentPath + name;
                this._componentBindings.put((String)currentPath, binding);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid ComponentBindingType: the type (attribute, element, complextype or group) is unknown");
            }
        }
        ComponentBindingType[] tempBindings = binding.getAttributeBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, (String)currentPath, 10);
        }
        tempBindings = binding.getComplexTypeBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, (String)currentPath, 12);
        }
        tempBindings = binding.getSimpleTypeBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, (String)currentPath, 15);
        }
        tempBindings = binding.getElementBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, (String)currentPath, 11);
        }
        tempBindings = binding.getGroupBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, (String)currentPath, 13);
        }
        tempBindings = binding.getEnumBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, (String)currentPath, 14);
        }
        temp = null;
        tempBindings = null;
    }

    public boolean existsExclusion(String localName) {
        return this._automaticNameResolutionExcludes.containsKey(localName);
    }

    public Exclude getExclusion(String localName) {
        return this._automaticNameResolutionExcludes.get(localName);
    }

    public boolean existsForce(String localName) {
        return this._automaticNameResolutionForced.contains(localName);
    }

    public Set<String> getForces() {
        return this._automaticNameResolutionForced;
    }
}

