/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Base64Encoder;
import org.castor.core.util.HexDecoder;
import org.castor.core.util.Messages;
import org.castor.mapping.BindingType;
import org.castor.mapping.MappingUnmarshaller;
import org.castor.xml.InternalContext;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.MapHandler;
import org.exolab.castor.mapping.MapItem;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingLoader;
import org.exolab.castor.mapping.handlers.MapHandlers;
import org.exolab.castor.mapping.loader.CollectionHandlers;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.util.SafeStack;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.MarshalFramework;
import org.exolab.castor.xml.MarshalListener;
import org.exolab.castor.xml.NamespacesStack;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.OutputFormat;
import org.exolab.castor.xml.ProcessingInstruction;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.Serializer;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLClassDescriptorResolver;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.XMLMappingLoader;
import org.exolab.castor.xml.descriptors.RootArrayDescriptor;
import org.exolab.castor.xml.descriptors.StringClassDescriptor;
import org.exolab.castor.xml.handlers.DateFieldHandler;
import org.exolab.castor.xml.handlers.EnumFieldHandler;
import org.exolab.castor.xml.util.AnyNode2SAX2;
import org.exolab.castor.xml.util.AttributeSetImpl;
import org.exolab.castor.xml.util.DocumentHandlerAdapter;
import org.exolab.castor.xml.util.SAX2DOMHandler;
import org.exolab.castor.xml.util.StaxEventHandler;
import org.exolab.castor.xml.util.StaxStreamHandler;
import org.exolab.castor.xml.util.XMLClassDescriptorAdapter;
import org.exolab.castor.xml.util.XMLClassDescriptorImpl;
import org.exolab.castor.xml.util.XMLFieldDescriptorImpl;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Marshaller
extends MarshalFramework {
    private static final Log LOG = LogFactory.getLog(Marshaller.class);
    private static final String CDATA = "CDATA";
    private static final String DEFAULT_PREFIX = "ns";
    private static final String SERIALIZER_NOT_SAX_CAPABLE = "conf.serializerNotSaxCapable";
    private static final String XSI_PREFIX = "xsi";
    private static final String XSI_TYPE = "xsi:type";
    private int _namespaceCounter = 0;
    private static final StringClassDescriptor STRING_CLASS_DESCRIPTOR = new StringClassDescriptor();
    private boolean _asDocument = true;
    private int _depth = 0;
    private OutputFormat _format = null;
    private ContentHandler _handler = null;
    private boolean _marshalExtendedType = true;
    private MarshalListener _marshalListener = null;
    private NamespacesStack namespacesStack = new NamespacesStack();
    private List<String> _packages = new ArrayList<String>();
    private Stack _parents = new SafeStack();
    private List<ProcessingInstruction> _processingInstructions = new ArrayList<ProcessingInstruction>();
    private String _rootElement = null;
    private boolean _saveMapKeys = true;
    private Serializer _serializer = null;
    private boolean _suppressNamespaces = false;
    private boolean _suppressXSIType = false;
    private boolean _useXSITypeAtRoot = true;
    private AttributeSetImpl _topLevelAtts = new AttributeSetImpl();
    private AttributesImpl _attributes = new AttributesImpl();
    private boolean _validate = false;
    private final Set<String> _proxyInterfaces = new HashSet<String>();

    public Marshaller(DocumentHandler handler) {
        super(null);
        Marshaller.checkNotNull(handler, "The given 'org.sax.DocumentHandler' instance is null.");
        this.setContentHandler(new DocumentHandlerAdapter(handler));
    }

    public void setDocumentHandler(DocumentHandler handler) {
        Marshaller.checkNotNull(handler, "The given 'org.sax.DocumentHandler' instance is null.");
        this.setContentHandler(new DocumentHandlerAdapter(handler));
    }

    public Marshaller(ContentHandler contentHandler) {
        super(null);
        Marshaller.checkNotNull(contentHandler, "The given 'org.sax.ContentHandler' is null.");
        this.setContentHandler(contentHandler);
    }

    public Marshaller(InternalContext internalContext) {
        super(internalContext);
    }

    public Marshaller() {
        super(null);
    }

    public Marshaller(Writer out) throws IOException {
        super(null);
        this.setWriter(out);
    }

    public Marshaller(XMLStreamWriter xmlStreamWriter) {
        super(null);
        this.setXmlStreamWriter(xmlStreamWriter);
    }

    public Marshaller(XMLEventWriter xmlEventWriter) {
        super(null);
        this.setXmlEventWriter(xmlEventWriter);
    }

    public void setWriter(Writer out) throws IOException {
        Marshaller.checkNotNull(out, "The given 'java.io.Writer' instance is null.");
        this.configureSerializer(out);
    }

    public void setResult(Result result) throws IOException {
        Marshaller.checkNotNull(result, "The given 'javax.xml.transform.Result' instance is null.");
        if (result instanceof DOMResult) {
            DOMResult domResult = (DOMResult)result;
            if (domResult.getNode() != null) {
                this.setNode(domResult.getNode());
                return;
            }
        } else if (result instanceof SAXResult) {
            SAXResult saxResult = (SAXResult)result;
            if (saxResult.getHandler() != null) {
                this.setContentHandler(saxResult.getHandler());
                return;
            }
        } else if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result;
            if (streamResult.getWriter() != null) {
                this.setWriter(streamResult.getWriter());
                return;
            }
            if (streamResult.getOutputStream() != null) {
                this.setWriter(new PrintWriter(streamResult.getOutputStream()));
                return;
            }
        }
        throw new IllegalArgumentException("The given 'javax.transofrm.xml.Result' is not supported, or were incorrectly instantiated.");
    }

    private void configureSerializer(Writer out) throws IOException {
        this._serializer = this.getInternalContext().getSerializer();
        if (this._serializer == null) {
            throw new RuntimeException("Unable to obtain serializer");
        }
        this._serializer.setOutputCharStream(out);
        this._handler = new DocumentHandlerAdapter(this._serializer.asDocumentHandler());
        if (this._handler == null) {
            String err = Messages.format(SERIALIZER_NOT_SAX_CAPABLE, this._serializer.getClass().getName());
            throw new RuntimeException(err);
        }
    }

    public Marshaller(Node node) {
        super(null);
        Marshaller.checkNotNull(node, "The given 'org.w3c.dom.Node' instance is null.");
        this.setContentHandler(new DocumentHandlerAdapter(new SAX2DOMHandler(node)));
    }

    public void setNode(Node node) {
        Marshaller.checkNotNull(node, "The given 'org.w3c.dom.Node' instance is null.");
        this.setContentHandler(new DocumentHandlerAdapter(new SAX2DOMHandler(node)));
    }

    public void setXmlStreamWriter(XMLStreamWriter xmlStreamWriter) {
        Marshaller.checkNotNull(xmlStreamWriter, "The given 'java.xml.stream.XMLStreamWriter' instance is null.");
        this.setContentHandler(new StaxStreamHandler(xmlStreamWriter));
    }

    public void setXmlEventWriter(XMLEventWriter xmlEventWriter) {
        Marshaller.checkNotNull(xmlEventWriter, "The given 'java.xml.stream.XMLEventWriter' instance is null.");
        this.setContentHandler(new StaxEventHandler(xmlEventWriter));
    }

    @Override
    public void setInternalContext(InternalContext internalContext) {
        super.setInternalContext(internalContext);
        this.deriveProperties();
    }

    private void deriveProperties() {
        this._validate = this.getInternalContext().marshallingValidation();
        this._saveMapKeys = this.getInternalContext().getBooleanProperty("org.exolab.castor.xml.saveMapKeys");
        String prop = this.getInternalContext().getStringProperty("org.exolab.castor.xml.proxyInterfaces");
        if (prop != null) {
            StringTokenizer tokenizer = new StringTokenizer(prop, ", ");
            while (tokenizer.hasMoreTokens()) {
                this._proxyInterfaces.add(tokenizer.nextToken());
            }
        }
    }

    public void addProcessingInstruction(String target, String data) {
        Marshaller.checkNotEmpty(target, "The argument 'target' must not be null or empty.");
        Marshaller.checkNotNull(data, "The argument 'data' must not be null.");
        this._processingInstructions.add(new ProcessingInstruction(target, data));
    }

    public void setDoctype(String publicId, String systemId) {
        if (this._serializer != null) {
            if (this._format == null) {
                this._format = this.getInternalContext().getOutputFormat();
            }
        } else {
            String error = "doctype cannot be set if you've passed in your own DocumentHandler";
            throw new IllegalStateException(error);
        }
        this._format.setDoctype(publicId, systemId);
        this._serializer.setOutputFormat(this._format);
        this.setDocumentHandler();
    }

    public void setSupressXMLDeclaration(boolean supressXMLDeclaration) {
        this.setMarshalAsDocument(!supressXMLDeclaration);
    }

    public void setMarshalAsDocument(boolean asDocument) {
        this._asDocument = asDocument;
        if (this._serializer != null) {
            if (this._format == null) {
                this._format = this.getInternalContext().getOutputFormat();
            }
            this._format.setOmitXMLDeclaration(!asDocument);
            this._format.setOmitDocumentType(!asDocument);
            this._serializer.setOutputFormat(this._format);
            this.setDocumentHandler();
        }
    }

    public void setMapping(Mapping mapping) throws MappingException {
        if (this.getInternalContext() == null || this.getInternalContext().getXMLClassDescriptorResolver() == null) {
            String message = "No internal context or no class descriptor in context.";
            LOG.warn((Object)message);
            throw new IllegalStateException(message);
        }
        MappingUnmarshaller mum = new MappingUnmarshaller();
        MappingLoader resolver = mum.getMappingLoader(mapping, BindingType.XML);
        this.getInternalContext().getXMLClassDescriptorResolver().setMappingLoader(resolver);
    }

    public void setMarshalListener(MarshalListener listener) {
        this._marshalListener = listener;
    }

    public void setNamespaceMapping(String nsPrefix, String nsURI) {
        Marshaller.checkNotEmpty(nsURI, "Namespace URI must be not null.");
        this.namespacesStack.addNamespace(nsPrefix, nsURI);
    }

    public void setRootElement(String rootElement) {
        this._rootElement = rootElement;
    }

    public String getRootElement() {
        return this._rootElement;
    }

    public void setNSPrefixAtRoot(boolean nsPrefixAtRoot) {
    }

    public boolean getNSPrefixAtRoot() {
        return true;
    }

    public XMLClassDescriptorResolver getResolver() {
        if (this.getInternalContext() == null || this.getInternalContext().getXMLClassDescriptorResolver() == null) {
            String message = "No internal context or no class descriptor in context.";
            LOG.warn((Object)message);
            throw new IllegalStateException(message);
        }
        return this.getInternalContext().getXMLClassDescriptorResolver();
    }

    public void setResolver(XMLClassDescriptorResolver cdr) {
        if (cdr != null) {
            this.getInternalContext().setXMLClassDescriptorResolver(cdr);
        }
    }

    public void setValidation(boolean validate) {
        this._validate = validate;
    }

    public boolean getValidation() {
        return this._validate;
    }

    public void setMarshalExtendedType(boolean marshalExtendedType) {
        this._marshalExtendedType = marshalExtendedType;
    }

    public boolean getMarshalExtendedType() {
        return this._marshalExtendedType;
    }

    public static void marshal(Object object, Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller.staticMarshal(object, new Marshaller(out));
        }
        catch (IOException e) {
            throw new MarshalException(e);
        }
    }

    public static void marshal(Object object, DocumentHandler handler) throws MarshalException, ValidationException {
        Marshaller.staticMarshal(object, new Marshaller(handler));
    }

    public static void marshal(Object object, ContentHandler handler) throws MarshalException, ValidationException {
        Marshaller.staticMarshal(object, new Marshaller(handler));
    }

    public static void marshal(Object object, Node node) throws MarshalException, ValidationException {
        Marshaller.staticMarshal(object, new Marshaller(node));
    }

    private static void staticMarshal(Object object, Marshaller marshaller) throws MarshalException, ValidationException {
        if (object == null) {
            throw new MarshalException("object must not be null");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Marshaller called using one of the *static*  marshal(Object, *) methods. This will ignore any  mapping files as specified. Please consider switching to  using Marshaller instances and calling one of the marshal(*) methods.");
        }
        marshaller.marshal(object);
    }

    public void marshal(Object object) throws MarshalException, ValidationException {
        if (object == null) {
            throw new MarshalException("object must not be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Marshalling " + object.getClass().getName()));
        }
        if (object instanceof AnyNode) {
            try {
                AnyNode2SAX2.fireEvents((AnyNode)object, this._handler, this.namespacesStack);
            }
            catch (SAXException e) {
                throw new MarshalException(e);
            }
        } else {
            this.validate(object);
            MarshalState mstate = new MarshalState(object, "root");
            if (this._asDocument) {
                try {
                    this._handler.startDocument();
                    for (int i = 0; i < this._processingInstructions.size(); ++i) {
                        ProcessingInstruction pi = this._processingInstructions.get(i);
                        this._handler.processingInstruction(pi.getTarget(), pi.getData());
                    }
                    this.marshal(object, null, this._handler, mstate);
                    this._handler.endDocument();
                }
                catch (SAXException sx) {
                    throw new MarshalException(sx);
                }
            } else {
                this.marshal(object, null, this._handler, mstate);
            }
        }
    }

    private void marshal(Object object, XMLFieldDescriptor descriptor, ContentHandler handler, MarshalState mstate) throws MarshalException, ValidationException {
        int len;
        String valueType;
        String attValue;
        int i;
        if (object == null) {
            String err = "Marshaller#marshal: null parameter: 'object'";
            throw new MarshalException(err);
        }
        if (descriptor != null && descriptor.isTransient()) {
            return;
        }
        if (this._marshalListener != null) {
            boolean toBeMarshalled = true;
            try {
                toBeMarshalled = this._marshalListener.preMarshal(object);
            }
            catch (RuntimeException e) {
                LOG.error((Object)"Invoking #preMarshal() on your custom MarshalListener instance caused the following problem:", (Throwable)e);
            }
            if (!toBeMarshalled) {
                return;
            }
        }
        if (object instanceof AnyNode) {
            try {
                AnyNode2SAX2.fireEvents((AnyNode)object, handler, this.namespacesStack);
            }
            catch (SAXException e) {
                throw new MarshalException(e);
            }
            return;
        }
        boolean containerField = false;
        if (descriptor != null && descriptor.isContainer()) {
            containerField = true;
        }
        if (this._parents.search(object) >= 0) {
            return;
        }
        this._parents.push(object);
        boolean isNil = object instanceof NilObject;
        Class cls = null;
        if (!isNil) {
            cls = object.getClass();
            if (!this._proxyInterfaces.isEmpty()) {
                boolean isProxy = false;
                Class<?>[] interfaces = cls.getInterfaces();
                for (int i2 = 0; i2 < interfaces.length; ++i2) {
                    if (!this._proxyInterfaces.contains(interfaces[i2].getName())) continue;
                    isProxy = true;
                }
                if (isProxy) {
                    cls = cls.getSuperclass();
                }
            }
        } else {
            cls = ((NilObject)object).getClassDescriptor().getJavaClass();
        }
        boolean byteArray = false;
        if (cls.isArray()) {
            byteArray = cls.getComponentType() == Byte.TYPE;
        }
        boolean atRoot = false;
        if (descriptor == null) {
            descriptor = new XMLFieldDescriptorImpl(cls, "root", null, null);
            atRoot = true;
        }
        String name = descriptor.getXMLName();
        if (atRoot && this._rootElement != null) {
            name = this._rootElement;
        }
        boolean autoNameByClass = false;
        if (name == null) {
            autoNameByClass = true;
            name = cls.getName();
            int idx = name.lastIndexOf(46);
            if (idx >= 0) {
                name = name.substring(idx + 1);
            }
            name = this.getInternalContext().getXMLNaming().toXMLName(name);
        }
        XMLClassDescriptor classDesc = null;
        boolean saveType = false;
        if (object instanceof NilObject) {
            classDesc = ((NilObject)object).getClassDescriptor();
        } else if (cls == descriptor.getFieldType()) {
            classDesc = (XMLClassDescriptor)descriptor.getClassDescriptor();
        }
        if (classDesc == null) {
            if (Marshaller.isPrimitive(cls) || byteArray) {
                classDesc = STRING_CLASS_DESCRIPTOR;
                Class<?> fieldType = descriptor.getFieldType();
                if (cls != fieldType) {
                    while (fieldType.isArray()) {
                        fieldType = fieldType.getComponentType();
                    }
                    saveType = !Marshaller.primitiveOrWrapperEquals(cls, fieldType);
                }
            } else {
                saveType = cls.isArray();
                String className = cls.getName();
                int idx = className.lastIndexOf(".");
                String pkgName = null;
                if (idx > 0 && !this._packages.contains(pkgName = className.substring(0, idx + 1))) {
                    this._packages.add(pkgName);
                }
                if (this._marshalExtendedType) {
                    if (cls != descriptor.getFieldType() || atRoot) {
                        saveType = true;
                        boolean containsDesc = false;
                        if (!atRoot) {
                            Class<?> tmpType;
                            XMLClassDescriptor tmpDesc;
                            block206: {
                                String nsURI = descriptor.getNameSpaceURI();
                                tmpDesc = null;
                                try {
                                    tmpDesc = this.getResolver().resolveByXMLName(name, nsURI, null);
                                }
                                catch (ResolverException rx) {
                                    if (!LOG.isDebugEnabled()) break block206;
                                    LOG.debug((Object)"Error resolving", (Throwable)rx);
                                }
                            }
                            if (tmpDesc != null && (tmpType = tmpDesc.getJavaClass()) == cls) {
                                boolean bl = containsDesc = !tmpType.isInterface();
                            }
                        }
                        if (!containsDesc) {
                            String tmpName;
                            if (atRoot) {
                                if (this._useXSITypeAtRoot) {
                                    XMLMappingLoader ml = (XMLMappingLoader)this.getResolver().getMappingLoader();
                                    if (ml != null) {
                                        containsDesc = ml.getDescriptor(cls.getName()) != null;
                                    }
                                } else {
                                    containsDesc = true;
                                }
                            }
                            if (!containsDesc && pkgName == null && (classDesc = this.getClassDescriptor(cls)) != null && name.equals(tmpName = classDesc.getXMLName())) {
                                saveType = false;
                            }
                        }
                        if (containsDesc) {
                            saveType = false;
                        }
                    }
                    if (classDesc == null) {
                        classDesc = this.getClassDescriptor(cls);
                    }
                } else {
                    cls = descriptor.getFieldType();
                    classDesc = this.getClassDescriptor(cls);
                }
                if (classDesc == null && cls.isArray()) {
                    classDesc = new RootArrayDescriptor(cls);
                    if (atRoot) {
                        boolean bl = containerField = !this._asDocument;
                    }
                }
            }
            if (classDesc == null) {
                if (cls == Void.class || cls == Object.class || cls == Class.class) {
                    throw new MarshalException("The marshaller cannot marshal/unmarshal types of Void.class, Class.class or Object.class");
                }
                this._parents.pop();
                return;
            }
        }
        if (autoNameByClass && classDesc.getXMLName() != null) {
            name = classDesc.getXMLName();
        }
        if (atRoot) {
            mstate._xmlName = name;
        }
        boolean bl = saveType = saveType && !this._suppressXSIType;
        if (saveType) {
            if (descriptor.getHandler() instanceof DateFieldHandler) {
                saveType = false;
            } else if (descriptor.getHandler() instanceof EnumFieldHandler) {
                saveType = false;
            } else if (isNil) {
                saveType = false;
            }
        }
        if (saveType) {
            XMLClassDescriptor xmlElementNameClassDesc;
            String xmlNamespace;
            String xmlElementName;
            block207: {
                xmlElementName = name;
                xmlNamespace = descriptor.getNameSpaceURI();
                xmlElementNameClassDesc = null;
                try {
                    xmlElementNameClassDesc = this.getResolver().resolveByXMLName(xmlElementName, null, null);
                }
                catch (ResolverException rx) {
                    if (!LOG.isDebugEnabled()) break block207;
                    LOG.debug((Object)("Error resolving " + xmlElementName), (Throwable)rx);
                }
            }
            if (xmlElementName != null && xmlElementNameClassDesc != null) {
                XMLClassDescriptor tempContaining;
                try {
                    Iterator<ClassDescriptor> classDescriptorIter = this.getResolver().resolveAllByXMLName(xmlElementName, null, null);
                    while (classDescriptorIter.hasNext() && cls != (xmlElementNameClassDesc = (XMLClassDescriptor)classDescriptorIter.next()).getJavaClass()) {
                        xmlElementNameClassDesc = null;
                    }
                }
                catch (ResolverException rx) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Error resolving " + xmlElementName), (Throwable)rx);
                    }
                    xmlElementNameClassDesc = null;
                }
                if (xmlElementNameClassDesc instanceof XMLClassDescriptorAdapter && (tempContaining = (XMLClassDescriptor)descriptor.getContainingClassDescriptor()) != null) {
                    XMLFieldDescriptor fieldDescMatch = tempContaining.getFieldDescriptor(xmlElementName, xmlNamespace, NodeType.Element);
                    MarshalFramework.InheritanceMatch[] matches = this.searchInheritance(xmlElementName, null, tempContaining);
                    if (matches.length == 1) {
                        boolean oneAndOnlyOneMatchedField;
                        boolean foundTheRightClass = xmlElementNameClassDesc != null && cls == xmlElementNameClassDesc.getJavaClass();
                        boolean bl2 = oneAndOnlyOneMatchedField = fieldDescMatch != null || matches[0].parentFieldDesc == descriptor;
                        if (foundTheRightClass && oneAndOnlyOneMatchedField) {
                            saveType = false;
                        }
                    }
                }
            }
        }
        if (!atRoot) {
            this.namespacesStack.addNewNamespaceScope();
        }
        Object nsPrefix = "";
        String nsURI = "";
        if (!this._suppressNamespaces) {
            nsPrefix = descriptor.getNameSpacePrefix();
            if (nsPrefix == null) {
                nsPrefix = classDesc.getNameSpacePrefix();
            }
            if ((nsURI = descriptor.getNameSpaceURI()) == null) {
                nsURI = classDesc.getNameSpaceURI();
            }
            if (nsURI == null && nsPrefix != null) {
                nsURI = this.namespacesStack.getNamespaceURI((String)nsPrefix);
            } else if (nsPrefix == null && nsURI != null) {
                nsPrefix = this.namespacesStack.getNamespacePrefix(nsURI);
            }
            if (nsURI != null) {
                defaultNamespace = this.namespacesStack.getDefaultNamespaceURI();
                if (nsPrefix == null && !nsURI.equals(defaultNamespace)) {
                    nsPrefix = defaultNamespace == null && atRoot ? "" : DEFAULT_PREFIX + ++this._namespaceCounter;
                }
                this.declareNamespace((String)nsPrefix, nsURI);
            } else {
                nsURI = "";
                defaultNamespace = this.namespacesStack.getNamespaceURI("");
                if (defaultNamespace != null && !"".equals(defaultNamespace)) {
                    this.namespacesStack.addNamespace("", "");
                }
            }
        }
        AttributesImpl atts = new AttributesImpl();
        if (atRoot) {
            if (this._topLevelAtts.getSize() > 0) {
                this.namespacesStack.addNamespace(XSI_PREFIX, "http://www.w3.org/2001/XMLSchema-instance");
            }
            for (int i3 = 0; i3 < this._topLevelAtts.getSize(); ++i3) {
                String localName = this._topLevelAtts.getName(i3);
                Object qName = localName;
                String ns = "";
                if (!this._suppressNamespaces) {
                    ns = this._topLevelAtts.getNamespace(i3);
                    String prefix = null;
                    if (StringUtils.isNotEmpty((CharSequence)ns)) {
                        prefix = this.namespacesStack.getNonDefaultNamespacePrefix(ns);
                    }
                    if (StringUtils.isNotEmpty(prefix)) {
                        qName = prefix + ":" + (String)qName;
                    }
                    if (ns == null) {
                        ns = "";
                    }
                }
                atts.addAttribute(ns, localName, (String)qName, CDATA, this._topLevelAtts.getValue(i3));
            }
        }
        int nestedAttCount = 0;
        XMLFieldDescriptor[] nestedAtts = null;
        XMLFieldDescriptor[] descriptors = null;
        descriptors = !descriptor.isReference() && !isNil ? classDesc.getAttributeDescriptors() : NO_FIELD_DESCRIPTORS;
        for (i = 0; i < descriptors.length; ++i) {
            XMLFieldDescriptor attributeDescriptor = descriptors[i];
            if (attributeDescriptor == null) continue;
            String path = attributeDescriptor.getLocationPath();
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                if (nestedAtts == null) {
                    nestedAtts = new XMLFieldDescriptor[descriptors.length - i];
                }
                nestedAtts[nestedAttCount] = attributeDescriptor;
                ++nestedAttCount;
                continue;
            }
            this.processAttribute(object, attributeDescriptor, atts);
        }
        if (mstate._nestedAttCount > 0) {
            for (i = 0; i < mstate._nestedAtts.length; ++i) {
                String locationPath;
                XMLFieldDescriptor attributeDescriptor = mstate._nestedAtts[i];
                if (attributeDescriptor == null || !name.equals(locationPath = attributeDescriptor.getLocationPath())) continue;
                mstate._nestedAtts[i] = null;
                --mstate._nestedAttCount;
                this.processAttribute(mstate.getOwner(), attributeDescriptor, atts);
            }
        }
        if (!isNil) {
            this.processContainerAttributes(object, classDesc, atts);
        }
        if ((attValue = descriptor.getXMLProperty("xml:space")) != null) {
            atts.addAttribute("http://www.w3.org/XML/1998/namespace", "space", "xml:space", CDATA, attValue);
        }
        if ((attValue = descriptor.getXMLProperty("xml:lang")) != null) {
            atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", CDATA, attValue);
        }
        if (saveType) {
            this.declareNamespace(XSI_PREFIX, "http://www.w3.org/2001/XMLSchema-instance");
            Object typeName = classDesc.getXMLName();
            boolean introspected = false;
            introspected = classDesc instanceof MarshalFramework.InternalXMLClassDescriptor ? ((MarshalFramework.InternalXMLClassDescriptor)classDesc).introspected() : Introspector.introspected(classDesc);
            boolean useJavaPrefix = false;
            if (typeName == null || introspected) {
                typeName = "java:" + cls.getName();
                useJavaPrefix = true;
            } else if (classDesc instanceof RootArrayDescriptor) {
                typeName = "java:" + cls.getName();
                useJavaPrefix = true;
            } else {
                String dcn = classDesc.getClass().getName();
                if (dcn.equals(XMLClassDescriptorImpl.class.getName())) {
                    typeName = "java:" + cls.getName();
                    useJavaPrefix = true;
                } else {
                    String tns = classDesc.getNameSpaceURI();
                    String prefix = null;
                    if (StringUtils.isNotEmpty((CharSequence)tns) && StringUtils.isNotEmpty((CharSequence)(prefix = this.namespacesStack.getNamespacePrefix(tns)))) {
                        typeName = prefix + ":" + (String)typeName;
                    }
                }
            }
            atts.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", XSI_TYPE, CDATA, (String)typeName);
            if (useJavaPrefix && this.namespacesStack.getNamespaceURI("java") == null) {
                this.declareNamespace("java", "http://java.sun.com");
            }
        }
        if (isNil && !this._suppressXSIType) {
            this.declareNamespace(XSI_PREFIX, "http://www.w3.org/2001/XMLSchema-instance");
            atts.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi:nil", CDATA, "true");
        }
        if ((valueType = descriptor.getSchemaType()) != null && valueType.equals("QName")) {
            object = this.resolveQName(object, descriptor);
        }
        Object qName = null;
        qName = nsPrefix != null ? ((len = ((String)nsPrefix).length()) > 0 ? (String)nsPrefix + ":" + name : name) : name;
        NilObject firstNonNullValue = null;
        int firstNonNullIdx = 0;
        try {
            if (!containerField) {
                if (!isNil && descriptor.isNillable()) {
                    boolean isNilContent;
                    XMLFieldDescriptor desc = classDesc.getContentDescriptor();
                    descriptors = classDesc.getElementDescriptors();
                    int descCount = descriptors.length;
                    boolean bl3 = isNilContent = descCount > 0 || desc != null;
                    if (desc != null) {
                        Object value = desc.getHandler().getValue(object);
                        if (value != null) {
                            isNilContent = false;
                            descCount = 0;
                        } else if (desc.isNillable() && desc.isRequired()) {
                            isNilContent = false;
                            descCount = 0;
                        }
                    }
                    for (int i4 = 0; i4 < descCount; ++i4) {
                        desc = descriptors[i4];
                        if (desc == null) continue;
                        Object value = desc.getHandler().getValue(object);
                        if (value != null) {
                            isNilContent = false;
                            firstNonNullIdx = i4;
                            firstNonNullValue = (NilObject)value;
                            break;
                        }
                        if (!desc.isNillable() || !desc.isRequired()) continue;
                        isNilContent = false;
                        firstNonNullIdx = i4;
                        firstNonNullValue = new NilObject(classDesc, desc);
                        break;
                    }
                    if (isNilContent) {
                        this.declareNamespace(XSI_PREFIX, "http://www.w3.org/2001/XMLSchema-instance");
                        atts.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi:nil", CDATA, "true");
                    }
                }
                this.namespacesStack.getCurrentNamespaceScope().sendStartEvents(handler);
                if (qName == null) {
                    String err = "Error in deriving name for type: " + cls.getName() + ", please report bug to: http://castor.exolab.org.";
                    throw new IllegalStateException(err);
                }
                handler.startElement(nsURI, name, (String)qName, atts);
            }
        }
        catch (SAXException sx) {
            throw new MarshalException(sx);
        }
        SafeStack<WrapperInfo> wrappers = null;
        if (!isNil) {
            XMLFieldDescriptor cdesc = null;
            if (!descriptor.isReference()) {
                cdesc = classDesc.getContentDescriptor();
            }
            if (cdesc != null) {
                Object obj = null;
                try {
                    obj = cdesc.getHandler().getValue(object);
                }
                catch (IllegalStateException ise) {
                    LOG.warn((Object)("Error getting value from: " + object), (Throwable)ise);
                }
                if (obj != null) {
                    String path = cdesc.getLocationPath();
                    Object currentLoc = null;
                    if (path != null) {
                        this._attributes.clear();
                        if (wrappers == null) {
                            wrappers = new SafeStack<WrapperInfo>();
                        }
                        try {
                            while (path != null) {
                                String elemName = null;
                                int idx = path.indexOf(47);
                                if (idx > 0) {
                                    elemName = path.substring(0, idx);
                                    path = path.substring(idx + 1);
                                } else {
                                    elemName = path;
                                    path = null;
                                }
                                currentLoc = currentLoc == null ? elemName : (String)currentLoc + "/" + elemName;
                                Object elemQName = elemName;
                                if (StringUtils.isNotEmpty((CharSequence)nsPrefix)) {
                                    elemQName = (String)nsPrefix + ":" + elemName;
                                }
                                wrappers.push(new WrapperInfo(elemName, (String)elemQName, (String)currentLoc));
                                this._attributes.clear();
                                if (nestedAttCount > 0) {
                                    for (int na = 0; na < nestedAtts.length; ++na) {
                                        String tmpPath;
                                        if (nestedAtts[na] == null || !(tmpPath = nestedAtts[na].getLocationPath()).equals(currentLoc)) continue;
                                        this.processAttribute(object, nestedAtts[na], this._attributes);
                                        nestedAtts[na] = null;
                                        --nestedAttCount;
                                    }
                                }
                                handler.startElement(nsURI, elemName, (String)elemQName, this._attributes);
                            }
                        }
                        catch (SAXException sx) {
                            throw new MarshalException(sx);
                        }
                    }
                    char[] chars = null;
                    Class<?> objType = obj.getClass();
                    if (objType.isArray() && objType.getComponentType() == Byte.TYPE) {
                        String schemaType = descriptor.getSchemaType();
                        chars = "hexBinary".equals(schemaType) ? new String(HexDecoder.encode((byte[])obj)).toCharArray() : Base64Encoder.encode((byte[])obj);
                    } else {
                        String str = obj.toString();
                        if (StringUtils.isNotEmpty((CharSequence)str)) {
                            chars = str.toCharArray();
                        }
                    }
                    if (chars != null && chars.length > 0) {
                        try {
                            handler.characters(chars, 0, chars.length);
                        }
                        catch (SAXException sx) {
                            throw new MarshalException(sx);
                        }
                    }
                }
            } else if (descriptor.isReference()) {
                Object id = this.getObjectID(object);
                if (id != null) {
                    char[] chars = id.toString().toCharArray();
                    try {
                        handler.characters(chars, 0, chars.length);
                    }
                    catch (SAXException sx) {
                        throw new MarshalException(sx);
                    }
                }
            } else {
                if (byteArray) {
                    String schemaType = descriptor.getSchemaType();
                    String componentType = descriptor.getComponentType();
                    char[] chars = new char[]{};
                    chars = descriptor.isMultivalued() && "hexBinary".equals(componentType) || "hexBinary".equals(schemaType) ? new String(HexDecoder.encode((byte[])object)).toCharArray() : Base64Encoder.encode((byte[])object);
                    try {
                        handler.characters(chars, 0, chars.length);
                    }
                    catch (SAXException sx) {
                        throw new MarshalException(sx);
                    }
                }
                if (Marshaller.isPrimitive(cls)) {
                    char[] chars = cls == BigDecimal.class ? this.convertBigDecimalToString(object).toCharArray() : object.toString().toCharArray();
                    try {
                        handler.characters(chars, 0, chars.length);
                    }
                    catch (SAXException sx) {
                        throw new MarshalException(sx);
                    }
                }
                if (Marshaller.isEnum(cls)) {
                    char[] chars = object.toString().toCharArray();
                    try {
                        handler.characters(chars, 0, chars.length);
                    }
                    catch (SAXException sx) {
                        throw new MarshalException(sx);
                    }
                }
            }
        }
        descriptors = isNil || descriptor.isReference() ? NO_FIELD_DESCRIPTORS : classDesc.getElementDescriptors();
        ++this._depth;
        for (int i5 = firstNonNullIdx; i5 < descriptors.length; ++i5) {
            XMLFieldDescriptor elemDescriptor = descriptors[i5];
            NilObject obj = null;
            boolean nil = false;
            if (i5 == firstNonNullIdx && firstNonNullValue != null) {
                obj = firstNonNullValue;
            } else {
                try {
                    obj = (NilObject)elemDescriptor.getHandler().getValue(object);
                }
                catch (IllegalStateException ise) {
                    LOG.warn((Object)("Error marshalling " + object), (Throwable)ise);
                    continue;
                }
            }
            if (obj == null || obj instanceof Enumeration && !((Enumeration)((Object)obj)).hasMoreElements()) {
                if (!elemDescriptor.isNillable() || !elemDescriptor.isRequired()) continue;
                nil = true;
            }
            String path = elemDescriptor.getLocationPath();
            Object currentLoc = null;
            if (wrappers != null) {
                try {
                    while (!wrappers.empty()) {
                        WrapperInfo wInfo = (WrapperInfo)wrappers.peek();
                        if (path != null) {
                            if (wInfo._location.equals(path)) {
                                path = null;
                                break;
                            }
                            if (path.startsWith(wInfo._location + "/")) {
                                path = path.substring(wInfo._location.length() + 1);
                                currentLoc = wInfo._location;
                                break;
                            }
                        }
                        handler.endElement(nsURI, wInfo._localName, wInfo._qName);
                        wrappers.pop();
                    }
                }
                catch (SAXException sx) {
                    throw new MarshalException(sx);
                }
            }
            if (path != null) {
                this._attributes.clear();
                if (wrappers == null) {
                    wrappers = new SafeStack();
                }
                try {
                    while (path != null) {
                        String elemName = null;
                        int idx = path.indexOf(47);
                        if (idx > 0) {
                            elemName = path.substring(0, idx);
                            path = path.substring(idx + 1);
                        } else {
                            elemName = path;
                            path = null;
                        }
                        currentLoc = currentLoc == null ? elemName : (String)currentLoc + "/" + elemName;
                        Object elemQName = elemName;
                        if (StringUtils.isNotEmpty((CharSequence)nsPrefix)) {
                            elemQName = (String)nsPrefix + ":" + elemName;
                        }
                        wrappers.push(new WrapperInfo(elemName, (String)elemQName, (String)currentLoc));
                        this._attributes.clear();
                        if (nestedAttCount > 0) {
                            for (int na = 0; na < nestedAtts.length; ++na) {
                                String tmpPath;
                                if (nestedAtts[na] == null || !(tmpPath = nestedAtts[na].getLocationPath()).equals(currentLoc)) continue;
                                this.processAttribute(object, nestedAtts[na], this._attributes);
                                nestedAtts[na] = null;
                                --nestedAttCount;
                            }
                        }
                        handler.startElement(nsURI, elemName, (String)elemQName, this._attributes);
                    }
                }
                catch (SAXException sx) {
                    throw new MarshalException(sx);
                }
            }
            if (nil) {
                obj = new NilObject(classDesc, elemDescriptor);
            }
            Class<?> type = obj.getClass();
            MarshalState myState = mstate.createMarshalState(object, name);
            myState._nestedAtts = nestedAtts;
            myState._nestedAttCount = nestedAttCount;
            if (type.isArray() && type.getComponentType() == Byte.TYPE) {
                this.marshal(obj, elemDescriptor, handler, myState);
            } else if (type.isArray() && elemDescriptor.isDerivedFromXSList()) {
                Object buffer = this.processXSListType(obj, elemDescriptor);
                String elemName = elemDescriptor.getXMLName();
                Object elemQName = elemName;
                if (StringUtils.isNotEmpty((CharSequence)nsPrefix)) {
                    elemQName = (String)nsPrefix + ":" + elemName;
                }
                char[] chars = buffer.toString().toCharArray();
                try {
                    handler.startElement(nsURI, elemName, (String)elemQName, this._attributes);
                    handler.characters(chars, 0, chars.length);
                    handler.endElement(nsURI, elemName, (String)elemQName);
                }
                catch (SAXException sx) {
                    throw new MarshalException(sx);
                }
            } else if (Marshaller.isCollection(type)) {
                MapHandler mapHandler;
                boolean processCollection = true;
                if (this._saveMapKeys && (mapHandler = MapHandlers.getHandler(type)) != null) {
                    processCollection = false;
                    MapItem item = new MapItem();
                    Enumeration keys = mapHandler.keys(obj);
                    while (keys.hasMoreElements()) {
                        item.setKey(keys.nextElement());
                        item.setValue(mapHandler.get(obj, item.getKey()));
                        this.marshal(item, elemDescriptor, handler, myState);
                    }
                }
                if (processCollection) {
                    CollectionHandler colHandler = this.getCollectionHandler(type);
                    Enumeration enumeration = colHandler.elements(obj);
                    while (enumeration.hasMoreElements()) {
                        Object item = enumeration.nextElement();
                        if (item == null) continue;
                        this.marshal(item, elemDescriptor, handler, myState);
                    }
                }
            } else {
                this.marshal(obj, elemDescriptor, handler, myState);
            }
            if (nestedAttCount <= 0) continue;
            nestedAttCount = myState._nestedAttCount;
        }
        if (wrappers != null) {
            try {
                while (!wrappers.empty()) {
                    WrapperInfo wInfo = (WrapperInfo)wrappers.peek();
                    boolean popStack = true;
                    if (nestedAttCount > 0) {
                        for (int na = 0; na < nestedAtts.length; ++na) {
                            String nestedAttributePath;
                            if (nestedAtts[na] == null || !(nestedAttributePath = nestedAtts[na].getLocationPath()).startsWith(wInfo._location + "/")) continue;
                            popStack = false;
                            break;
                        }
                    }
                    if (popStack) {
                        handler.endElement(nsURI, wInfo._localName, wInfo._qName);
                        wrappers.pop();
                        continue;
                    }
                    break;
                }
            }
            catch (SAXException sx) {
                throw new MarshalException(sx);
            }
        }
        if (wrappers != null && !wrappers.isEmpty()) {
            this.dealWithNestedAttributesNested(object, handler, (String)nsPrefix, nsURI, nestedAttCount, nestedAtts, (Stack<WrapperInfo>)wrappers);
        }
        this.dealWithNestedAttributes(object, handler, (String)nsPrefix, nsURI, nestedAttCount, nestedAtts, new SafeStack<WrapperInfo>());
        try {
            if (!containerField) {
                handler.endElement(nsURI, name, (String)qName);
                this.namespacesStack.getCurrentNamespaceScope().sendEndEvents(handler);
            }
        }
        catch (SAXException sx) {
            throw new MarshalException(sx);
        }
        --this._depth;
        this._parents.pop();
        if (!atRoot) {
            this.namespacesStack.removeNamespaceScope();
        }
        if (this._marshalListener != null) {
            try {
                this._marshalListener.postMarshal(object);
            }
            catch (RuntimeException e) {
                LOG.error((Object)"Invoking #postMarshal() on your custom MarshalListener instance caused the following problem:", (Throwable)e);
            }
        }
    }

    private void dealWithNestedAttributes(Object object, ContentHandler handler, String nsPrefix, String nsURI, int nestedAttCount, XMLFieldDescriptor[] nestedAtts, Stack<WrapperInfo> wrappers) throws MarshalException {
        if (nestedAttCount > 0) {
            for (int i = 0; i < nestedAtts.length; ++i) {
                if (nestedAtts[i] == null) continue;
                String path = nestedAtts[i].getLocationPath();
                Object currentLoc = null;
                if (nestedAtts[i].getHandler().getValue(object) == null) {
                    nestedAtts[i] = null;
                    --nestedAttCount;
                    continue;
                }
                try {
                    while (path != null) {
                        int idx = path.indexOf(47);
                        String elemName = null;
                        if (idx > 0) {
                            elemName = path.substring(0, idx);
                            path = path.substring(idx + 1);
                        } else {
                            elemName = path;
                            path = null;
                        }
                        currentLoc = currentLoc == null ? elemName : (String)currentLoc + "/" + elemName;
                        Object elemQName = elemName;
                        if (StringUtils.isNotEmpty((CharSequence)nsPrefix)) {
                            elemQName = nsPrefix + ":" + elemName;
                        }
                        wrappers.push(new WrapperInfo(elemName, (String)elemQName, null));
                        this._attributes.clear();
                        if (path == null) {
                            this.processAttribute(object, nestedAtts[i], this._attributes);
                            nestedAtts[i] = null;
                            --nestedAttCount;
                        }
                        if (nestedAttCount > 0) {
                            for (int na = i + 1; na < nestedAtts.length; ++na) {
                                String tmpPath;
                                if (nestedAtts[na] == null || !(tmpPath = nestedAtts[na].getLocationPath()).equals(currentLoc)) continue;
                                this.processAttribute(object, nestedAtts[na], this._attributes);
                                nestedAtts[na] = null;
                                --nestedAttCount;
                            }
                        }
                        handler.startElement(nsURI, elemName, (String)elemQName, this._attributes);
                    }
                    while (!wrappers.empty()) {
                        WrapperInfo wInfo = wrappers.pop();
                        handler.endElement(nsURI, wInfo._localName, wInfo._qName);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new MarshalException(e);
                }
            }
        }
    }

    private void dealWithNestedAttributesNested(Object object, ContentHandler handler, String nsPrefix, String nsURI, int nestedAttCount, XMLFieldDescriptor[] nestedAtts, Stack<WrapperInfo> wrappers) throws MarshalException {
        WrapperInfo wrapperInfo = wrappers.peek();
        String currentLocation = wrapperInfo._location;
        if (nestedAttCount > 0) {
            for (int i = 0; i < nestedAtts.length; ++i) {
                String nestedAttributePath;
                if (nestedAtts[i] == null || !(nestedAttributePath = nestedAtts[i].getLocationPath()).startsWith(currentLocation + "/")) continue;
                nestedAttributePath = nestedAttributePath.substring(wrapperInfo._location.length() + 1);
                Object currentLoc = currentLocation;
                if (nestedAtts[i].getHandler().getValue(object) == null) {
                    nestedAtts[i] = null;
                    --nestedAttCount;
                    continue;
                }
                try {
                    while (nestedAttributePath != null) {
                        int idx = nestedAttributePath.indexOf(47);
                        String elemName = null;
                        if (idx > 0) {
                            elemName = nestedAttributePath.substring(0, idx);
                            nestedAttributePath = nestedAttributePath.substring(idx + 1);
                        } else {
                            elemName = nestedAttributePath;
                            nestedAttributePath = null;
                        }
                        currentLoc = currentLoc == null ? elemName : (String)currentLoc + "/" + elemName;
                        Object elemQName = elemName;
                        if (StringUtils.isNotEmpty((CharSequence)nsPrefix)) {
                            elemQName = nsPrefix + ":" + elemName;
                        }
                        wrappers.push(new WrapperInfo(elemName, (String)elemQName, null));
                        this._attributes.clear();
                        if (nestedAttributePath == null) {
                            this.processAttribute(object, nestedAtts[i], this._attributes);
                            nestedAtts[i] = null;
                            --nestedAttCount;
                        }
                        if (nestedAttCount > 0) {
                            for (int na = i + 1; na < nestedAtts.length; ++na) {
                                String tmpPath;
                                if (nestedAtts[na] == null || !(tmpPath = nestedAtts[na].getLocationPath()).equals(currentLoc)) continue;
                                this.processAttribute(object, nestedAtts[na], this._attributes);
                                nestedAtts[na] = null;
                                --nestedAttCount;
                            }
                        }
                        handler.startElement(nsURI, elemName, (String)elemQName, this._attributes);
                    }
                    while (!wrappers.empty()) {
                        WrapperInfo wInfo = wrappers.pop();
                        handler.endElement(nsURI, wInfo._localName, wInfo._qName);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new MarshalException(e);
                }
            }
        }
    }

    private String convertBigDecimalToString(Object object) throws MarshalException {
        String stringValue;
        float javaVersion = Float.parseFloat(System.getProperty("java.specification.version"));
        if ((double)javaVersion >= 1.5) {
            try {
                Method method = BigDecimal.class.getMethod("toPlainString", null);
                stringValue = (String)method.invoke(object, (Object[])null);
            }
            catch (Exception e) {
                LOG.error((Object)"Problem accessing java.math.BigDecimal.toPlainString().", (Throwable)e);
                throw new MarshalException("Problem accessing java.math.BigDecimal.toPlainString().", e);
            }
        } else {
            stringValue = object.toString();
        }
        return stringValue;
    }

    private Object getObjectID(Object object) throws MarshalException {
        if (object == null) {
            return null;
        }
        Object id = null;
        XMLClassDescriptor cd = this.getClassDescriptor(object.getClass());
        String err = null;
        if (cd != null) {
            XMLFieldDescriptor fieldDesc = (XMLFieldDescriptor)cd.getIdentity();
            if (fieldDesc != null) {
                FieldHandler fieldHandler = fieldDesc.getHandler();
                if (fieldHandler != null) {
                    try {
                        id = fieldHandler.getValue(object);
                    }
                    catch (IllegalStateException ise) {
                        err = ise.toString();
                    }
                } else {
                    err = "FieldHandler for Identity descriptor is null.";
                }
            } else {
                err = "No identity descriptor available";
            }
        } else {
            err = "Unable to resolve ClassDescriptor.";
        }
        if (err != null) {
            Object errMsg = "Unable to resolve ID for instance of class '";
            errMsg = (String)errMsg + object.getClass().getName();
            errMsg = (String)errMsg + "' due to the following error: ";
            throw new MarshalException((String)errMsg + err);
        }
        return id;
    }

    private boolean declareNamespace(String nsPrefix, String nsURI) {
        boolean declared = false;
        if (nsURI != null && nsURI.length() != 0) {
            String tmpURI = this.namespacesStack.getNamespaceURI(nsPrefix);
            if (tmpURI != null && tmpURI.equals(nsURI)) {
                return declared;
            }
            String tmpPrefix = this.namespacesStack.getNamespacePrefix(nsURI);
            if (tmpPrefix == null || !tmpPrefix.equals(nsPrefix)) {
                this.namespacesStack.addNamespace(nsPrefix, nsURI);
                declared = true;
            }
        }
        return declared;
    }

    public void setLogWriter(PrintWriter printWriter) {
    }

    public void setEncoding(String encoding) {
        if (this._serializer != null) {
            if (this._format == null) {
                this._format = this.getInternalContext().getOutputFormat();
            }
            this._format.setEncoding(encoding);
            this._serializer.setOutputFormat(this._format);
            try {
                this._handler = new DocumentHandlerAdapter(this._serializer.asDocumentHandler());
            }
            catch (IOException iox) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Error setting encoding to " + encoding), (Throwable)iox);
                }
            }
        } else {
            String error = "encoding cannot be set if you've passed in your own DocumentHandler";
            throw new IllegalStateException(error);
        }
    }

    public void setNoNamespaceSchemaLocation(String schemaLocation) {
        if (schemaLocation != null) {
            this._topLevelAtts.setAttribute("noNamespaceSchemaLocation", schemaLocation, "http://www.w3.org/2001/XMLSchema-instance");
        }
    }

    public void setSchemaLocation(String schemaLocation) {
        if (schemaLocation != null) {
            this._topLevelAtts.setAttribute("schemaLocation", schemaLocation, "http://www.w3.org/2001/XMLSchema-instance");
        }
    }

    public void setSuppressNamespaces(boolean suppressNamespaces) {
        this._suppressNamespaces = suppressNamespaces;
    }

    public void setSuppressXSIType(boolean suppressXSIType) {
        this._suppressXSIType = suppressXSIType;
    }

    public void setUseXSITypeAtRoot(boolean useXSITypeAtRoot) {
        this._useXSITypeAtRoot = useXSITypeAtRoot;
    }

    private XMLClassDescriptor getClassDescriptor(Class<?> cls) throws MarshalException {
        XMLClassDescriptor classDesc = null;
        try {
            if (!Marshaller.isPrimitive(cls)) {
                classDesc = (XMLClassDescriptor)this.getResolver().resolve(cls);
            }
        }
        catch (ResolverException rx) {
            Throwable actual = rx.getCause();
            if (actual instanceof MarshalException) {
                throw (MarshalException)actual;
            }
            if (actual != null) {
                throw new MarshalException(actual);
            }
            throw new MarshalException(rx);
        }
        if (classDesc != null) {
            classDesc = new MarshalFramework.InternalXMLClassDescriptor(classDesc);
        }
        return classDesc;
    }

    private void processAttribute(Object object, XMLFieldDescriptor attDescriptor, AttributesImpl atts) throws MarshalException {
        Class<?> objType;
        if (attDescriptor == null) {
            return;
        }
        if (attDescriptor.getNodeType() == NodeType.Namespace) {
            Object map;
            MapHandler mapHandler;
            if (!this._suppressNamespaces && (mapHandler = MapHandlers.getHandler(map = attDescriptor.getHandler().getValue(object))) != null) {
                Enumeration keys = mapHandler.keys(map);
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    Object val = mapHandler.get(map, key);
                    this.declareNamespace(key.toString(), val.toString());
                }
            }
            return;
        }
        String localName = attDescriptor.getXMLName();
        Object qName = localName;
        String namespace = "";
        if (!this._suppressNamespaces) {
            namespace = attDescriptor.getNameSpaceURI();
            if (StringUtils.isNotEmpty((CharSequence)namespace)) {
                Object prefix = attDescriptor.getNameSpacePrefix();
                if (prefix == null || ((String)prefix).length() == 0) {
                    prefix = this.namespacesStack.getNonDefaultNamespacePrefix(namespace);
                }
                if (prefix == null || ((String)prefix).length() == 0) {
                    prefix = DEFAULT_PREFIX + ++this._namespaceCounter;
                }
                this.declareNamespace((String)prefix, namespace);
                qName = (String)prefix + ":" + (String)qName;
            } else {
                namespace = "";
            }
        }
        Object value = null;
        try {
            value = attDescriptor.getHandler().getValue(object);
        }
        catch (IllegalStateException ise) {
            LOG.warn((Object)("Error getting value from " + object), (Throwable)ise);
            return;
        }
        if (attDescriptor.isReference() && value != null) {
            if (attDescriptor.isMultivalued()) {
                Enumeration enumeration = null;
                if (value instanceof Enumeration) {
                    enumeration = (Enumeration)value;
                } else {
                    CollectionHandler colHandler = null;
                    try {
                        colHandler = CollectionHandlers.getHandler(value.getClass());
                    }
                    catch (MappingException mx) {
                        throw new MarshalException(mx);
                    }
                    enumeration = colHandler.elements(value);
                }
                if (enumeration.hasMoreElements()) {
                    StringBuilder sb = new StringBuilder();
                    int v = 0;
                    while (enumeration.hasMoreElements()) {
                        if (v > 0) {
                            sb.append(' ');
                        }
                        sb.append(this.getObjectID(enumeration.nextElement()));
                        ++v;
                    }
                    value = sb;
                } else {
                    value = null;
                }
            } else {
                value = this.getObjectID(value);
            }
        } else if (attDescriptor.isMultivalued() && value != null) {
            value = this.processXSListType(value, attDescriptor);
        } else if (value != null && (objType = value.getClass()).isArray() && objType.getComponentType() == Byte.TYPE) {
            value = this.encodeBinaryData(value, attDescriptor.getSchemaType());
        }
        if (value != null) {
            String valueType = attDescriptor.getSchemaType();
            if (valueType != null && valueType.equals("QName")) {
                value = this.resolveQName(value, attDescriptor);
            }
            atts.addAttribute(namespace, localName, (String)qName, CDATA, value.toString());
        }
    }

    private Object processXSListType(Object value, XMLFieldDescriptor descriptor) throws MarshalException {
        StringBuilder returnValue = null;
        Enumeration enumeration = null;
        if (value instanceof Enumeration) {
            enumeration = (Enumeration)value;
        } else {
            CollectionHandler colHandler = null;
            try {
                colHandler = CollectionHandlers.getHandler(value.getClass());
            }
            catch (MappingException mx) {
                throw new MarshalException(mx);
            }
            enumeration = colHandler.elements(value);
        }
        if (enumeration.hasMoreElements()) {
            StringBuilder sb = new StringBuilder();
            int v = 0;
            while (enumeration.hasMoreElements()) {
                Object collectionValue;
                Class<?> objType;
                if (v > 0) {
                    sb.append(' ');
                }
                if ((objType = (collectionValue = enumeration.nextElement()).getClass()).isArray() && objType.getComponentType() == Byte.TYPE) {
                    collectionValue = this.encodeBinaryData(collectionValue, descriptor.getComponentType());
                }
                sb.append(collectionValue);
                ++v;
            }
            returnValue = sb;
        }
        return returnValue;
    }

    private Object encodeBinaryData(Object valueToEncode, String componentType) {
        String encodedValue = "hexBinary".equals(componentType) ? HexDecoder.encode((byte[])valueToEncode) : new String(Base64Encoder.encode((byte[])valueToEncode));
        return encodedValue;
    }

    private void processContainerAttributes(Object target, XMLClassDescriptor classDesc, AttributesImpl atts) throws MarshalException {
        if (classDesc instanceof XMLClassDescriptorImpl && !((XMLClassDescriptorImpl)classDesc).hasContainerFields()) {
            return;
        }
        XMLFieldDescriptor[] elemDescriptors = classDesc.getElementDescriptors();
        for (int i = 0; i < elemDescriptors.length; ++i) {
            if (elemDescriptors[i] == null || !elemDescriptors[i].isContainer()) continue;
            this.processContainerAttributes(target, elemDescriptors[i], atts);
        }
    }

    private void processContainerAttributes(Object target, XMLFieldDescriptor containerFieldDesc, AttributesImpl atts) throws MarshalException {
        if (target.getClass().isArray()) {
            int length = Array.getLength(target);
            for (int j = 0; j < length; ++j) {
                Object item = Array.get(target, j);
                if (item == null) continue;
                this.processContainerAttributes(item, containerFieldDesc, atts);
            }
            return;
        }
        if (target instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)target;
            while (enumeration.hasMoreElements()) {
                Object item = enumeration.nextElement();
                if (item == null) continue;
                this.processContainerAttributes(item, containerFieldDesc, atts);
            }
            return;
        }
        Object containerObject = containerFieldDesc.getHandler().getValue(target);
        if (containerObject == null) {
            return;
        }
        XMLClassDescriptor containerClassDesc = (XMLClassDescriptor)containerFieldDesc.getClassDescriptor();
        if (containerClassDesc == null && (containerClassDesc = this.getClassDescriptor(containerFieldDesc.getFieldType())) == null) {
            return;
        }
        XMLFieldDescriptor[] attrDescriptors = containerClassDesc.getAttributeDescriptors();
        for (int idx = 0; idx < attrDescriptors.length; ++idx) {
            if (attrDescriptors[idx] == null || attrDescriptors[idx].getLocationPath() != null && attrDescriptors[idx].getLocationPath().length() != 0) continue;
            this.processAttribute(containerObject, attrDescriptors[idx], atts);
        }
        this.processContainerAttributes(containerObject, containerClassDesc, atts);
    }

    private Object resolveQName(Object value, XMLFieldDescriptor fieldDesc) {
        if (value == null || !(value instanceof String)) {
            return value;
        }
        if (!(fieldDesc instanceof XMLFieldDescriptorImpl)) {
            return value;
        }
        String result = (String)value;
        String nsURI = null;
        int idx = -1;
        if (result.length() > 0 && result.charAt(0) == '{') {
            idx = result.indexOf(125);
            if (idx <= 0) {
                String err = "Bad QName value :'" + result + "', it should follow the pattern '{URI}value'";
                throw new IllegalArgumentException(err);
            }
        } else {
            return value;
        }
        nsURI = result.substring(1, idx);
        Object prefix = ((XMLFieldDescriptorImpl)fieldDesc).getQNamePrefix();
        if (prefix == null) {
            prefix = this.namespacesStack.getNamespacePrefix(nsURI);
        }
        if (prefix == null) {
            prefix = DEFAULT_PREFIX + ++this._namespaceCounter;
        }
        result = ((String)prefix).length() != 0 ? (String)prefix + ":" + result.substring(idx + 1) : result.substring(idx + 1);
        this.declareNamespace((String)prefix, nsURI);
        return result;
    }

    private void validate(Object object) throws ValidationException {
        if (this._validate) {
            Validator validator = new Validator();
            ValidationContext context = new ValidationContext();
            context.setInternalContext(this.getInternalContext());
            validator.validate(object, context);
        }
    }

    public String getProperty(String name) {
        return this.getInternalContext().getStringProperty(name);
    }

    public void setProperty(String name, String value) {
        this.getInternalContext().setProperty(name, value);
        this.deriveProperties();
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this._handler = contentHandler;
    }

    private void setDocumentHandler() {
        block2: {
            try {
                this._handler = new DocumentHandlerAdapter(this._serializer.asDocumentHandler());
            }
            catch (IOException iox) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Error setting up document handler", (Throwable)iox);
            }
        }
    }

    private static void checkNotEmpty(String param, String msg) {
        Marshaller.checkNotNull(param, msg);
        if (param.length() == 0) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static void checkNotNull(Object param, String msg) {
        if (param == null) {
            throw new IllegalArgumentException(msg);
        }
    }

    static class MarshalState {
        private String _xpath = null;
        private XMLFieldDescriptor[] _nestedAtts = null;
        private int _nestedAttCount = 0;
        private MarshalState _parent = null;
        private Object _owner = null;
        private String _xmlName = null;

        MarshalState(Object owner, String xmlName) {
            Marshaller.checkNotNull(owner, "The argument 'owner' must not be null.");
            Marshaller.checkNotNull(xmlName, "The argument 'xmlName' must not be null.");
            this._owner = owner;
            this._xmlName = xmlName;
        }

        MarshalState createMarshalState(Object owner, String xmlName) {
            MarshalState ms = new MarshalState(owner, xmlName);
            ms._parent = this;
            return ms;
        }

        String getXPath() {
            if (this._xpath == null) {
                this._xpath = this._parent != null ? this._parent.getXPath() + "/" + this._xmlName : this._xmlName;
            }
            return this._xpath;
        }

        Object getOwner() {
            return this._owner;
        }

        MarshalState getParent() {
            return this._parent;
        }
    }

    public static class NilObject {
        private XMLClassDescriptor _classDesc = null;
        private XMLFieldDescriptor _fieldDesc = null;

        NilObject(XMLClassDescriptor classDesc, XMLFieldDescriptor fieldDesc) {
            this._classDesc = classDesc;
            this._fieldDesc = fieldDesc;
        }

        public XMLClassDescriptor getClassDescriptor() {
            return this._classDesc;
        }

        public XMLFieldDescriptor getFieldDescriptor() {
            return this._fieldDesc;
        }
    }

    static class WrapperInfo {
        private String _localName = null;
        private String _qName = null;
        private String _location = null;

        WrapperInfo(String localName, String qName, String location) {
            this._localName = localName;
            this._qName = qName;
            this._location = location;
        }
    }
}

