/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaContext;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;
import org.exolab.castor.xml.schema.simpletypes.ListType;

public class SimpleTypeListUnmarshaller
extends ComponentReader {
    private ComponentReader unmarshaller;
    private int depth = 0;
    private ListType _list = null;
    private Schema _schema = null;
    private boolean foundAnnotation = false;
    private boolean foundSimpleType = false;
    private boolean foundItemType = false;

    SimpleTypeListUnmarshaller(SchemaContext schemaContext, Schema schema, AttributeSet atts) throws XMLException {
        super(schemaContext);
        this._schema = schema;
        this._list = new ListType(schema);
        String itemTypeName = atts.getValue("itemType");
        if (itemTypeName != null && itemTypeName.length() > 0) {
            this.foundItemType = true;
            XMLType itemType = this._schema.getType(itemTypeName);
            if (itemType == null) {
                this._list.setItemType(itemTypeName);
            } else {
                if (itemType.getStructureType() == 6) {
                    String err = "The item type of a list cannot be a complexType.";
                    throw new IllegalStateException(err);
                }
                this._list.setItemType((SimpleType)itemType);
            }
        }
        this._list.setId(atts.getValue("id"));
    }

    @Override
    public String elementName() {
        return "list";
    }

    @Override
    public void finish() throws XMLException {
        if (!this.foundItemType && !this.foundSimpleType) {
            String err = "Missing sub-component of <list>, either use  the 'itemType' attribute, or an anonymous simpleType.";
            this.error(err);
        }
    }

    @Override
    public Object getObject() {
        if (!this.foundItemType && !this.foundSimpleType) {
            String err = "Missing sub-component of <list>, either use  the 'itemType' attribute, or an anonymous simpleType.";
            throw new IllegalStateException(err);
        }
        return this._list;
    }

    @Override
    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this.depth;
            return;
        }
        if (name.equals("annotation")) {
            if (this.foundSimpleType) {
                this.error("An annotation must appear as the first child of 'list' elements.");
            }
            if (this.foundAnnotation) {
                this.error("Only one (1) annotation may appear as a child of 'list' elements.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(this.getSchemaContext(), atts);
        } else if ("simpleType".equals(name)) {
            if (this.foundItemType) {
                this.error("A 'list' element can have either an 'itemType' or  'simpleType'.");
            }
            if (this.foundSimpleType) {
                this.error("Only one (1) 'simpleType' may appear as a child of 'list' elements.");
            }
            this.foundSimpleType = true;
            this.unmarshaller = new SimpleTypeUnmarshaller(this.getSchemaContext(), this._schema, atts);
        } else {
            this.illegalElement(name);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    @Override
    public void endElement(String name, String namespace) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(name, namespace);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("annotation".equals(name)) {
            Annotation ann = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._list.setLocalAnnotation(ann);
        } else if ("simpleType".equals(name)) {
            SimpleType type = (SimpleType)this.unmarshaller.getObject();
            this._list.setItemType(type);
        }
        this.unmarshaller = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(ch, start, length);
        }
    }
}

