/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import org.castor.xml.BackwardCompatibilityContext;
import org.castor.xml.InternalContext;
import org.exolab.castor.util.NestedIOException;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.util.XMLInstance2SchemaHandler;
import org.exolab.castor.xml.schema.writer.SchemaWriter;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class XMLInstance2Schema {
    private InternalContext _internalContext;
    private Order _defaultGroup = Order.sequence;

    public XMLInstance2Schema() {
        this._internalContext = new BackwardCompatibilityContext();
    }

    public Schema createSchema(String filename) throws IOException {
        return this.createSchema(new InputSource(filename));
    }

    public Schema createSchema(Reader reader) throws IOException {
        return this.createSchema(new InputSource(reader));
    }

    public Schema createSchema(InputSource source) throws IOException {
        XMLInstance2SchemaHandler handler = new XMLInstance2SchemaHandler();
        handler.setDefaultGroupOrder(this._defaultGroup);
        try {
            Parser parser = this._internalContext.getParser();
            if (parser == null) {
                throw new IOException("fatal error: unable to create SAX parser.");
            }
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            parser.parse(source);
        }
        catch (SAXException sx) {
            throw new NestedIOException(sx);
        }
        return handler.getSchema();
    }

    public void setDefaultGroupingAsAll() {
        this._defaultGroup = Order.all;
    }

    public void serializeSchema(Writer dstWriter, Schema schema) throws IOException, SAXException {
        SchemaWriter schemaWriter = new SchemaWriter(dstWriter);
        schemaWriter.write(schema);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Missing filename");
            System.out.println();
            System.out.println("usage: java XMLInstance2Schema <input-file> [<output-file> (optional)]");
            return;
        }
        try {
            XMLInstance2Schema xi2s = new XMLInstance2Schema();
            Schema schema = xi2s.createSchema(args[0]);
            Writer dstWriter = null;
            dstWriter = args.length > 1 ? new FileWriter(args[1]) : new PrintWriter(System.out, true);
            xi2s.serializeSchema(dstWriter, schema);
            dstWriter.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

