/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb;

import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.AcsLogger;
import alma.acs.logging.ClientLogManager;
import alma.acs.util.ACSPorts;
import alma.cdbErrType.CDBRecordDoesNotExistEx;
import alma.cdbErrType.CDBXMLErrorEx;
import alma.cdbErrType.wrappers.AcsJCDBRecordDoesNotExistEx;
import alma.cdbErrType.wrappers.AcsJCDBXMLErrorEx;
import com.cosylab.CDB.DAL;
import com.cosylab.CDB.DALHelper;
import com.cosylab.cdb.jdal.XMLHandler;
import com.cosylab.cdb.jdal.XMLTreeNode;
import java.io.StringReader;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class DALRead {
    static int indent = 0;

    public static void main(String[] args) {
        AcsLogger m_logger = ClientLogManager.getAcsLogManager().getLoggerForApplication("DALRead", false);
        try {
            java.lang.Object strIOR = null;
            boolean rawOutput = false;
            if (args.length < 1) {
                System.out.println("Usage: cmd curl [-d ior -raw -h]");
                return;
            }
            String curl = args[0];
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-d") && i < args.length - 1) {
                    strIOR = args[++i];
                }
                if (args[i].equals("-raw")) {
                    rawOutput = true;
                }
                if (!args[i].equals("-h")) continue;
                System.out.println("Usage: cmd curl [-d ior -raw -h]");
                return;
            }
            if (strIOR == null) {
                strIOR = "corbaloc::" + InetAddress.getLocalHost().getHostName() + ":" + ACSPorts.getCDBPort() + "/CDB";
            }
            ORB orb = ORB.init((String[])args, null);
            DAL dal = DALHelper.narrow((Object)orb.string_to_object((String)strIOR));
            String xml = dal.get_DAO(curl);
            if (rawOutput) {
                m_logger.log((Level)AcsLogLevel.INFO, "Curl data:\n" + xml);
                return;
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLHandler xmlSolver = new XMLHandler(false, (Logger)m_logger);
            saxParser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)xmlSolver);
            if (xmlSolver.m_errorString != null) {
                String info = "XML parser error: " + xmlSolver.m_errorString;
                AcsJCDBXMLErrorEx xmlErr = new AcsJCDBXMLErrorEx();
                System.err.println(info);
                throw xmlErr;
            }
            System.out.println("Env " + System.getProperty("HOMEPATH"));
            System.out.println("________________________________________________________");
            DALRead.walk(xmlSolver.m_rootNode);
            System.out.println("________________________________________________________");
        }
        catch (AcsJCDBXMLErrorEx e) {
            e.printStackTrace();
            e.log((Logger)m_logger);
        }
        catch (CDBXMLErrorEx e) {
            AcsJCDBXMLErrorEx je = AcsJCDBXMLErrorEx.fromCDBXMLErrorEx((CDBXMLErrorEx)e);
            String smsg = "XML Error \tCURL='" + je.getCurl() + "'\n\t\tFilename='" + je.getFilename() + "'\n\t\tNodename='" + je.getNodename() + "'\n\t\tMSG='" + je.getErrorString() + "'";
            je.log((Logger)m_logger);
            m_logger.log((Level)AcsLogLevel.NOTICE, smsg, je);
        }
        catch (CDBRecordDoesNotExistEx e) {
            AcsJCDBRecordDoesNotExistEx je = AcsJCDBRecordDoesNotExistEx.fromCDBRecordDoesNotExistEx((CDBRecordDoesNotExistEx)e);
            String smsg = "Record does not exist \tCURL='" + je.getCurl() + "'";
            je.log((Logger)m_logger);
            m_logger.log((Level)AcsLogLevel.NOTICE, smsg, (Throwable)je);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void walk(XMLTreeNode node) {
        Iterator<String> i = node.getFieldMap().keySet().iterator();
        if (i.hasNext()) {
            DALRead.outputIndentation(indent);
            System.out.print("Node " + node.getName());
            System.out.println();
        }
        while (i.hasNext()) {
            String key = i.next();
            String value = node.getFieldMap().get(key);
            System.out.print("    " + key + "=\"" + value + "\"");
            System.out.println();
        }
        ++indent;
        for (String key : node.getNodesMap().keySet()) {
            XMLTreeNode value = node.getNodesMap().get(key);
            DALRead.walk(value);
        }
        --indent;
    }

    private static void outputIndentation(int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("  ");
        }
    }
}

