/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.gui;

import alma.acs.commandcenter.gui.CommandCenterGui;
import alma.acs.commandcenter.gui.DeploymentTree;
import alma.acs.commandcenter.gui.thirdparty.SpringUtilities;
import alma.acs.commandcenter.util.MiscUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpringLayout;

class AddToDeployTree
extends JPanel {
    private final CommandCenterGui master;
    private final DeploymentTree deployTree;
    protected JPanel content;
    protected JPanel content2;
    protected JTextField addressF = new JTextField(10);

    public AddToDeployTree(CommandCenterGui gui, DeploymentTree deployTree) {
        this.master = gui;
        this.deployTree = deployTree;
        this.setLayout(new BorderLayout());
        this.content = new JPanel(new SpringLayout());
        this.add((Component)this.content, "West");
        JButton btnRefresh = new JButton(new ActionRefresh());
        this.content.add(btnRefresh);
        JToggleButton btnFreeze = new JToggleButton();
        this.content.add(btnFreeze);
        this.content.add(new JSeparator(1));
        this.content.add(new JButton(new ActionShowAdd()));
        SpringUtilities.makeCompactGrid(this.content, 0, 4);
        this.content2 = new JPanel();
        this.add((Component)this.content2, "South");
        this.content2.setVisible(false);
        JLabel lbl = new JLabel("Enter \"host:instance\", corbaloc, or IOR:");
        this.content2.add(lbl);
        this.content2.add(Box.createVerticalStrut(5));
        this.content2.add(this.addressF);
        JPanel temp = new JPanel();
        this.content2.add(temp);
        JButton btnAdd = new JButton(new ActionAdd());
        temp.add(btnAdd);
        temp.add(new JButton(new ActionCancelAdd()));
        this.content2.setLayout(new BoxLayout(this.content2, 3));
        for (Component c : this.content2.getComponents()) {
            ((JComponent)c).setAlignmentX(0.0f);
        }
        btnFreeze.setAction(new ActionFreeze(btnFreeze));
        btnFreeze.setSelected(deployTree.isViewFrozen());
        lbl.setLabelFor(this.addressF);
        lbl.setDisplayedMnemonic(77);
        this.addressF.setText("");
        btnAdd.setToolTipText("Add specified Manager to Deployment Info");
        btnRefresh.setToolTipText("Refresh all Managers in Deployment Info");
        btnFreeze.setToolTipText("Halt automatic Refresh of Deployment Info");
        btnAdd.setName("btn_Add_To_DeployTree");
        btnRefresh.setName("btn_Refresh_DeployTree");
        this.addressF.setName("txt_Add_Mgr_Host");
    }

    protected void setBusy(boolean b) {
        int cursor = b ? 3 : 0;
        this.setCursor(Cursor.getPredefinedCursor(cursor));
    }

    protected class ActionRefresh
    extends MyActionBaseClass {
        public ActionRefresh() {
            super("Refresh");
        }

        @Override
        protected void myActionPerformed() throws Throwable {
            boolean isViewFrozen = AddToDeployTree.this.deployTree.isViewFrozen;
            if (isViewFrozen) {
                AddToDeployTree.this.deployTree.isViewFrozen = false;
            }
            try {
                AddToDeployTree.this.deployTree.refreshManagers();
            }
            finally {
                if (isViewFrozen) {
                    AddToDeployTree.this.deployTree.isViewFrozen = true;
                }
            }
        }
    }

    protected class ActionShowAdd
    extends MyActionBaseClass {
        public ActionShowAdd() {
            super("Add...");
            super.putValue("ShortDescription", "Manually add a Manager to Deployment Info");
        }

        @Override
        protected void myActionPerformed() throws Throwable {
            AddToDeployTree.this.content.setVisible(false);
            AddToDeployTree.this.content2.setVisible(true);
        }
    }

    protected class ActionAdd
    extends MyActionBaseClass {
        public ActionAdd() {
            super("Add to View");
        }

        @Override
        protected void myActionPerformed() throws Throwable {
            String host;
            String input = AddToDeployTree.this.addressF.getText().trim();
            if (input == null || "".equals(input)) {
                JOptionPane.showMessageDialog(AddToDeployTree.this, "Please enter the network address of an Acs Manager");
                return;
            }
            if (input.length() > 4 && input.substring(0, 4).equalsIgnoreCase("IOR:")) {
                host = input;
            } else if (input.length() > 9 && input.substring(0, 9).equalsIgnoreCase("corbaloc:")) {
                host = input;
            } else {
                String quick = MiscUtils.convertShortNotationToCorbaloc(input);
                if (quick != null) {
                    host = quick;
                } else {
                    JOptionPane.showMessageDialog(AddToDeployTree.this, "Cannot parse your input, please use a supported address format");
                    return;
                }
            }
            AddToDeployTree.this.content2.setVisible(false);
            AddToDeployTree.this.content.setVisible(true);
            AddToDeployTree.this.deployTree.shieldedAddManager(host);
        }
    }

    protected class ActionCancelAdd
    extends MyActionBaseClass {
        public ActionCancelAdd() {
            super("Cancel");
        }

        @Override
        protected void myActionPerformed() throws Throwable {
            AddToDeployTree.this.content2.setVisible(false);
            AddToDeployTree.this.content.setVisible(true);
        }
    }

    protected class ActionFreeze
    extends MyActionBaseClass {
        protected JToggleButton btn;

        public ActionFreeze(JToggleButton btn) {
            super("Freeze");
            this.btn = btn;
        }

        @Override
        protected void myActionPerformed() throws Throwable {
            boolean b = this.btn.isSelected();
            AddToDeployTree.this.deployTree.setViewFrozen(b);
        }
    }

    protected abstract class MyActionBaseClass
    extends CommandCenterGui.BackgroundAction {
        public MyActionBaseClass(String name) {
            CommandCenterGui commandCenterGui = AddToDeployTree.this.master;
            Objects.requireNonNull(commandCenterGui);
            super(commandCenterGui, name);
        }

        @Override
        protected final void actionPerformed() throws Throwable {
            AddToDeployTree.this.setBusy(true);
            AddToDeployTree.this.deployTree.setBusy(true);
            try {
                this.myActionPerformed();
            }
            finally {
                AddToDeployTree.this.setBusy(false);
                AddToDeployTree.this.deployTree.setBusy(false);
            }
        }

        protected abstract void myActionPerformed() throws Throwable;
    }
}

