/*
 * Decompiled with CFR 0.152.
 */
package alma.tools.entitybuilder.jaxb;

import alma.tools.entitybuilder.BindingException;
import alma.tools.entitybuilder.XsdFileFinder;
import alma.tools.entitybuilder.jaxb.EntitybuilderConfig;
import alma.tools.entitybuilder.jaxb.generated.catalog.Catalog;
import alma.tools.entitybuilder.jaxb.generated.catalog.System;
import com.sun.codemodel.JCodeModel;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.addon.episode.PluginImpl;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.XJC;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XjcBuilder {
    File schemaDir;
    File primaryConfigFile;
    ArrayList<String> otherConfigFileNames;
    ArrayList<File> includeDirs;
    File javaOutputDir;

    public static void main(String[] args) {
        if (args.length < 2) {
            java.lang.System.out.println("usage: java " + XjcBuilder.class.getName() + " configFile javaOutputDir [-I schemaIncludeDir]");
            java.lang.System.exit(1);
        }
        try {
            String configFileConcat = java.lang.System.getProperty("ACS.schemaconfigfiles");
            XjcBuilder builder = new XjcBuilder();
            builder.init(args, configFileConcat);
            builder.run();
        }
        catch (Exception ex) {
            java.lang.System.err.println("schema compilation failed!");
            ex.printStackTrace(java.lang.System.err);
            java.lang.System.exit(1);
        }
    }

    public void init(String[] args, String configFileConcat) throws BindingException, FileNotFoundException {
        this.primaryConfigFile = new File(args[0]);
        this.schemaDir = this.primaryConfigFile.getParentFile();
        this.javaOutputDir = new File(args[1]);
        this.otherConfigFileNames = new ArrayList();
        if (configFileConcat != null) {
            StringTokenizer includeSchemasConfigFilesTok = new StringTokenizer(configFileConcat, " ");
            while (includeSchemasConfigFilesTok.hasMoreTokens()) {
                Object configFileName = includeSchemasConfigFilesTok.nextToken().trim();
                if (((String)configFileName).length() <= 0) continue;
                if (!((String)configFileName).endsWith(".xml")) {
                    configFileName = (String)configFileName + ".xml";
                }
                this.otherConfigFileNames.add((String)configFileName);
            }
        }
        this.includeDirs = new ArrayList();
        boolean pendingInclude = false;
        for (int argInd = 2; argInd < args.length; ++argInd) {
            String arg = args[argInd].trim();
            arg = arg.charAt(0) == '\"' ? arg.substring(1) : arg;
            String string = arg = arg.charAt(arg.length() - 1) == '\"' ? arg.substring(0, arg.length() - 1) : arg;
            if (pendingInclude) {
                this.includeDirs.add(new File(arg));
                pendingInclude = false;
                continue;
            }
            if (!arg.startsWith("-I")) continue;
            if (arg.length() == 2) {
                pendingInclude = true;
                continue;
            }
            this.includeDirs.add(new File(arg.substring(2)));
            pendingInclude = false;
        }
    }

    public void run() throws BindingException, FileNotFoundException {
        if (!this.primaryConfigFile.exists()) {
            throw new FileNotFoundException("invalid configuration file: " + this.primaryConfigFile.getAbsolutePath());
        }
        ArrayList<String> allConfigFileNames = new ArrayList<String>();
        allConfigFileNames.add(this.primaryConfigFile.getName());
        allConfigFileNames.addAll(this.otherConfigFileNames);
        ArrayList<File> allIncludeDirs = new ArrayList<File>();
        allIncludeDirs.add(this.schemaDir);
        allIncludeDirs.add(this.primaryConfigFile.getParentFile());
        allIncludeDirs.addAll(this.includeDirs);
        if (!this.javaOutputDir.exists()) {
            java.lang.System.out.println("will create output directory " + this.javaOutputDir.getAbsolutePath());
        }
        XsdFileFinder xsdFileFinder = new XsdFileFinder(allIncludeDirs, allConfigFileNames);
        xsdFileFinder.setVerbose(false);
        EntitybuilderConfig ebc = new EntitybuilderConfig();
        ebc.load(this.primaryConfigFile, xsdFileFinder.getAllXsdConfigFiles());
        File xjb = new File(this.primaryConfigFile.getAbsolutePath().replace(".xml", ".xjb"));
        ebc.writeXjb(xjb);
        SchemaCompiler sc = XJC.createSchemaCompiler();
        AlmaEntityResolver almaEntityResolver = new AlmaEntityResolver(ebc);
        sc.setEntityResolver((EntityResolver)almaEntityResolver);
        sc.setErrorListener(new ErrorListener(){

            public void error(SAXParseException ex) {
                ex.printStackTrace();
            }

            public void fatalError(SAXParseException ex) {
                ex.printStackTrace();
            }

            public void warning(SAXParseException ex) {
                ex.printStackTrace();
            }

            public void info(SAXParseException ex) {
                ex.printStackTrace();
            }
        });
        sc.getOptions().packageLevelAnnotations = false;
        Options options = sc.getOptions();
        sc.getOptions();
        options.compatibilityMode = 2;
        sc.getOptions().addBindFile(new File(this.primaryConfigFile.getAbsolutePath().replace(".xml", ".xjb")));
        for (File config : xsdFileFinder.getAllXsdConfigFiles()) {
            File episode;
            if (config.getName().equals(this.primaryConfigFile.getName()) || !(episode = new File(config.getAbsolutePath().replace(".xml", ".episode"))).exists() || !episode.isFile()) continue;
            sc.getOptions().addBindFile(episode);
        }
        try {
            File cat = new File(this.primaryConfigFile.getAbsolutePath().replace(".xml", ".cat"));
            Catalog c = new Catalog();
            for (File schemaFile : ebc.getAllSchemaFiles()) {
                String introot;
                System s = new System();
                s.setSystemId(schemaFile.getName());
                s.setUri(schemaFile.getAbsolutePath());
                c.getPublicsAndSystemsAndUris().add(s);
                s = new System();
                s.setSystemId("file:/" + schemaFile.getName());
                s.setUri(schemaFile.getAbsolutePath());
                c.getPublicsAndSystemsAndUris().add(s);
                s = new System();
                s.setSystemId("file:" + new File(java.lang.System.getProperty("user.dir")).getAbsolutePath() + "/" + schemaFile.getName());
                s.setUri(schemaFile.getAbsolutePath());
                c.getPublicsAndSystemsAndUris().add(s);
                s = new System();
                s.setSystemId("file:" + new File(java.lang.System.getProperty("user.dir")).getParentFile().getAbsolutePath() + "/idl/" + schemaFile.getName());
                s.setUri(schemaFile.getAbsolutePath());
                c.getPublicsAndSystemsAndUris().add(s);
                s = new System();
                s.setSystemId("file:" + schemaFile.getAbsolutePath());
                s.setUri(schemaFile.getAbsolutePath());
                c.getPublicsAndSystemsAndUris().add(s);
                String intlist = java.lang.System.getenv("INTLIST");
                if (intlist != null) {
                    for (String introot2 : intlist.split(":")) {
                        s = new System();
                        s.setSystemId("file:" + new File(introot2).getAbsolutePath() + "/idl/" + schemaFile.getName());
                        s.setUri(schemaFile.getAbsolutePath());
                        c.getPublicsAndSystemsAndUris().add(s);
                    }
                }
                if ((introot = java.lang.System.getenv("INTROOT")) == null) continue;
                s = new System();
                s.setSystemId("file:" + new File(introot).getAbsolutePath() + "/idl/" + schemaFile.getName());
                s.setUri(schemaFile.getAbsolutePath());
                c.getPublicsAndSystemsAndUris().add(s);
            }
            Marshaller m = JAXBContext.newInstance((Class[])new Class[]{Catalog.class}).createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)c, cat);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        PluginImpl plugin = new PluginImpl();
        sc.getOptions().getAllPlugins().add(plugin);
        try {
            sc.getOptions().parseArgument(new String[]{"-" + plugin.getOptionName(), this.primaryConfigFile.getAbsolutePath().replace(".xml", ".episode")}, 0);
            sc.getOptions().parseArgument(new String[]{"-catalog", this.primaryConfigFile.getAbsolutePath().replace(".xml", ".cat")}, 0);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        sc.setEntityResolver(sc.getOptions().entityResolver);
        for (File schemaFile : ebc.getAllSchemaFiles()) {
            if (!schemaFile.exists() || !schemaFile.isFile()) {
                throw new FileNotFoundException("unable to open XML schema file " + schemaFile.getAbsolutePath());
            }
            String schemaPackage = ebc.getJPackageForSchema(schemaFile.getName());
            java.lang.System.out.println("\n-- generating classes for " + schemaFile.getAbsolutePath() + " into " + schemaPackage + " --");
            InputSource is = new InputSource(new FileInputStream(schemaFile));
            is.setSystemId("file:/" + schemaFile.getName());
            is.setPublicId(ebc.getSchemaName2Namespace().get(schemaFile.getName()));
            sc.parseSchema(is);
        }
        this.generate(sc, this.javaOutputDir);
        java.lang.System.out.println("schema compile done!\n");
    }

    private void generate(SchemaCompiler sc, File outputDir) throws FileNotFoundException {
        S2JJAXBModel model = sc.bind();
        JCodeModel jmodel = model.generateCode(null, null);
        try {
            jmodel.build(outputDir);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    class AlmaEntityResolver
    implements EntityResolver {
        EntitybuilderConfig ebc = null;

        public AlmaEntityResolver(EntitybuilderConfig ebc) {
            this.ebc = ebc;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            String schemaName = new File(systemId).getName();
            File schema = this.ebc.getSchemaName2File().get(schemaName);
            String ns = this.ebc.getSchemaName2Namespace().get(schemaName);
            InputSource is = null;
            if (schema != null) {
                is = new InputSource(new FileInputStream(schema.getAbsolutePath()));
                is.setSystemId(schema.toURI().normalize().toString());
                is.setSystemId("file:/" + schema.getName());
                is.setPublicId(ns);
            }
            return is;
        }
    }
}

