/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.ukatc.xsltchain;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import uk.ac.roe.ukatc.xsltchain.ChainTranslatorException;

public class ChainTranslator {
    public List<XMLFilter> FilterChain;
    XMLReader reader;
    SAXTransformerFactory stf;
    SAXParser parser;

    public ChainTranslator(TransformerFactory tfactory) throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        this.parser = spf.newSAXParser();
        this.reader = this.parser.getXMLReader();
        this.stf = (SAXTransformerFactory)TransformerFactory.newInstance();
        this.FilterChain = new ArrayList<XMLFilter>();
    }

    public ChainTranslator() throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        this.parser = spf.newSAXParser();
        this.reader = this.parser.getXMLReader();
        this.stf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        this.FilterChain = new ArrayList<XMLFilter>();
    }

    public void AddFilter(URL url) throws TransformerConfigurationException, IOException {
        InputStream is = url.openStream();
        XMLFilter xf = this.stf.newXMLFilter(new StreamSource(is));
        if (xf == null) {
            throw new ChainTranslatorException("Non valid XML filter input");
        }
        if (this.FilterChain.size() > 0) {
            int prior = this.FilterChain.size() - 1;
            XMLFilter previous = this.FilterChain.get(prior);
            xf.setParent(previous);
        } else {
            xf.setParent(this.reader);
        }
        this.FilterChain.add(xf);
    }

    public void AddFilters(URL[] is) throws TransformerConfigurationException, IOException {
        int i = 0;
        while (i < is.length) {
            this.AddFilter(is[i]);
            ++i;
        }
    }

    public void AddFilter(InputStream is) throws TransformerConfigurationException {
        XMLFilter xf = this.stf.newXMLFilter(new StreamSource(is));
        if (xf == null) {
            throw new ChainTranslatorException("Non valid XML filter input");
        }
        if (this.FilterChain.size() > 0) {
            int prior = this.FilterChain.size() - 1;
            XMLFilter previous = this.FilterChain.get(prior);
            xf.setParent(previous);
        } else {
            xf.setParent(this.reader);
        }
        this.FilterChain.add(xf);
    }

    public void AddFilters(InputStream[] is) throws TransformerConfigurationException {
        int i = 0;
        while (i < is.length) {
            this.AddFilter(is[i]);
            ++i;
        }
    }

    public void AddFilter(File Xslt) throws TransformerConfigurationException {
        XMLFilter xf = this.stf.newXMLFilter(new StreamSource(Xslt));
        if (this.FilterChain.size() > 0) {
            int prior = this.FilterChain.size() - 1;
            XMLFilter previous = this.FilterChain.get(prior);
            xf.setParent(previous);
        } else {
            xf.setParent(this.reader);
        }
        this.FilterChain.add(xf);
    }

    public void AddFilters(File[] Xslt) throws TransformerConfigurationException {
        int i = 0;
        while (i < Xslt.length) {
            this.AddFilter(Xslt[i]);
            ++i;
        }
    }

    public XMLFilter GetLastFilter() {
        return this.FilterChain.get(this.FilterChain.size() - 1);
    }

    public String GetFilterInfo(int i) {
        XMLFilter xmlf = this.FilterChain.get(i);
        return xmlf.toString();
    }

    public int GetNFilters() {
        return this.FilterChain.size();
    }

    public void reset() {
        this.FilterChain.clear();
    }

    public void Convert(InputStream in, File out) throws FileNotFoundException, TransformerException {
        StreamResult result = new StreamResult(out);
        InputSource input = new InputSource(new BufferedInputStream(in));
        Transformer transformer = this.stf.newTransformer();
        SAXSource transformSource = new SAXSource(this.GetLastFilter(), input);
        transformer.transform(transformSource, result);
    }

    public void Convert(InputStream in, OutputStream out) throws FileNotFoundException, TransformerException {
        InputSource input = new InputSource(new BufferedInputStream(in));
        StreamResult result = new StreamResult(out);
        Transformer transformer = this.stf.newTransformer();
        SAXSource transformSource = new SAXSource(this.GetLastFilter(), input);
        transformer.transform(transformSource, result);
    }

    public void Convert(InputSource in, StreamResult out) throws FileNotFoundException, TransformerException {
        Transformer transformer = this.stf.newTransformer();
        SAXSource transformSource = new SAXSource(this.GetLastFilter(), in);
        transformer.transform(transformSource, out);
    }

    public void Convert(File FileInput, File FileOutput) throws FileNotFoundException, TransformerException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(FileInput));
        InputSource input = new InputSource(bis);
        StreamResult result = new StreamResult(FileOutput);
        Transformer transformer = this.stf.newTransformer();
        SAXSource transformSource = new SAXSource(this.GetLastFilter(), input);
        transformer.transform(transformSource, result);
    }

    public void Convert(File FileInput) throws FileNotFoundException, TransformerException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(FileInput));
        InputSource input = new InputSource(bis);
        StreamResult result = new StreamResult(System.out);
        Transformer transformer = this.stf.newTransformer();
        SAXSource transformSource = new SAXSource(this.GetLastFilter(), input);
        transformer.transform(transformSource, result);
    }
}

