/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.ukatc.xsltchain;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import uk.ac.roe.ukatc.xsltchain.UGraph;

public class VersionTable {
    private UGraph graph = new UGraph();

    VersionTable(File fin) {
        try {
            String line;
            FileReader fr = new FileReader(fin);
            BufferedReader graphFile = new BufferedReader(fr);
            while ((line = graphFile.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                try {
                    if (st.countTokens() != 3) {
                        System.err.println("Skipping ill-formatted line " + line);
                        continue;
                    }
                    String source = st.nextToken();
                    String dest = st.nextToken();
                    String data = st.nextToken();
                    this.graph.addEdge(source, dest, data);
                }
                catch (NumberFormatException e) {
                    System.err.println("Skipping ill-formatted line " + line);
                }
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    List getTransformList(String in_ver, String out_ver) {
        return this.graph.getShortestPath(in_ver, out_ver);
    }

    int getNVertex() {
        return this.graph.vertexMap.size();
    }
}

