/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import nom.tam.util.PrimitiveInfo;

public class ArrayFuncs
implements PrimitiveInfo {
    public static int computeSize(Object o) {
        if (o == null) {
            return 0;
        }
        int size = 0;
        String classname = o.getClass().getName();
        if (classname.substring(0, 2).equals("[[")) {
            for (int i = 0; i < ((Object[])o).length; ++i) {
                size += ArrayFuncs.computeSize(((Object[])o)[i]);
            }
            return size;
        }
        if (classname.charAt(0) == '[' && classname.charAt(1) != 'L') {
            char c = classname.charAt(1);
            for (int i = 0; i < PrimitiveInfo.suffixes.length; ++i) {
                if (c != PrimitiveInfo.suffixes[i]) continue;
                return Array.getLength(o) * PrimitiveInfo.sizes[i];
            }
            return 0;
        }
        if (classname.charAt(0) == '[') {
            int len = 0;
            for (int i = 0; i < Array.getLength(o); ++i) {
                len += ArrayFuncs.computeSize(Array.get(o, i));
            }
            return len;
        }
        if (classname.substring(0, 10).equals("java.lang.")) {
            if ((classname = classname.substring(10, classname.length())).equals("Integer") || classname.equals("Float")) {
                return 4;
            }
            if (classname.equals("Double") || classname.equals("Long")) {
                return 8;
            }
            if (classname.equals("Short") || classname.equals("Char")) {
                return 2;
            }
            if (classname.equals("Byte") || classname.equals("Boolean")) {
                return 1;
            }
            if (classname.equals("String")) {
                return ((String)o).length();
            }
            return 0;
        }
        return 0;
    }

    public static int nElements(Object o) {
        if (o == null) {
            return 0;
        }
        String classname = o.getClass().getName();
        if (classname.charAt(1) == '[') {
            int count = 0;
            for (int i = 0; i < ((Object[])o).length; ++i) {
                count += ArrayFuncs.nElements(((Object[])o)[i]);
            }
            return count;
        }
        if (classname.charAt(0) == '[') {
            return Array.getLength(o);
        }
        return 1;
    }

    public static Object deepClone(Object o) {
        Class<?> baseClass;
        if (o == null) {
            return null;
        }
        String classname = o.getClass().getName();
        if (classname.charAt(0) != '[') {
            return ArrayFuncs.genericClone(o);
        }
        if (classname.charAt(1) != '[' && classname.charAt(1) != 'L') {
            try {
                switch (classname.charAt(1)) {
                    case 'B': {
                        return ((byte[])o).clone();
                    }
                    case 'Z': {
                        return ((boolean[])o).clone();
                    }
                    case 'C': {
                        return ((char[])o).clone();
                    }
                    case 'S': {
                        return ((short[])o).clone();
                    }
                    case 'I': {
                        return ((int[])o).clone();
                    }
                    case 'J': {
                        return ((long[])o).clone();
                    }
                    case 'F': {
                        return ((float[])o).clone();
                    }
                    case 'D': {
                        return ((double[])o).clone();
                    }
                }
                System.err.println("Unknown primtive array class:" + classname);
                return null;
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
        }
        int ndim = 1;
        while (classname.charAt(ndim) == '[') {
            ++ndim;
        }
        if (classname.charAt(ndim) != 'L') {
            baseClass = ArrayFuncs.getBaseClass(o);
        } else {
            try {
                baseClass = Class.forName(classname.substring(ndim + 1, classname.length() - 1));
            }
            catch (ClassNotFoundException e) {
                System.err.println("Internal error: class definition inconsistency: " + classname);
                return null;
            }
        }
        int[] dims = new int[ndim];
        dims[0] = Array.getLength(o);
        for (int i = 1; i < ndim; ++i) {
            dims[i] = 0;
        }
        Object copy = ArrayFuncs.newInstance(baseClass, dims);
        for (int i = 0; i < dims[0]; ++i) {
            Array.set(copy, i, ArrayFuncs.deepClone(Array.get(o, i)));
        }
        return copy;
    }

    public static Object genericClone(Object o) {
        if (!(o instanceof Cloneable)) {
            return null;
        }
        Class[] argTypes = new Class[]{};
        Object[] args = new Object[]{};
        Class<?> type = o.getClass();
        try {
            return type.getMethod("clone", argTypes).invoke(o, args);
        }
        catch (Exception e) {
            if (type.isArray()) {
                return ArrayFuncs.deepClone(o);
            }
            return null;
        }
    }

    public static void copyArray(Object original, Object copy) {
        String cname;
        String oname = original.getClass().getName();
        if (!oname.equals(cname = copy.getClass().getName())) {
            return;
        }
        if (oname.charAt(0) != '[') {
            return;
        }
        if (oname.charAt(1) == '[') {
            Object[] x = (Object[])original;
            Object[] y = (Object[])copy;
            if (x.length != y.length) {
                return;
            }
            for (int i = 0; i < x.length; ++i) {
                ArrayFuncs.copyArray(x, y);
            }
        }
        int len = Array.getLength(original);
        System.arraycopy(original, 0, copy, 0, len);
    }

    public static int[] getDimensions(Object o) {
        int i;
        if (o == null) {
            return null;
        }
        String classname = o.getClass().getName();
        int ndim = 0;
        while (classname.charAt(ndim) == '[') {
            ++ndim;
        }
        int[] dimens = new int[ndim];
        for (i = 0; i < ndim; ++i) {
            dimens[i] = -1;
        }
        for (i = 0; i < ndim; ++i) {
            dimens[i] = Array.getLength(o);
            if (dimens[i] == 0) {
                return dimens;
            }
            if (i == ndim - 1 || (o = ((Object[])o)[0]) != null) continue;
            return dimens;
        }
        return dimens;
    }

    public static Object getBaseArray(Object o) {
        String cname = o.getClass().getName();
        if (cname.charAt(1) == '[') {
            return ArrayFuncs.getBaseArray(((Object[])o)[0]);
        }
        return o;
    }

    public static Class getBaseClass(Object o) {
        if (o == null) {
            return Void.TYPE;
        }
        String className = o.getClass().getName();
        int dims = 0;
        while (className.charAt(dims) == '[') {
            ++dims;
        }
        if (dims == 0) {
            return o.getClass();
        }
        char c = className.charAt(dims);
        for (int i = 0; i < PrimitiveInfo.suffixes.length; ++i) {
            if (c != PrimitiveInfo.suffixes[i]) continue;
            return PrimitiveInfo.classes[i];
        }
        if (c == 'L') {
            try {
                return Class.forName(className.substring(dims + 1, className.length() - 1));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public static int getBaseLength(Object o) {
        if (o == null) {
            return 0;
        }
        String className = o.getClass().getName();
        int dims = 0;
        while (className.charAt(dims) == '[') {
            ++dims;
        }
        if (dims == 0) {
            return -1;
        }
        char c = className.charAt(dims);
        for (int i = 0; i < PrimitiveInfo.suffixes.length; ++i) {
            if (c != PrimitiveInfo.suffixes[i]) continue;
            return PrimitiveInfo.sizes[i];
        }
        return -1;
    }

    public static Object generateArray(Class baseType, int[] dims) {
        Object x = ArrayFuncs.newInstance(baseType, dims);
        ArrayFuncs.testPattern(x, (byte)0);
        return x;
    }

    public static byte testPattern(Object o, byte start) {
        block3: {
            int[] dims;
            block2: {
                dims = ArrayFuncs.getDimensions(o);
                if (dims.length <= 1) break block2;
                for (int i = 0; i < ((Object[])o).length; ++i) {
                    start = ArrayFuncs.testPattern(((Object[])o)[i], start);
                }
                break block3;
            }
            if (dims.length != 1) break block3;
            for (int i = 0; i < dims[0]; ++i) {
                Array.setByte(o, i, start);
                start = (byte)(start + 1);
            }
        }
        return start;
    }

    public static String arrayDescription(Object o) {
        int i;
        Class base = ArrayFuncs.getBaseClass(o);
        if (base == Void.TYPE) {
            return "NULL";
        }
        int[] dims = ArrayFuncs.getDimensions(o);
        StringBuffer desc = new StringBuffer();
        boolean found = false;
        for (i = 0; i < PrimitiveInfo.classes.length; ++i) {
            if (base != PrimitiveInfo.classes[i]) continue;
            found = true;
            desc.append(PrimitiveInfo.types[i]);
            break;
        }
        if (!found) {
            desc.append(base.getName());
        }
        if (dims != null) {
            desc.append("[");
            for (i = 0; i < dims.length; ++i) {
                desc.append("" + dims[i]);
                if (i >= dims.length - 1) continue;
                desc.append("][");
            }
            desc.append("]");
        }
        return new String(desc);
    }

    public static void examinePrimitiveArray(Object o) {
        String className = o.getClass().getName();
        if (className.substring(0, 2).equals("[[") || className.equals("[Ljava.lang.Object;")) {
            System.out.println("[");
            for (int i = 0; i < ((Object[])o).length; ++i) {
                ArrayFuncs.examinePrimitiveArray(((Object[])o)[i]);
            }
            System.out.print("]");
        } else if (className.charAt(0) != '[') {
            System.out.println(className);
        } else {
            System.out.println("[" + Array.getLength(o) + "]" + className.substring(1));
        }
    }

    public static Object flatten(Object input) {
        int[] dimens = ArrayFuncs.getDimensions(input);
        if (dimens.length <= 1) {
            return input;
        }
        int size = 1;
        for (int i = 0; i < dimens.length; ++i) {
            size *= dimens[i];
        }
        Object flat = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(input), size);
        if (size == 0) {
            return flat;
        }
        int offset = 0;
        ArrayFuncs.doFlatten(input, flat, offset);
        return flat;
    }

    protected static int doFlatten(Object input, Object output, int offset) {
        String classname = input.getClass().getName();
        if (classname.charAt(0) != '[') {
            throw new RuntimeException("Attempt to flatten non-array");
        }
        int size = Array.getLength(input);
        if (classname.charAt(1) != '[') {
            System.arraycopy(input, 0, output, offset, size);
            return size;
        }
        int total = 0;
        Object[] xx = (Object[])input;
        for (int i = 0; i < size; ++i) {
            int len = ArrayFuncs.doFlatten(xx[i], output, offset + total);
            total += len;
        }
        return total;
    }

    public static Object curl(Object input, int[] dimens) {
        if (input == null) {
            return null;
        }
        String classname = input.getClass().getName();
        if (classname.charAt(0) != '[' || classname.charAt(1) == '[') {
            throw new RuntimeException("Attempt to curl non-1D array");
        }
        int size = Array.getLength(input);
        int test = 1;
        for (int i = 0; i < dimens.length; ++i) {
            test *= dimens[i];
        }
        if (test != size) {
            throw new RuntimeException("Curled array does not fit desired dimensions");
        }
        Class base = ArrayFuncs.getBaseClass(input);
        Object newArray = ArrayFuncs.newInstance(base, dimens);
        int offset = 0;
        ArrayFuncs.doCurl(input, newArray, dimens, offset);
        return newArray;
    }

    protected static int doCurl(Object input, Object output, int[] dimens, int offset) {
        int i;
        if (dimens.length == 1) {
            System.arraycopy(input, offset, output, 0, dimens[0]);
            return dimens[0];
        }
        int total = 0;
        int[] xdimens = new int[dimens.length - 1];
        for (i = 1; i < dimens.length; ++i) {
            xdimens[i - 1] = dimens[i];
        }
        for (i = 0; i < dimens[0]; ++i) {
            total += ArrayFuncs.doCurl(input, ((Object[])output)[i], xdimens, offset + total);
        }
        return total;
    }

    public static Object mimicArray(Object array, Class newType) {
        Object mimic;
        String classname = array.getClass().getName();
        if (classname.charAt(0) != '[') {
            return null;
        }
        int dims = 1;
        while (classname.charAt(dims) == '[') {
            ++dims;
        }
        if (dims > 1) {
            Object[] xarray = (Object[])array;
            int[] dimens = new int[dims];
            dimens[0] = xarray.length;
            mimic = ArrayFuncs.newInstance(newType, dimens);
            for (int i = 0; i < xarray.length; ++i) {
                Object temp;
                ((Object[])mimic)[i] = temp = ArrayFuncs.mimicArray(xarray[i], newType);
            }
        } else {
            mimic = ArrayFuncs.newInstance(newType, Array.getLength(array));
        }
        return mimic;
    }

    public static Object convertArray(Object array, Class newType, boolean reuse) {
        if (ArrayFuncs.getBaseClass(array) == newType && reuse) {
            return array;
        }
        return ArrayFuncs.convertArray(array, newType);
    }

    public static Object convertArray(Object array, Class newType) {
        Object mimic = ArrayFuncs.mimicArray(array, newType);
        if (mimic == null) {
            return mimic;
        }
        ArrayFuncs.copyInto(array, mimic);
        return mimic;
    }

    public static void copyInto(Object array, Object mimic) {
        String classname = array.getClass().getName();
        if (classname.charAt(0) != '[') {
            return;
        }
        if (classname.charAt(1) == '[') {
            for (int i = 0; i < ((Object[])array).length; ++i) {
                ArrayFuncs.copyInto(((Object[])array)[i], ((Object[])mimic)[i]);
            }
        } else {
            Class base = ArrayFuncs.getBaseClass(array);
            Class newType = ArrayFuncs.getBaseClass(mimic);
            if (base == Byte.TYPE) {
                byte[] barr = (byte[])array;
                if (newType == Byte.TYPE) {
                    System.arraycopy(array, 0, mimic, 0, barr.length);
                } else if (newType == Short.TYPE) {
                    short[] xsarr = (short[])mimic;
                    for (int i = 0; i < barr.length; ++i) {
                        xsarr[i] = barr[i];
                    }
                } else if (newType == Character.TYPE) {
                    char[] xcarr = (char[])mimic;
                    for (int i = 0; i < barr.length; ++i) {
                        xcarr[i] = (char)barr[i];
                    }
                } else if (newType == Integer.TYPE) {
                    int[] xiarr = (int[])mimic;
                    for (int i = 0; i < barr.length; ++i) {
                        xiarr[i] = barr[i];
                    }
                } else if (newType == Long.TYPE) {
                    long[] xlarr = (long[])mimic;
                    for (int i = 0; i < barr.length; ++i) {
                        xlarr[i] = barr[i];
                    }
                } else if (newType == Float.TYPE) {
                    float[] xfarr = (float[])mimic;
                    for (int i = 0; i < barr.length; ++i) {
                        xfarr[i] = barr[i];
                    }
                } else if (newType == Double.TYPE) {
                    double[] xdarr = (double[])mimic;
                    for (int i = 0; i < barr.length; ++i) {
                        xdarr[i] = barr[i];
                    }
                }
            } else if (base == Short.TYPE) {
                short[] sarr = (short[])array;
                if (newType == Byte.TYPE) {
                    byte[] xbarr = (byte[])mimic;
                    for (int i = 0; i < sarr.length; ++i) {
                        xbarr[i] = (byte)sarr[i];
                    }
                } else if (newType == Short.TYPE) {
                    System.arraycopy(array, 0, mimic, 0, sarr.length);
                } else if (newType == Character.TYPE) {
                    char[] xcarr = (char[])mimic;
                    for (int i = 0; i < sarr.length; ++i) {
                        xcarr[i] = (char)sarr[i];
                    }
                } else if (newType == Integer.TYPE) {
                    int[] xiarr = (int[])mimic;
                    for (int i = 0; i < sarr.length; ++i) {
                        xiarr[i] = sarr[i];
                    }
                } else if (newType == Long.TYPE) {
                    long[] xlarr = (long[])mimic;
                    for (int i = 0; i < sarr.length; ++i) {
                        xlarr[i] = sarr[i];
                    }
                } else if (newType == Float.TYPE) {
                    float[] xfarr = (float[])mimic;
                    for (int i = 0; i < sarr.length; ++i) {
                        xfarr[i] = sarr[i];
                    }
                } else if (newType == Double.TYPE) {
                    double[] xdarr = (double[])mimic;
                    for (int i = 0; i < sarr.length; ++i) {
                        xdarr[i] = sarr[i];
                    }
                }
            } else if (base == Character.TYPE) {
                char[] carr = (char[])array;
                if (newType == Byte.TYPE) {
                    byte[] xbarr = (byte[])mimic;
                    for (int i = 0; i < carr.length; ++i) {
                        xbarr[i] = (byte)carr[i];
                    }
                } else if (newType == Short.TYPE) {
                    short[] xsarr = (short[])mimic;
                    for (int i = 0; i < carr.length; ++i) {
                        xsarr[i] = (short)carr[i];
                    }
                } else if (newType == Character.TYPE) {
                    System.arraycopy(array, 0, mimic, 0, carr.length);
                } else if (newType == Integer.TYPE) {
                    int[] xiarr = (int[])mimic;
                    for (int i = 0; i < carr.length; ++i) {
                        xiarr[i] = carr[i];
                    }
                } else if (newType == Long.TYPE) {
                    long[] xlarr = (long[])mimic;
                    for (int i = 0; i < carr.length; ++i) {
                        xlarr[i] = carr[i];
                    }
                } else if (newType == Float.TYPE) {
                    float[] xfarr = (float[])mimic;
                    for (int i = 0; i < carr.length; ++i) {
                        xfarr[i] = carr[i];
                    }
                } else if (newType == Double.TYPE) {
                    double[] xdarr = (double[])mimic;
                    for (int i = 0; i < carr.length; ++i) {
                        xdarr[i] = carr[i];
                    }
                }
            } else if (base == Integer.TYPE) {
                int[] iarr = (int[])array;
                if (newType == Byte.TYPE) {
                    byte[] xbarr = (byte[])mimic;
                    for (int i = 0; i < iarr.length; ++i) {
                        xbarr[i] = (byte)iarr[i];
                    }
                } else if (newType == Short.TYPE) {
                    short[] xsarr = (short[])mimic;
                    for (int i = 0; i < iarr.length; ++i) {
                        xsarr[i] = (short)iarr[i];
                    }
                } else if (newType == Character.TYPE) {
                    char[] xcarr = (char[])mimic;
                    for (int i = 0; i < iarr.length; ++i) {
                        xcarr[i] = (char)iarr[i];
                    }
                } else if (newType == Integer.TYPE) {
                    System.arraycopy(array, 0, mimic, 0, iarr.length);
                } else if (newType == Long.TYPE) {
                    long[] xlarr = (long[])mimic;
                    for (int i = 0; i < iarr.length; ++i) {
                        xlarr[i] = iarr[i];
                    }
                } else if (newType == Float.TYPE) {
                    float[] xfarr = (float[])mimic;
                    for (int i = 0; i < iarr.length; ++i) {
                        xfarr[i] = iarr[i];
                    }
                } else if (newType == Double.TYPE) {
                    double[] xdarr = (double[])mimic;
                    for (int i = 0; i < iarr.length; ++i) {
                        xdarr[i] = iarr[i];
                    }
                }
            } else if (base == Long.TYPE) {
                long[] larr = (long[])array;
                if (newType == Byte.TYPE) {
                    byte[] xbarr = (byte[])mimic;
                    for (int i = 0; i < larr.length; ++i) {
                        xbarr[i] = (byte)larr[i];
                    }
                } else if (newType == Short.TYPE) {
                    short[] xsarr = (short[])mimic;
                    for (int i = 0; i < larr.length; ++i) {
                        xsarr[i] = (short)larr[i];
                    }
                } else if (newType == Character.TYPE) {
                    char[] xcarr = (char[])mimic;
                    for (int i = 0; i < larr.length; ++i) {
                        xcarr[i] = (char)larr[i];
                    }
                } else if (newType == Integer.TYPE) {
                    int[] xiarr = (int[])mimic;
                    for (int i = 0; i < larr.length; ++i) {
                        xiarr[i] = (int)larr[i];
                    }
                } else if (newType == Long.TYPE) {
                    System.arraycopy(array, 0, mimic, 0, larr.length);
                } else if (newType == Float.TYPE) {
                    float[] xfarr = (float[])mimic;
                    for (int i = 0; i < larr.length; ++i) {
                        xfarr[i] = larr[i];
                    }
                } else if (newType == Double.TYPE) {
                    double[] xdarr = (double[])mimic;
                    for (int i = 0; i < larr.length; ++i) {
                        xdarr[i] = larr[i];
                    }
                }
            } else if (base == Float.TYPE) {
                float[] farr = (float[])array;
                if (newType == Byte.TYPE) {
                    byte[] xbarr = (byte[])mimic;
                    for (int i = 0; i < farr.length; ++i) {
                        xbarr[i] = (byte)farr[i];
                    }
                } else if (newType == Short.TYPE) {
                    short[] xsarr = (short[])mimic;
                    for (int i = 0; i < farr.length; ++i) {
                        xsarr[i] = (short)farr[i];
                    }
                } else if (newType == Character.TYPE) {
                    char[] xcarr = (char[])mimic;
                    for (int i = 0; i < farr.length; ++i) {
                        xcarr[i] = (char)farr[i];
                    }
                } else if (newType == Integer.TYPE) {
                    int[] xiarr = (int[])mimic;
                    for (int i = 0; i < farr.length; ++i) {
                        xiarr[i] = (int)farr[i];
                    }
                } else if (newType == Long.TYPE) {
                    long[] xlarr = (long[])mimic;
                    for (int i = 0; i < farr.length; ++i) {
                        xlarr[i] = (long)farr[i];
                    }
                } else if (newType == Float.TYPE) {
                    System.arraycopy(array, 0, mimic, 0, farr.length);
                } else if (newType == Double.TYPE) {
                    double[] xdarr = (double[])mimic;
                    for (int i = 0; i < farr.length; ++i) {
                        xdarr[i] = farr[i];
                    }
                }
            } else if (base == Double.TYPE) {
                double[] darr = (double[])array;
                if (newType == Byte.TYPE) {
                    byte[] xbarr = (byte[])mimic;
                    for (int i = 0; i < darr.length; ++i) {
                        xbarr[i] = (byte)darr[i];
                    }
                } else if (newType == Short.TYPE) {
                    short[] xsarr = (short[])mimic;
                    for (int i = 0; i < darr.length; ++i) {
                        xsarr[i] = (short)darr[i];
                    }
                } else if (newType == Character.TYPE) {
                    char[] xcarr = (char[])mimic;
                    for (int i = 0; i < darr.length; ++i) {
                        xcarr[i] = (char)darr[i];
                    }
                } else if (newType == Integer.TYPE) {
                    int[] xiarr = (int[])mimic;
                    for (int i = 0; i < darr.length; ++i) {
                        xiarr[i] = (int)darr[i];
                    }
                } else if (newType == Long.TYPE) {
                    long[] xlarr = (long[])mimic;
                    for (int i = 0; i < darr.length; ++i) {
                        xlarr[i] = (long)darr[i];
                    }
                } else if (newType == Float.TYPE) {
                    float[] xfarr = (float[])mimic;
                    for (int i = 0; i < darr.length; ++i) {
                        xfarr[i] = (float)darr[i];
                    }
                } else if (newType == Double.TYPE) {
                    System.arraycopy(array, 0, mimic, 0, darr.length);
                }
            }
        }
    }

    public static Object newInstance(Class cl, int dim) {
        Object o = Array.newInstance(cl, dim);
        if (o == null) {
            String desc = cl + "[" + dim + "]";
            throw new OutOfMemoryError("Unable to allocate array: " + desc);
        }
        return o;
    }

    public static Object newInstance(Class cl, int[] dims) {
        Object o;
        if (dims.length == 0) {
            dims = new int[]{1};
        }
        if ((o = Array.newInstance(cl, dims)) == null) {
            String desc = cl + "[";
            String comma = "";
            for (int i = 0; i < dims.length; ++i) {
                desc = desc + comma + dims[i];
                comma = ",";
            }
            desc = desc + "]";
            throw new OutOfMemoryError("Unable to allocate array: " + desc);
        }
        return o;
    }

    public static boolean arrayEquals(Object x, Object y) {
        return ArrayFuncs.arrayEquals(x, y, 0.0, 0.0);
    }

    public static boolean arrayEquals(Object x, Object y, double tolf, double told) {
        Class<?> yClass;
        if (x == null && y == null) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        Class<?> xClass = x.getClass();
        if (xClass != (yClass = y.getClass())) {
            return false;
        }
        if (!xClass.isArray()) {
            return x.equals(y);
        }
        if (xClass.equals(int[].class)) {
            return Arrays.equals((int[])x, (int[])y);
        }
        if (xClass.equals(double[].class)) {
            if (told == 0.0) {
                return Arrays.equals((double[])x, (double[])y);
            }
            return ArrayFuncs.doubleArrayEquals((double[])x, (double[])y, told);
        }
        if (xClass.equals(long[].class)) {
            return Arrays.equals((long[])x, (long[])y);
        }
        if (xClass.equals(float[].class)) {
            if (tolf == 0.0) {
                return Arrays.equals((float[])x, (float[])y);
            }
            return ArrayFuncs.floatArrayEquals((float[])x, (float[])y, (float)tolf);
        }
        if (xClass.equals(byte[].class)) {
            return Arrays.equals((byte[])x, (byte[])y);
        }
        if (xClass.equals(short[].class)) {
            return Arrays.equals((short[])x, (short[])y);
        }
        if (xClass.equals(char[].class)) {
            return Arrays.equals((char[])x, (char[])y);
        }
        if (xClass.equals(boolean[].class)) {
            return Arrays.equals((boolean[])x, (boolean[])y);
        }
        Object[] xo = (Object[])x;
        Object[] yo = (Object[])y;
        if (xo.length != yo.length) {
            return false;
        }
        for (int i = 0; i < xo.length; ++i) {
            if (ArrayFuncs.arrayEquals(xo[i], yo[i], tolf, told)) continue;
            return false;
        }
        return true;
    }

    public static boolean doubleArrayEquals(double[] x, double[] y, double tol) {
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == 0.0) {
                return y[i] == 0.0;
            }
            if (!(Math.abs((y[i] - x[i]) / x[i]) > tol)) continue;
            return false;
        }
        return true;
    }

    public static boolean floatArrayEquals(float[] x, float[] y, float tol) {
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == 0.0f) {
                return y[i] == 0.0f;
            }
            if (!(Math.abs((y[i] - x[i]) / x[i]) > tol)) continue;
            return false;
        }
        return true;
    }
}

