/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging;

import alma.acs.logging.level.AcsLogLevelDefinition;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;

public class AcsLogLevel
extends Level
implements Comparable<AcsLogLevel> {
    private static final String ACS_BUNDLE_NAME = AcsLogLevel.class.getPackage().getName();
    private static final TreeSet<AcsLogLevel> known = new TreeSet();
    private static final Map<Level, AcsLogLevel> lookup = new HashMap<Level, AcsLogLevel>();
    public static final AcsLogLevel TRACE = new AcsLogLevel("TRACE", Level.FINEST.intValue(), AcsLogLevelDefinition.TRACE);
    public static final AcsLogLevel DELOUSE = new AcsLogLevel("DELOUSE", Level.FINER.intValue(), AcsLogLevelDefinition.DELOUSE);
    public static final AcsLogLevel DEBUG = new AcsLogLevel("DEBUG", Level.CONFIG.intValue(), AcsLogLevelDefinition.DEBUG);
    public static final AcsLogLevel INFO = new AcsLogLevel("INFO", Level.INFO.intValue(), AcsLogLevelDefinition.INFO);
    public static final AcsLogLevel NOTICE = new AcsLogLevel("NOTICE", 801, AcsLogLevelDefinition.NOTICE);
    public static final AcsLogLevel WARNING = new AcsLogLevel("WARNING", Level.WARNING.intValue(), AcsLogLevelDefinition.WARNING);
    public static final AcsLogLevel ERROR = new AcsLogLevel("ERROR", 901, AcsLogLevelDefinition.ERROR);
    public static final AcsLogLevel CRITICAL = new AcsLogLevel("CRITICAL", 902, AcsLogLevelDefinition.CRITICAL);
    public static final AcsLogLevel ALERT = new AcsLogLevel("ALERT", 903, AcsLogLevelDefinition.ALERT);
    public static final AcsLogLevel EMERGENCY = new AcsLogLevel("EMERGENCY", Level.SEVERE.intValue(), AcsLogLevelDefinition.EMERGENCY);
    public static final AcsLogLevel OFF = new AcsLogLevel(Level.OFF.getName(), Level.OFF.intValue(), AcsLogLevelDefinition.OFF);
    private final AcsLogLevelDefinition acsCoreLevel;
    private String entryName = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AcsLogLevel(String name, int value, AcsLogLevelDefinition acsCoreLevel) {
        super(name, value, ACS_BUNDLE_NAME);
        this.entryName = name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
        this.acsCoreLevel = acsCoreLevel;
        Object object = known;
        synchronized (object) {
            known.add(this);
        }
        object = lookup;
        synchronized (object) {
            lookup.put(this, this);
        }
    }

    public static AcsLogLevel fromAcsCoreLevel(AcsLogLevelDefinition acsCoreLevel) {
        AcsLogLevel acsLogLevel;
        AcsLogLevel ret = null;
        Iterator<AcsLogLevel> iterator = known.iterator();
        while (iterator.hasNext() && (ret = (acsLogLevel = iterator.next())).getAcsLevel().compareTo(acsCoreLevel) < 0) {
        }
        return ret;
    }

    public static Level getLowestMatchingJdkLevel(AcsLogLevelDefinition acsCoreLevel) {
        switch (acsCoreLevel) {
            case TRACE: {
                return TRACE;
            }
            case DELOUSE: {
                return DELOUSE;
            }
            case DEBUG: {
                return Level.FINE;
            }
            case INFO: {
                return INFO;
            }
            case NOTICE: {
                return NOTICE;
            }
            case WARNING: {
                return WARNING;
            }
            case ERROR: {
                return ERROR;
            }
            case CRITICAL: {
                return CRITICAL;
            }
            case ALERT: {
                return ALERT;
            }
            case EMERGENCY: {
                return EMERGENCY;
            }
            case OFF: {
                return OFF;
            }
        }
        throw new IllegalArgumentException("Unexpected enum literal AcsLogLevelDefinition." + acsCoreLevel.name);
    }

    public AcsLogLevelDefinition getAcsLevel() {
        return this.acsCoreLevel;
    }

    public String getEntryName() {
        return this.entryName;
    }

    @Override
    public int compareTo(AcsLogLevel l) {
        if (this.intValue() < l.intValue()) {
            return -1;
        }
        if (this.intValue() == l.intValue()) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AcsLogLevel getNativeLevel(Level level) {
        AcsLogLevel luLevel = null;
        Object object = lookup;
        synchronized (object) {
            luLevel = lookup.get(level);
        }
        if (luLevel != null) {
            return luLevel;
        }
        if (known.size() == 0 || level.intValue() == Level.OFF.intValue()) {
            return null;
        }
        object = known;
        synchronized (object) {
            Iterator<AcsLogLevel> iter = known.iterator();
            AcsLogLevel acsLevel = iter.next();
            while (level.intValue() > acsLevel.intValue() && iter.hasNext()) {
                acsLevel = iter.next();
            }
            Map<Level, AcsLogLevel> map = lookup;
            synchronized (map) {
                lookup.put(level, acsLevel);
            }
            return acsLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printMappings(PrintStream ps) {
        String delim = "\t";
        TreeSet<AcsLogLevel> treeSet = known;
        synchronized (treeSet) {
            for (AcsLogLevel level : known) {
                String acsLevelName = level.getEntryName();
                int levelValue = level.intValue();
                int coreLevelValue = level.getAcsLevel().value;
                ps.println(acsLevelName + "\t" + levelValue + "\t" + coreLevelValue);
            }
        }
    }
}

