/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.domainspecific;

import alma.acs.logging.AcsLogger;
import java.util.logging.Level;

public abstract class AudienceLogger {
    private final AcsLogger delegateLogger;
    private final Audience audience;

    protected AudienceLogger(AcsLogger logger, Audience audience) {
        this.delegateLogger = logger;
        this.audience = audience;
        logger.addLoggerClass(AudienceLogger.class);
    }

    public AcsLogger getLogger() {
        return this.delegateLogger;
    }

    public static void log(Level level, String msg, Throwable thr, AcsLogger acsLogger, Audience audience) {
        acsLogger.addLoggerClass(AudienceLogger.class);
        acsLogger.logToAudience(level, msg, thr, audience.getIdlName());
    }

    protected static void log(Level level, String msg, Throwable thr, AcsLogger acsLogger, Audience audience, Class<? extends AudienceLogger> staticLoggerClass) {
        acsLogger.addLoggerClass(staticLoggerClass);
        acsLogger.addLoggerClass(AudienceLogger.class);
        acsLogger.logToAudience(level, msg, thr, audience.getIdlName());
    }

    public void log(Level level, String msg, Throwable thr) {
        this.delegateLogger.logToAudience(level, msg, thr, this.audience.getIdlName());
    }

    public void severe(String msg) {
        this.delegateLogger.logToAudience(Level.SEVERE, msg, this.audience.getIdlName());
    }

    public void warning(String msg) {
        this.delegateLogger.logToAudience(Level.WARNING, msg, this.audience.getIdlName());
    }

    public void info(String msg) {
        this.delegateLogger.logToAudience(Level.INFO, msg, this.audience.getIdlName());
    }

    public void config(String msg) {
        this.delegateLogger.logToAudience(Level.CONFIG, msg, this.audience.getIdlName());
    }

    public void fine(String msg) {
        this.delegateLogger.logToAudience(Level.FINE, msg, this.audience.getIdlName());
    }

    public void finer(String msg) {
        this.delegateLogger.logToAudience(Level.FINER, msg, this.audience.getIdlName());
    }

    public void finest(String msg) {
        this.delegateLogger.logToAudience(Level.FINEST, msg, this.audience.getIdlName());
    }

    public static enum Audience {
        OPERATOR("Operator"),
        DEVELOPER("Developer"),
        SYSADMIN("Sysadmin"),
        DBA("DBA"),
        SCILOG("SciLog"),
        NO_AUDIENCE("");

        private final String idlName;

        private Audience(String idlName) {
            this.idlName = idlName;
        }

        public String getIdlName() {
            return this.idlName;
        }
    }
}

