/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import jsky.science.Flux;
import jsky.science.Wavelength;
import jsky.science.Wavelength1DArray;
import jsky.science.Wavelength1DArrayParser;
import jsky.science.WavelengthArrayParseException;

public class WavelengthArrayParserAsciiPairs
implements Wavelength1DArrayParser {
    String fWlColName;
    String fWlUnits;
    String fFluxColName;
    String fFluxUnits;
    Wavelength1DArray fArray;
    Reader fReader;

    public WavelengthArrayParserAsciiPairs(Wavelength1DArray array, InputStream istream) throws WavelengthArrayParseException {
        this(array, istream, null);
    }

    public WavelengthArrayParserAsciiPairs(Wavelength1DArray array, InputStream istream, String[] optionalArgs) throws WavelengthArrayParseException {
        this(array, new InputStreamReader(istream), optionalArgs);
    }

    public WavelengthArrayParserAsciiPairs(Wavelength1DArray array, Reader rdr, String[] optionalArgs) throws WavelengthArrayParseException {
        this.fArray = array;
        this.fReader = rdr;
        this.fWlColName = "WAVELENGTH";
        this.fWlUnits = Wavelength.ANGSTROM;
        this.fFluxColName = "FLUX";
        this.fFluxUnits = Flux.FLAM;
        if (optionalArgs != null) {
            if (optionalArgs.length > 0 && optionalArgs[0] != null) {
                this.fWlUnits = optionalArgs[0];
            }
            if (optionalArgs.length > 1 && optionalArgs[1] != null) {
                this.fFluxUnits = optionalArgs[1];
            }
        }
    }

    @Override
    public void parse() throws WavelengthArrayParseException {
        if (this.fWlUnits == null) {
            this.fWlUnits = Wavelength.ANGSTROM;
        }
        int addStep = 500;
        StreamTokenizer streamer = new StreamTokenizer(this.fReader);
        streamer.commentChar(35);
        int i = 0;
        int nToks = 0;
        boolean expectingData = false;
        try {
            int nextT = streamer.nextToken();
            ++nToks;
            while (nextT != -1) {
                if (streamer.ttype == -3) {
                    if (!streamer.sval.startsWith("E") && !streamer.sval.startsWith("e")) {
                        throw new WavelengthArrayParseException(streamer.sval + ", encountered after " + i + " valid pairs.");
                    }
                    try {
                        int ex = new Integer(streamer.sval.substring(1));
                        if (expectingData) {
                            this.fArray.setWavelengthAtIndex(i, this.fArray.getWavelengthAtIndexAsDouble(i) * Math.pow(10.0, ex));
                        }
                        this.fArray.setValueAtIndex(i - 1, this.fArray.getValueAtIndex(i - 1) * Math.pow(10.0, ex));
                    }
                    catch (Exception e) {
                        throw new WavelengthArrayParseException(streamer.sval + ", encountered after " + i + " valid pairs.");
                    }
                } else {
                    if (streamer.ttype != -2) {
                        throw new WavelengthArrayParseException(streamer.ttype + ", encountered after " + i + " valid pairs.");
                    }
                    if (i >= this.fArray.getNumPoints()) {
                        this.fArray.setNumPoints(this.fArray.getNumPoints() + addStep);
                    }
                    if (expectingData) {
                        this.fArray.setValueAtIndex(i++, streamer.nval);
                    } else {
                        this.fArray.setWavelengthAtIndex(i, new Wavelength(streamer.nval, this.fWlUnits));
                    }
                    expectingData = !expectingData;
                }
                nextT = streamer.nextToken();
                ++nToks;
            }
        }
        catch (IOException e) {
            throw new WavelengthArrayParseException(e.toString());
        }
        if (i < this.fArray.getNumPoints()) {
            this.fArray.setNumPoints(i);
        }
    }
}

