/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.manager.app;

import alma.ACS.OffShoot;
import alma.ACS.OffShootHelper;
import alma.ACS.OffShootOperations;
import alma.ACSErrTypeCommon.wrappers.AcsJBadParameterEx;
import alma.ACSErrTypeCommon.wrappers.AcsJNotImplementedEx;
import alma.ACSErrTypeCommon.wrappers.AcsJUnexpectedExceptionEx;
import alma.JavaContainerError.wrappers.AcsJContainerEx;
import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.acs.concurrent.DaemonThreadFactory;
import alma.acs.container.AdvancedContainerServices;
import alma.acs.container.ContainerServicesBase;
import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.AcsLogger;
import alma.acs.logging.ClientLogManager;
import alma.acs.nc.AcsEventPublisher;
import alma.acs.nc.AcsEventSubscriber;
import com.cosylab.CDB.DAL;
import java.lang.reflect.Constructor;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import si.ijs.maci.AdministratorOperations;

public class ManagerContainerServices
implements ContainerServicesBase,
AdvancedContainerServices {
    private final ORB orb;
    private final DAL dal;
    private final Logger logger;
    private AcsLogger componentLogger;
    private final POA clientPOA;
    private POA offshootPoa;
    private Policy[] offshootPolicies;
    private final String CLASSNAME_NC_PUBLISHER = "alma.acs.nc.NCPublisher";
    private final ThreadFactory threadFactory;

    public ManagerContainerServices(ORB orb, POA clientPOA, DAL dal, Logger logger) {
        this.orb = orb;
        this.clientPOA = clientPOA;
        this.offshootPoa = null;
        this.dal = dal;
        this.logger = logger;
        this.threadFactory = new DaemonThreadFactory(ManagerContainerServices.class.getSimpleName());
    }

    public <T extends Servant> OffShoot activateOffShoot(T servant) throws AcsJContainerServicesEx {
        this.checkOffShootServant(servant);
        OffShoot shoot = null;
        try {
            this.checkOffShootPOA();
            Object actObj = null;
            this.offshootPoa.activate_object(servant);
            actObj = this.offshootPoa.servant_to_reference(servant);
            actObj._hash(Integer.MAX_VALUE);
            this.logger.finer("offshoot of type '" + servant.getClass().getName() + "' activated as a CORBA object.");
            shoot = OffShootHelper.narrow((Object)actObj);
        }
        catch (Throwable thr) {
            String msg = "failed to activate offshoot object of type '" + servant.getClass().getName() + "' for client '" + this.getName() + "'. ";
            if (thr instanceof AcsJContainerServicesEx && thr.getCause() != null) {
                msg = msg + "(" + thr.getMessage() + ")";
                thr = thr.getCause();
            }
            this.logger.log(Level.FINE, msg, thr);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx(thr);
            throw ex;
        }
        return shoot;
    }

    public void deactivateOffShoot(java.lang.Object offshootImpl) throws AcsJContainerServicesEx {
        if (offshootImpl instanceof Servant) {
            Servant servant = (Servant)offshootImpl;
            this.checkOffShootServant(servant);
            byte[] id = null;
            try {
                id = this.offshootPoa.servant_to_id(servant);
                this.offshootPoa.deactivate_object(id);
            }
            catch (Throwable thr) {
                String msg = "failed to deactivate offshoot of type '" + servant.getClass().getName() + "' (ID=" + String.valueOf(id) + ")";
                this.logger.log(Level.WARNING, msg, thr);
                AcsJContainerServicesEx ex = new AcsJContainerServicesEx(thr);
                ex.setContextInfo(msg);
                throw ex;
            }
        } else {
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx();
            ex.setContextInfo("Not yet implemented");
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkOffShootPOA() throws AcsJContainerEx, AcsJUnexpectedExceptionEx {
        String offshootPoaName = "offshootPoa";
        POA pOA = this.clientPOA;
        synchronized (pOA) {
            try {
                this.offshootPoa = this.clientPOA.find_POA("offshootPoa", false);
            }
            catch (AdapterNonExistent e) {
                this.logger.finest("will have to create offshoot POA");
                if (this.offshootPolicies == null) {
                    this.offshootPolicies = new Policy[4];
                    this.offshootPolicies[0] = this.clientPOA.create_id_assignment_policy(IdAssignmentPolicyValue.SYSTEM_ID);
                    this.offshootPolicies[1] = this.clientPOA.create_lifespan_policy(LifespanPolicyValue.TRANSIENT);
                    this.offshootPolicies[2] = this.clientPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY);
                    this.offshootPolicies[3] = this.clientPOA.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN);
                }
                try {
                    this.offshootPoa = this.clientPOA.create_POA("offshootPoa", this.clientPOA.the_POAManager(), this.offshootPolicies);
                    this.logger.finest("successfully created offshoot POA");
                }
                catch (InvalidPolicy ex) {
                    AcsJContainerEx ex2 = new AcsJContainerEx((Throwable)ex);
                    ex2.setContextInfo("Attempted to create offshoot POA with invalid policies.");
                    throw ex2;
                }
                catch (AdapterAlreadyExists ex) {
                    throw new AcsJUnexpectedExceptionEx((Throwable)ex);
                }
            }
        }
    }

    private void checkOffShootServant(Servant servant) throws AcsJContainerServicesEx {
        if (servant == null) {
            AcsJBadParameterEx cause = new AcsJBadParameterEx();
            cause.setParameter("servant");
            cause.setParameterValue("null");
            throw new AcsJContainerServicesEx((Throwable)cause);
        }
        if (!(servant instanceof OffShootOperations)) {
            String msg = "invalid offshoot servant provided. Must implement " + OffShootOperations.class.getName();
            this.logger.fine(msg);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx();
            ex.setContextInfo(msg);
            throw ex;
        }
    }

    public AdvancedContainerServices getAdvancedContainerServices() {
        return this;
    }

    public DAL getCDB() {
        return this.dal;
    }

    public synchronized AcsLogger getLogger() {
        if (this.componentLogger == null) {
            this.componentLogger = ClientLogManager.getAcsLogManager().getLoggerForComponent(this.getName());
        }
        return this.componentLogger;
    }

    public String getName() {
        return "ManagerContainerServices";
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public String corbaObjectToString(Object objRef) {
        String str = this.orb.object_to_string(objRef);
        this.logger.finer("converted corba object reference of type " + objRef.getClass().getName() + " to the string " + str);
        return str;
    }

    public Object corbaObjectFromString(String strObjRef) {
        Object objRef = this.orb.string_to_object(strObjRef);
        this.logger.finer("converted corba object reference string " + strObjRef + " back to a corba object reference.");
        return objRef;
    }

    public Any getAny() {
        Any any = this.orb.create_any();
        if (any == null) {
            String msg = "Failed to create org.omg.CORBA.Any";
            this.logger.warning(msg);
            throw new NullPointerException(msg);
        }
        return any;
    }

    public ORB getORB() {
        return this.orb;
    }

    public void connectManagerAdmin(AdministratorOperations adminOp, boolean retryConnectOnFailure) throws AcsJContainerEx {
        throw new NO_IMPLEMENT();
    }

    public void disconnectManagerAdmin(AdministratorOperations adminOp) {
        throw new NO_IMPLEMENT();
    }

    public <T> AcsEventPublisher<T> createNotificationChannelPublisher(String channelName, Class<T> eventType) throws AcsJContainerServicesEx {
        return this.createNotificationChannelPublisher(channelName, null, eventType);
    }

    public <T> AcsEventPublisher<T> createNotificationChannelPublisher(String channelName, String channelNotifyServiceDomainName, Class<T> eventType) throws AcsJContainerServicesEx {
        AcsEventPublisher publisher = null;
        try {
            Object objRef = this.orb.resolve_initial_references("NameService");
            NamingContext ncRef = NamingContextHelper.narrow((Object)objRef);
            java.lang.Object[] args = new java.lang.Object[]{channelName, channelNotifyServiceDomainName, this, ncRef};
            Class<?> clazz = Class.forName("alma.acs.nc.NCPublisher");
            Constructor<?> constructor = clazz.getConstructor(String.class, String.class, ContainerServicesBase.class, NamingContext.class);
            publisher = (AcsEventPublisher)constructor.newInstance(args);
        }
        catch (ClassNotFoundException e) {
            this.logger.log((Level)AcsLogLevel.ERROR, "Cannot create NC publisher because the 'NCPublisher' class is not present in the classpath", e);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx((Throwable)e);
            ex.setContextInfo("'alma.acs.nc.NCPublisher' class not present in the classpath");
            throw ex;
        }
        catch (ClassCastException e) {
            this.logger.log((Level)AcsLogLevel.ERROR, "Cannot create NC publisher because loaded class 'alma.acs.nc.NCPublisher' is not of type 'AcsEventPublisher", e);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx((Throwable)e);
            ex.setContextInfo("'alma.acs.nc.NCPublisher' class does not extend 'AcsEventPublisher'");
            throw ex;
        }
        catch (Throwable e) {
            this.logger.log((Level)AcsLogLevel.ERROR, "Unexpected error while creating new AcsEventPublisher object", e);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx(e);
            throw ex;
        }
        return publisher;
    }

    public <T> AcsEventSubscriber<T> createNotificationChannelSubscriber(String channelName, Class<T> eventType) throws AcsJContainerServicesEx {
        throw new AcsJContainerServicesEx((Throwable)new AcsJNotImplementedEx("createNotificationChannelSubscriber not yet implemented in this special alarm service CS class."));
    }

    public <T> AcsEventSubscriber<T> createNotificationChannelSubscriber(String channelName, String channelNotifyServiceDomainName, Class<T> eventType) throws AcsJContainerServicesEx {
        throw new AcsJContainerServicesEx((Throwable)new AcsJNotImplementedEx("createNotificationChannelSubscriber not yet implemented in this special alarm service CS class."));
    }
}

