/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.plug;

import alma.acs.util.UTCUtility;
import com.cosylab.acs.maci.AuthenticationData;
import com.cosylab.acs.maci.ClientType;
import com.cosylab.acs.maci.ComponentInfo;
import com.cosylab.acs.maci.ImplLang;
import com.cosylab.acs.maci.IntArray;
import com.cosylab.acs.maci.MessageType;
import com.cosylab.acs.maci.RemoteException;
import com.cosylab.acs.maci.plug.ClientImpl;
import com.cosylab.acs.maci.plug.ComponentProxy;
import java.net.URI;
import java.util.logging.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import si.ijs.maci.ClientInfo;
import si.ijs.maci.ClientPOA;
import si.ijs.maci.ImplLangType;
import si.ijs.maci.Manager;
import si.ijs.maci.PingCallback;

public class ClientProxyImpl
extends ClientPOA {
    private ClientImpl client;
    private Manager manager;
    private Logger logger;

    public ClientProxyImpl(String name, Logger logger) {
        this.client = new ClientImpl(name);
        this.logger = logger;
    }

    public String name() {
        return this.client.getName();
    }

    public void disconnect() {
        try {
            this.client.disconnect();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static si.ijs.maci.ClientType toClientType(ClientType type) {
        switch (type) {
            case CLIENT: {
                return si.ijs.maci.ClientType.CLIENT_TYPE;
            }
            case ADMINISTRATOR: {
                return si.ijs.maci.ClientType.ADMINISTRATOR_TYPE;
            }
            case CONTAINER: {
                return si.ijs.maci.ClientType.CONTAINER_TYPE;
            }
        }
        throw new IllegalArgumentException("unsupported client type");
    }

    public static ImplLangType toImplLangType(ImplLang type) {
        switch (type) {
            case java: {
                return ImplLangType.JAVA;
            }
            case cpp: {
                return ImplLangType.CPP;
            }
            case py: {
                return ImplLangType.PYTHON;
            }
        }
        throw new IllegalArgumentException("unsupported implementation language type");
    }

    public si.ijs.maci.AuthenticationData authenticate(long executionId, String question) {
        try {
            AuthenticationData retVal = this.client.authenticate(executionId, question);
            return new si.ijs.maci.AuthenticationData(retVal.getAnswer(), ClientProxyImpl.toClientType(retVal.getClientType()), ClientProxyImpl.toImplLangType(retVal.getImplLang()), retVal.isRecover(), UTCUtility.utcJavaToOmg((long)retVal.getTimeStamp()), retVal.getExecutionId());
        }
        catch (RemoteException re) {
            return null;
        }
    }

    public void message(short type, String message) {
        try {
            MessageType msgType = type == 0 ? MessageType.MSG_ERROR : MessageType.MSG_INFORMATION;
            this.client.message(msgType, message);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void taggedmessage(short type, short id, String message) {
        try {
            MessageType msgType = type == 0 ? MessageType.MSG_ERROR : MessageType.MSG_INFORMATION;
            this.client.taggedmessage(msgType, id, message);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean ping() {
        try {
            return this.client.ping();
        }
        catch (RemoteException re) {
            return false;
        }
    }

    public void pingCB(PingCallback cb) {
        try {
            this.client.pingCB(cb);
        }
        catch (RemoteException re) {
            cb.ping(false);
        }
    }

    public void components_available(si.ijs.maci.ComponentInfo[] components) {
        try {
            ComponentInfo[] info = new ComponentInfo[components.length];
            for (int i = 0; i < components.length; ++i) {
                info[i] = new ComponentInfo(components[i].h, components[i].name, components[i].type, components[i].code, new ComponentProxy(components[i].name, components[i].reference));
                info[i].setContainer(components[i].container);
                info[i].setContainerName(components[i].container_name);
                info[i].setClients(new IntArray(components[i].clients));
                info[i].setInterfaces(components[i].interfaces);
                info[i].setAccessRights(components[i].access);
            }
            this.client.components_available(info);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void components_unavailable(String[] component_names) {
        try {
            this.client.components_unavailable(component_names);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("ClientProxyImpl = { ");
        sbuff.append("client = '");
        sbuff.append(this.client);
        sbuff.append("' }");
        return new String(sbuff);
    }

    public boolean login(ORB orb, Manager manager) {
        assert (orb != null);
        assert (manager != null);
        this.manager = manager;
        try {
            ClientInfo clientInfo = manager.login(this._this(orb));
            if (clientInfo != null && clientInfo.h != 0) {
                this.client.setHandle(clientInfo.h);
                this.logger.info("Successfully logged in to the Manager.");
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    public void logout() {
        if (this.manager == null || this.client.getHandle() == 0) {
            return;
        }
        try {
            this.manager.logout(this.client.getHandle());
            this.client.setHandle(0);
            this.logger.info("Successfully logged out from the Manager.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getComponent(URI curl, boolean activate) {
        if (this.manager == null || this.client.getHandle() == 0) {
            return null;
        }
        try {
            Object component = this.manager.get_service(this.client.getHandle(), curl.toString(), activate);
            if (component != null) {
                this.logger.info("Successfully obtained Component '" + curl + "'.");
                return component;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void releaseComponent(URI curl) {
        if (this.manager == null || this.client.getHandle() == 0) {
            return;
        }
        try {
            this.manager.release_component(this.client.getHandle(), curl.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

