/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import uk.ac.starlink.connect.FilestoreChooser;
import uk.ac.starlink.connect.Leaf;
import uk.ac.starlink.connect.Node;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.gui.BasicTableLoadDialog;
import uk.ac.starlink.table.gui.TableConsumer;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.gui.ShrinkWrapper;

public class FilestoreTableLoadDialog
extends BasicTableLoadDialog {
    private final FilestoreChooser chooser_;
    private final JComboBox formatSelector_;
    private final JTextField posField_;

    public FilestoreTableLoadDialog() {
        super("Filestore Browser", "Loader for files from local or remote filespace");
        final FilestoreTableLoadDialog tld = this;
        this.chooser_ = new FilestoreChooser(){

            public void leafSelected(Leaf leaf) {
                tld.getOkAction().actionPerformed(new ActionEvent(tld, 0, "OK"));
            }
        };
        this.chooser_.addDefaultBranches();
        this.add((Component)this.chooser_, "Center");
        this.formatSelector_ = new JComboBox();
        JLabel posLabel = new JLabel("Position in file: #");
        this.posField_ = new JTextField(6);
        this.posField_.addActionListener(this.getOkAction());
        String posHelp = "HDU index for FITS files or TABLE index for VOTables (optional)";
        this.posField_.setToolTipText(posHelp);
        posLabel.setToolTipText(posHelp);
        Box formatBox = Box.createHorizontalBox();
        formatBox.add(new JLabel("Table Format: "));
        formatBox.add((Component)new ShrinkWrapper((Component)this.formatSelector_));
        formatBox.add(Box.createHorizontalStrut(10));
        formatBox.add(Box.createHorizontalGlue());
        formatBox.add(new JLabel("Position in file: #"));
        formatBox.add((Component)new ShrinkWrapper((Component)this.posField_));
        formatBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)formatBox, "South");
    }

    protected void setFormatModel(ComboBoxModel formatModel) {
        this.formatSelector_.setModel(formatModel);
    }

    protected BasicTableLoadDialog.TableSupplier getTableSupplier() {
        Node node = this.chooser_.getSelectedNode();
        if (node instanceof Leaf) {
            final Leaf leaf = (Leaf)node;
            String posText = this.posField_.getText();
            final String pos = posText != null && posText.trim().length() > 0 ? posText.trim() : null;
            return new BasicTableLoadDialog.TableSupplier(){

                public StarTable getTable(StarTableFactory factory, String format) throws IOException {
                    DataSource datsrc = leaf.getDataSource();
                    if (pos != null) {
                        datsrc.setPosition(pos);
                    }
                    return factory.makeStarTable(datsrc, format);
                }

                public String getTableID() {
                    return leaf.toString() + (pos != null ? "#" + pos : "");
                }
            };
        }
        throw new IllegalArgumentException("No file selected");
    }

    public boolean isAvailable() {
        return true;
    }

    public FilestoreChooser getChooser() {
        return this.chooser_;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            this.chooser_.setEnabled(enabled);
            this.formatSelector_.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public boolean showLoadDialog(Component parent, StarTableFactory factory, ComboBoxModel formatModel, TableConsumer consumer) {
        this.chooser_.refreshList();
        return super.showLoadDialog(parent, factory, formatModel, consumer);
    }
}

