/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.io.IOException;
import javax.swing.SwingUtilities;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.gui.TableConsumer;

public abstract class LoadWorker {
    private Thread thread_;
    private final TableConsumer eater_;
    private final String id_;

    public LoadWorker(TableConsumer eater, String id) {
        this.eater_ = eater;
        this.id_ = id;
    }

    protected abstract StarTable attemptLoad() throws IOException;

    public synchronized void invoke() {
        if (this.thread_ != null) {
            throw new IllegalStateException("Already invoked!");
        }
        this.thread_ = new Thread("Table Loader (" + this.id_ + ")"){

            public void run() {
                Throwable error = null;
                StarTable table = null;
                try {
                    table = LoadWorker.this.attemptLoad();
                }
                catch (Throwable e) {
                    error = e;
                }
                final Throwable error1 = error;
                final StarTable table1 = table;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (table1 != null) {
                            LoadWorker.this.eater_.loadSucceeded(table1);
                        } else {
                            LoadWorker.this.eater_.loadFailed(error1);
                        }
                    }
                });
            }
        };
        this.eater_.loadStarted(this.id_);
        this.thread_.start();
    }

    public void interrupt() {
        if (this.thread_ != null && !this.thread_.isInterrupted()) {
            this.thread_.interrupt();
        }
    }
}

